#include "FileIo.Ch"
#include "Objects.Ch"

#define  CRLF     CHR(13) + CHR(10)

//
// Class for managing NG Entry
//
//
CLASS NgEntry

EXPORT:
   VAR   nHandle        // Handle of NgFile Container
   VAR   lWindows       // Are we under Windows ?
   //
   VAR   lShort         // What Kind of Entry ?
   VAR   cHeader        // Header of the Entry
   VAR   aContainer     // Container of the Entry
   VAR   aOffset        // Array of the Offset for Short Entry
   //
   VAR   nTopMenu       // The Top Menu > where we come from
   VAR   nSubMenu       // The Sub Menu > even if it's through a short list
   //
   VAR   nFrom          // The Offset of the Entry were we come from
                        // -1 Means "Nothing" ( Maybe a Menu ? )
   VAR   nShort         // The Position in the Short List of The Parent
   //
   VAR   nNext          // The Offset of the Next Entry
   VAR   nPrev          // The Offset of the Previous Entry
   //
   VAR   aSeeAlso       // Container of SeeAlso Reference
   VAR   aSeeOff        // Offset for SeeAlso

   METHOD   New         // Constructor
   METHOD   Read        // Read a Entry
ENDCLASS

//----------------------------------------------------------------------------//
//
METHOD New( nOffset, nHandle, lWindows ) Class NgEntry
   DEFAULT lWindows := .T.
   ::lShort     := .F.
   ::cHeader    := ""
   ::lWindows   := lWindows
//   ::aContainer := { }
   IF !(VALTYPE( nOffset )=="U") .AND. ;
      !(VALTYPE( nOffset )=="U")
      ::nHandle := nHandle
      ::Read( nOffset )
   ENDIF
RETURN Self

//----------------------------------------------------------------------------//
//
METHOD Read( nOffset ) CLass NgEntry
LOCAL nSize, nLen, cBuffer
LOCAL nCpt, nPos, cTemp
LOCAL nSeeAlso
// Determine what kind of Entry we are pointing : Text or Short List ?
FSeek( ::nHandle, nOffset )
cBuffer := SPACE( 26 )
FRead( ::nHandle, @cBuffer, 26 )
::cHeader := cBuffer
// Long Or Short
::lShort    := ( Ng2Word( SUBSTR( ::cHeader, 01, 2 ) ) == 0 )
// Total Size of Data
nSize       :=   Ng2Word( SUBSTR( ::cHeader, 03, 2 ) )
// Total Number Of Data
nLen        :=   Ng2Word( SUBSTR( ::cHeader, 05, 2 ) )
// The Top Menu where we come from
::nTopMenu  :=   Ng2Word( SUBSTR( ::cHeader, 15, 2 ) ) + 1
// The Sub Menu where we come from
::nSubMenu  :=   Ng2Word( SUBSTR( ::cHeader, 17, 2 ) ) + 1
// The Offset of the Parent
::nFrom     :=   Ng2DWord(SUBSTR( ::cHeader, 11, 4 ) )
// Position in Parent Short List
::nShort    :=   Ng2Word( SUBSTR( ::cHeader, 09, 2 ) ) + 1
// The Offset of the Next Entry
::nNext     :=   Ng2DWord(SUBSTR( ::cHeader, 23, 4 ) )
// The Offset of the Previous Entry
::nPrev     :=   Ng2DWord(SUBSTR( ::cHeader, 19, 4 ) )
// The Container Array
::aContainer := Array( nLen )
// The SeeAlso Container
::aSeeAlso   := { }
//
cBuffer   := Space( nSize )
FRead( ::nHandle, @cBuffer, nSize )
nPos      := 1
IF ::lShort
   // Short List
   ::aOffset := Array( nLen )
   // For each element we will have 2 array with :
   //    1  -  the Text
   //    2  -  the Position
   // First, we fill all positions
   FOR nCpt := 1 TO nLen
      ::aOffset[ nCpt ] := Ng2DWord( SubStr( cBuffer, nPos + 2, 4 ) )
      nPos := nPos + 6
   NEXT
   // So now, let's read all the entry
   FOR nCpt := 1 TO nLen
      cTemp := Substr( cBuffer, nPos )
      IF ::lWindows
         ::aContainer[ nCpt ] := OemToAnsi( Ng2String( cTemp ) )
      ELSE
         ::aContainer[ nCpt ] := Ng2String( cTemp )
      ENDIF
      nPos := nPos + NgStrLen( cTemp )
   NEXT
ELSE
   // Text
   ::aContainer := ""
   // So We read each line, and store it in the container
   FOR nCpt := 1 TO nLen
      cTemp := Substr( cBuffer, nPos )
      IF ::lWindows
         ::aContainer := ::aContainer + OemToAnsi( Ng2String( cTemp ) ) + CRLF
      ELSE
         ::aContainer := ::aContainer + Ng2String( cTemp ) + CRLF
      ENDIF
      nPos := nPos + NgStrLen( cTemp )
   NEXT
   // Is There some See Also ?
   nPos := Ng2Word( SUBSTR( ::cHeader, 07, 2 ) )
   IF !( nPos == 0 )
      // Pointing the SeeAlso Data
      FSeek( ::nHandle, nOffset + 26 + nPos )
      // How Many ?
      cBuffer := SPACE( 2 )
      FRead( ::nHandle, @cBuffer, 2 )
      nSeeAlso := Ng2Word( cBuffer )
      IF !( nSeeAlso == 0 )
         // What is the Size of this kind of Data ?
         nSize := nSize - nPos
         // So we take it...
         cBuffer := Space( nSize )
         FRead( ::nHandle, @cBuffer, nSize )
         // We need a two dimension array, one for the text, the other for
         //  the offset on the entry
         ::aSeeAlso := Array( nSeeAlso )
         ::aSeeOff  := Array( nSeeAlso )
         nPos := 1
         // Look at Short Entry ( just before... )
         FOR nCpt := 1 TO nSeeAlso
            ::aSeeOff[ nCpt ] := Ng2DWord( SubStr( cBuffer, nPos, 4 ) )
            nPos := nPos + 4
         NEXT
         FOR nCpt := 1 TO nSeeAlso
            cTemp := Substr( cBuffer, nPos )
            IF ::lWindows
               ::aSeeAlso[ nCpt ] := OemToAnsi( Ng2String( cTemp ) )
            ELSE
               ::aSeeAlso[ nCpt ] := Ng2String( cTemp )
            ENDIF
            nPos := nPos + NgStrLen( cTemp )
         NEXT
      ENDIF
   ENDIF
ENDIF
RETURN Self
