#include <vm.api>
#include <ClipApi.h>

//----------------------------------------------------------------------------//
// Convert a 2 Bytes String in NG to Word
CLIPPER Ng2Word()
{

	unsigned char * str;
    	unsigned int retval;
    	str     = _parc( 1 );
	retval  = ( ( str[ 1 ] ^ 0x1A ) << 8 ) | ( str[ 0 ] ^ 0x1A ) ;
    	_retni( retval );
}

//----------------------------------------------------------------------------//
// Convert a 4 Bytes String in NG to Word
CLIPPER Ng2DWord()
{
    	unsigned char * str;
	unsigned long retval;
	unsigned long ret1;
        unsigned int ret2;
	str	= _parc( 1 );
	ret1	= ( ( str[ 3 ] ^ 0x1A ) << 8 ) | ( str[ 2 ] ^ 0x1A );
	ret2	= ( ( str[ 1 ] ^ 0x1A ) << 8 ) | ( str[ 0 ] ^ 0x1A );
	retval	= ( ret1 << 16 ) | ret2;
	_retnl( retval );
}

  
//----------------------------------------------------------------------------//
// Retrieve the length of a NG String
CLIPPER NgStrLen()
{
	unsigned char * str;
	unsigned int len;
	int retval;

	retval 	= 0;
	len 	= _parclen( 1 );
	str     = _parc( 1 );
	while ( ( ( str[ retval ] ^ 0x1A ) != 0 ) && ( retval < len ) ) 
                retval ++;
	_retni( retval+1 );
}


//----------------------------------------------------------------------------//
// Convert a NG String to a Normal String
CLIPPER Ng2String()
{
	unsigned char * dest;
	HANDLE hSegment;
	unsigned char * str;
	unsigned char c;
	unsigned int len;
	unsigned int cpt;
	unsigned int rep;
	unsigned int max;
        unsigned int ret;

        cpt     = 0;
        ret     = 0;
	// Maximum size
	if ( hSegment = _xvalloc( 65000, 0) )
	{
		dest = _xvlock( hSegment );
		if ( dest != NULL )
		{
                        str     = _parc( 1 );
                        len     = _parclen( 1 );
			c       = ( str[ cpt ] ^ 0x1A );
			while ( ( c != 0 ) && ( cpt < len ) )
            		{
                		switch ( c )
                		{
                    		// Control Character
                    			case '^' :
			                        cpt ++;
			                        // what command ?
						c       = ( str[ cpt ] ^ 0x1A );
			                        // followed by a coded color on two bytes
			                        if ( ( c == 'A' ) || ( c == 'C' ) )
						    cpt ++;
                                                cpt++;
			                        break;
			                case 255 :
			                        // repeating spaces, how many ?
			                        cpt ++;
                        			max = ( str[ cpt ] ^ 0x1A );
			                        for (rep=0; rep<max;rep++)
                        			{
			                            dest[ ret ] = 0x20;
                        			    ret++;
			                        }
			                        cpt ++;
			                        break;
                    			default  :
			                        // normal char, we copy..
			                        dest[ ret ] = c;
			                        ret ++;
			                        cpt ++;
			                        break;
				}
				c       = ( str[ cpt ] ^ 0x1A );
			}
            		_retclen( dest, ret );
			_xvunlock( hSegment );
		}
		else
            		_retc( "" );
		_xvfree( hSegment );
	}
	else
		_retc( "" );
}

