#include "ViewNg.ch"
#include "FiveWin.ch"

//
#define  ID_VIEWNG      "ViewNg 1.3"
//
Static   oWnd
Static   oNgFile
Static   oNgEntry
Static   nStart
Static   oClp
// Indicate that we're searching
Static   lActive  := .F.
Static   cString
Static   nFound   := 0
//

Function Main( cFile )
   LOCAL oMenu
   LOCAL oIcon
   LOCAL oBrush
   LOCAL oDlg
   LOCAL oFont
   //
   LOCAL cTitle
   LOCAL cChoose
   LOCAL cError
   LOCAL cNotNg
   LOCAL cLangage
   LOCAL cConfirm
   LOCAL cQuit
   LOCAL cLoading
   LOCAL cWait
   LOCAL nLen
   //
   cString := SPACE( 40 )
   SET 3DLOOK     ON
   // Are we in French ?
   cLangage := GetProfStr("intl", "sLanguage")
   IF ( Upper( cLangage ) == "FRA" )
      nStart := ID_FRENCH  // Starting Number of French Resource
   ELSE
      nStart := ID_OTHER   // Starting Number of English Resource
   ENDIF
   //
   REDEFINE cError    AS CHARACTER RESOURCE nStart+IDS_ERROR
   REDEFINE cNotNg    AS CHARACTER RESOURCE nStart+IDS_NOTNG
   REDEFINE cChoose   AS CHARACTER RESOURCE nStart+IDS_CHOOSE
   REDEFINE cConfirm  AS CHARACTER RESOURCE nStart+IDS_CONFIRM
   REDEFINE cQuit     AS CHARACTER RESOURCE nStart+IDS_QUIT
   REDEFINE cLoading AS CHARACTER RESOURCE nStart+IDS_LOADING
   REDEFINE cWait    AS CHARACTER RESOURCE nStart+IDS_WAIT
   //
   IF EMPTY( cFile )
      cFile :=  cGetFile( "Norton Guide | *.NG", cChoose )
      IF EMPTY( cFile )
         RETURN .F.
      ENDIF
   ENDIF
   // Create the Main Object for our purpose
   oNgFile := NgFile():New( cFile, .T. )
   IF ( oNgFile:cTitle == Nil )
      MsgAlert( cFile + CRLF + cNotNg, cError )
      RETURN .F.
   ENDIF
   // Everything ok..
   // Please Wait, opening File....
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   nLen := MAX( Len( cLoading ), Len( cWait ) ) + 2
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   DEFINE DIALOG oDlg FROM 0,0 TO 5,nLen FONT oFont
   @ 0.2,0.5 SAY cLoading  OF oDlg
   @ 1  ,0.5 SAY cWait     OF oDlg
   ACTIVATE DIALOG oDlg CENTERED NOWAIT
   SysRefresh()
   //
   CursorWait()
   oNgFile:Open()
   //
   oMenu := BuildMenu( oNgFile )
   //
   CursorArrow()
   oDlg:End()
   RELEASE FONT oFont
   //
   cTitle := Lower( cFileName( cFile ) )
   cTitle := Upper( Left( cTitle, 1 ) ) + SubStr( cTitle, 2 )
   //
   DEFINE BRUSH oBrush STYLE BRICKS
   DEFINE ICON  oICon  RESOURCE "ViewNg"
   DEFINE WINDOW oWnd FROM 1,1 TO 20,20 ;
      MENU  oMenu                       ;
      ICON  oIcon                       ;
      BRUSH oBrush                      ;
      TITLE ID_VIEWNG + " - [" + cTitle + "]"
   SET MESSAGE OF oWnd TO oNgFile:cTitle
   DEFINE CLIPBOARD oClp OF oWnd
   ACTIVATE WINDOW oWnd MAXIMIZED       ;
      VALID MsgYesNo( cConfirm + CRLF + ID_VIEWNG, cQuit )
   //
   oNgFile:Close()
RETURN .T.


// Building the menu from the one in the NG File
FUNCTION BuildMenu( oNg )
   LOCAL oMenu
   LOCAL cBlock
   LOCAL bBlock
   LOCAL nTop, nSub
   //
   LOCAL cOpen
   LOCAL cTitle
   LOCAL cCredit
   LOCAL cQuit
   //
   REDEFINE cOpen     AS CHARACTER RESOURCE nStart+IDS_OPEN
   REDEFINE cTitle    AS CHARACTER RESOURCE nStart+IDS_TITLE
   REDEFINE cCredit   AS CHARACTER RESOURCE nStart+IDS_CREDIT
   REDEFINE cQuit     AS CHARACTER RESOURCE nStart+IDS_QUIT
   //
   MENU oMenu
      // The Info Menu..
      MENUITEM "?"
         MENU
            //
            MENUITEM cOpen          ;
               ACTION NewFile( )
            SEPARATOR
            MENUITEM cTitle         ;
               ACTION MsgInfo( oNg:cTitle, cTitle )
            MENUITEM cCredit        ;
               ACTION About( cCredit )
            SEPARATOR
            MENUITEM cQuit          ;
               ACTION oWnd:End()
         ENDMENU
      // For each Top Menu
      FOR nTop := 1 TO LEN( oNg:aMenus )
         MENUITEM oNg:aMenus[ nTop, 1 ]
            MENU
               // For each Sub Menu
               FOR nSub := 1 TO LEN( oNg:aMenus[ nTop, 2 ] )
                  // Let's get a block for this menu
                  // who's calling HandleMenu with :
                  //    N Top Menu
                  //    N Sub Menu
                  //    Text of Menu
                  cBlock := '{ || HandleMenu('     +             ;
                           ALLTRIM( STR( nTop ) )  + ',' +       ;
                           ALLTRIM( STR( nSub ) )  + ',' + '"' + ;
                           StrTran( oNg:aMenus[ nTop, 1 ],'"',' ' )   + ;
                           '"+" > "+"' + ;
                           StrTran( oNg:aMenus[ nTop, 2, nSub ],'"', ' ' ) + ;
                           '") }'
                  bBlock := &( cBlock )
                  MENUITEM oNg:aMenus[ nTop, 2, nSub ]  ;
                     BLOCK bBlock
               NEXT
            ENDMENU
      NEXT
   ENDMENU
RETURN ( oMenu )


//
PROCEDURE About( cAbout )
   LOCAL cCredit := ""
   LOCAL nCpt
   FOR nCpt := 1 TO LEN( oNgFile:aCredit )
      cCredit := cCredit + oNgFile:aCredit[ nCpt ] + CRLF
   NEXT
   MsgInfo( cCredit, cAbout )
RETURN


// Handle all the menu events
PROCEDURE HandleMenu( nTop, nSub, cMenu )
   LOCAL oDlg
   LOCAL oFont
   LOCAL cLoading
   LOCAL cWait
   LOCAL nLen
   LOCAL nOffset
   LOCAL nPos
   LOCAL aBack
   //
   oNgEntry := Nil
   //
   REDEFINE cLoading AS CHARACTER RESOURCE nStart+IDS_LOADING
   REDEFINE cWait    AS CHARACTER RESOURCE nStart+IDS_WAIT
   nLen := MAX( Len( cLoading ), Len( cWait ) ) + 2
   // Please Wait
   WHILE .T.
      DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
      DEFINE DIALOG oDlg FROM 0,0 TO 5,nLen ;
         FONT oFont
      @ 0.2,0.5 SAY cLoading  OF oDlg
      @ 1  ,0.5 SAY cWait     OF oDlg
      ACTIVATE DIALOG oDlg CENTERED NOWAIT
      // Resfresh so we see the text...
      SysRefresh()
      //
      CursorWait()
      // Read the Entry
      IF ( oNgEntry == Nil )
         oNgEntry := oNgFile:GetEntry( nTop, nSub )
      ELSE
         oNgEntry:Read( nOffset )
      ENDIF
      //
      oDlg:End()
      RELEASE FONT oFont
      // Resfresh to wait that the dialog end.
      SysRefresh()
      CursorArrow()
      //
      IF oNgEntry:lShort
         aBack := ShowShort( nPos, cMenu )
      ELSE
         aBack := ShowLong( nPos, cMenu )
      ENDIF
      IF ( aBack[ 1 ] == -1 )
         Exit
      ENDIF
      nOffset := aBack[ 1 ]
      nPos    := aBack[ 2 ]
   ENDDO
RETURN

// Show a short entry
FUNCTION ShowShort( nPos, cMenu )
   LOCAL oDlg
   LOCAL nOffset
   LOCAL oLbx
   LOCAL oFont
   LOCAL nShort := Nil
   DEFAULT nPos := 1
   //
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   DEFINE DIALOG oDlg FROM 0,0 TO 24,79   ;
      TITLE cMenu
   @ 4,1 LISTBOX oLbx                     ;
         VAR nPos                         ;
         SIZE 311,175                     ;
         ITEMS   oNgEntry:aContainer      ;
         ON DBLCLICK IIF( oNgEntry:aOffset[oLbx:GetPos()]<>-1, oDlg:End(1), ) ;
         FONT oFont                       ;
         PIXEL                            ;
         OF oDlg
   //
   //SET KEY VK_SPACE TO Search( oLbx )
   SetKey( VK_SPACE, { || Search( oLbx ) } )
   //
   ACTIVATE DIALOG oDlg CENTERED
   RELEASE FONT oFont
   //
   SET KEY VK_SPACE TO
   //
   IF ( oDlg:nResult == 1 )
      // Go to next entry
      nOffset := oNgEntry:aOffset[ nPos ]
   ELSE
      // Come Back
      nOffset := oNgEntry:nFrom
      nShort  := oNgEntry:nShort
   ENDIF
   //
RETURN { nOffset, nShort }

// Search in a Short List
Function Search( oLbx )
   LOCAL oDlg
   LOCAL cSearch
   LOCAL cOk
   LOCAL cCancel
   LOCAL cTemp
   // When can activate one search at a time....
   IF !lActive
      lActive := .T.
      //
      REDEFINE cSearch  AS CHARACTER RESOURCE nStart+IDS_SEARCH
      REDEFINE cOk      AS CHARACTER RESOURCE nStart+IDS_OK
      REDEFINE cCancel  AS CHARACTER RESOURCE nStart+IDS_CANCEL
      cTemp := cString
      //
      DEFINE DIALOG oDlg            ;
         FROM 01,01 TO 07,25        ;
         TITLE cSearch
      @ 0.5,01 GET cString          ;
         PICTURE "@S20"             ;
         OF oDlg
      @ 02,0.5 BUTTON cOk           ;
         SIZE 40,BUTTON_SIZE        ;
         ACTION oDlg:End()          ;
         OF oDlg
      @ 02,07 BUTTON cCancel        ;
         SIZE 40,BUTTON_SIZE        ;
         ACTION ( cString := "", oDlg:End() ) ;
         OF oDlg
      ACTIVATE DIALOG oDlg CENTERED
      //
      IF !EMPTY( cString )
         IF !( Upper( AllTrim( cTemp ) ) == Upper( AllTrim( cString ) ) )
            nFound := 1
         ENDIF
         nFound := ASCAN( oLbx:aItems,                         ;
            { |x| Upper( AllTrim( cString ) ) $ Upper( x ) },  ;
            nFound + 1 )
         IF !( nFound == 0 )
            oLbx:Select( nFound )
            oLbx:Refresh()
         ENDIF
      ENDIF
      //
      lActive := .F.
   ENDIF
Return Nil



// Show a Long Entry
FUNCTION ShowLong( nPos, cMenu )
   LOCAL oDlg
   LOCAL oMGet
   LOCAL oFont
   LOCAL aRetVal
   LOCAL lButton
   LOCAL lNext
   LOCAL lPrev
   LOCAL lSee
   LOCAL cNext
   LOCAL cPrev
   LOCAL cCopy
   LOCAL nSee
   LOCAL cSeeStr := ""
   DEFAULT nPos := 1
   //
   REDEFINE cNext AS CHARACTER RESOURCE nStart+IDS_NEXT
   REDEFINE cPrev AS CHARACTER RESOURCE nStart+IDS_PREV
   REDEFINE cCopy AS CHARACTER RESOURCE nStart+IDS_COPY
   //
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   DEFINE DIALOG oDlg FROM 0,0 TO 24,79 ;
      TITLE cMenu
   lPrev := ( oNgEntry:nPrev <> -1 )
   lNext := ( oNgEntry:nNext <> -1 )
   lSee  := !Empty( oNgEntry:aSeeAlso )
   @ 01,000 BUTTON cPrev               ;
      SIZE 40,BUTTON_SIZE              ;
      ACTION   oDlg:End( 5 )           ;
      OF       oDlg                    ;
      PIXEL                            ;
      WHEN     lPrev
   @ 01,050 BUTTON cNext               ;
      SIZE 40,BUTTON_SIZE              ;
      ACTION   oDlg:End( 6 )           ;
      OF       oDlg                    ;
      PIXEL                            ;
      WHEN     lNext
   @ 01,100 COMBOBOX cSeeStr           ;
      SIZE  090,Nil                    ;
      ITEMS oNgEntry:aSeeAlso          ;
      ON CHANGE oDlg:End( 7 )          ;
      OF oDlg                          ;
      PIXEL                            ;
      WHEN     lSee
   @ 01,200 BUTTON cCopy SIZE 40,BUTTON_SIZE ;
      ACTION  oClp:SetText( oMGet:GetSel() ) ;
      PIXEL                            ;
      OF oDlg
   @ 16,01 GET oMGet                   ;
      VAR oNgEntry:aContainer          ;
      MULTILINE                        ;
      READONLY                         ;
      SIZE 311,164                     ;
      FONT oFont                       ;
      PIXEL                            ;
      OF oDlg
   // We set focus on the text, so we can Copy some parts to the ClipBoard
   // on first attempt.
//   oMGet:SetFocus()
   ACTIVATE DIALOG oDlg CENTERED       ;
      ON PAINT oMGet:SetFocus()
   RELEASE FONT oFont
   //
   DO CASE
      // Previous
      CASE oDlg:nResult == 5
         aRetVal := { oNgEntry:nPrev, Nil }
      // Next
      CASE oDlg:nResult == 6
         aRetVal := { oNgEntry:nNext, Nil }
      // See Also
      CASE oDlg:nResult == 7
         nSee := ASCAN( oNgEntry:aSeeAlso, cSeeStr )
         aRetVal := { oNgEntry:aSeeOff[ nSee ], 1 }
      OTHERWISE
         aRetVal := { oNgEntry:nFrom, oNgEntry:nShort }
   ENDCASE
   //
RETURN aRetVal

// Open a New NG File
PROCEDURE NewFile( )
   LOCAL cError, cNotNg, cChoose
   LOCAL cLoading, cWait, oDlg, oMenu, cTitle, oFont, nLen
   LOCAL cNewFile, oNewNg
   //
   REDEFINE cError    AS CHARACTER RESOURCE nStart+IDS_ERROR
   REDEFINE cNotNg    AS CHARACTER RESOURCE nStart+IDS_NOTNG
   REDEFINE cChoose   AS CHARACTER RESOURCE nStart+IDS_CHOOSE
   REDEFINE cLoading AS CHARACTER RESOURCE nStart+IDS_LOADING
   REDEFINE cWait    AS CHARACTER RESOURCE nStart+IDS_WAIT
   //
   cNewFile :=  cGetFile( "Norton Guide | *.NG", cChoose )
   IF EMPTY( cNewFile )
      RETURN
   ENDIF
   // Create the Main Object for our purpose
   oNewNg := NgFile():New( cNewFile, .T. )
   IF ( oNewNg:cTitle == Nil )
      MsgAlert( cNewFile + CRLF + cNotNg, cError )
      RETURN
   ENDIF
   // Everything ok..
   // Please Wait, opening File....
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   nLen := MAX( Len( cLoading ), Len( cWait ) ) + 2
   DEFINE FONT oFont NAME "FixedSys" SIZE 0,-8
   DEFINE DIALOG oDlg FROM 0,0 TO 5,nLen FONT oFont
   @ 0.2,0.5 SAY cLoading  OF oDlg
   @ 1  ,0.5 SAY cWait     OF oDlg
   ACTIVATE DIALOG oDlg CENTERED NOWAIT
   SysRefresh()
   //
   CursorWait()
   oNewNg:Open()
   //
   oMenu := BuildMenu( oNewNg )
   //
   CursorArrow()
   oDlg:End()
   RELEASE FONT oFont
   //
   cTitle := Lower( cFileName( cNewFile ) )
   cTitle := Upper( Left( cTitle, 1 ) ) + SubStr( cTitle, 2 )
   //
   oNgFile:Close()
   //
   oWnd:cTitle( ID_VIEWNG + " - [" + cTitle + "]" )
   oWnd:SetMenu( oMenu )
   oNgFile  := oNewNg
   SET MESSAGE OF oWnd TO oNgFile:cTitle
   oNgEntry := Nil
   //
RETURN
