//===========================================================
// SPAD.H -- Header File 
// Copyright (c) 1993 Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#define WIN16     TRUE
#define WIN31

#define INT       int
#define UINT      WORD
#define APIENTRY  PASCAL
#define WNDPROC   FARPROC

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};

// Structure containing segment info
typedef struct {
	LONG lLoc;							//Ptr to data in file,RAM or swap
	WORD fFlags;						//Status flags
	WORD wSize;							//Size of segment
} SEGLIST;
typedef SEGLIST far * LPSEGLIST;

// Structure containing RAM buffer data
typedef struct {
	HGLOBAL hBuff;						//Handle of data buffer
	INT sLRU;							//Least recently used cnt
	LPSEGLIST lpSegListPtr;				//Back link to Seg list entry
} BUFFDATA;

// Structure containing file editing info
typedef struct {
	HFILE hSrcFile;						//Handle of file being edited
	HFILE hTempFile;					//Handle of temp swap file
	char szFileName[144];				//Name of file being edited
	char szSwapName[144];				//Name of temp swap file
	WORD fFlags;						//Status flags

	INT sTabs;							//Tab value
	INT sEBoxLines;						//Number of visible lines in EBox
	LONG lFileSize;						//Length of file
	UINT wScrollMax;					//Max scroll bar value

	HGLOBAL hSegList;					//Handle of the seg list buffer
	LPSEGLIST lpbl;						//Ptr to the segment list
	INT sActBuff;						//Buffer num of active buffer
	BUFFDATA bd[NUMBUFFS];				//Array of buffer info structures
} FILEDATA;
typedef FILEDATA * PFILEDATA;
typedef FILEDATA far * LPFILEDATA;

#define BUFFSIZE             65536
#define SEGLISTSIZE          65536 / sizeof (SEGLIST)
#define STDREADLEN           16384
#define MINBLKSIZE            8192
#define MAXBLKSIZE           24576

#define FOP_OPEN             1 
#define FOP_READ             2 
#define FOP_WRITE            3 
#define FOP_SEEK             4 
#define FOP_CLOSE            5 
#define FOP_FIND             6 

#define FLAG_BUFFNUMMASK     0x000F 
#define FLAG_STATEMASK       0x00F0 
#define FLAG_DIRTY           0x0100 
#define FLAG_EVERDIRTY       0x0800 
#define FLAG_LASTSEG         0x1000 

#define STAT_SEGINFILE       0x0010 
#define STAT_SEGINSWAP       0x0020 
#define STAT_SEGINBUFF       0x0030 
#define STAT_SEGINEDIT       0x0040 

#define FFLAG_SELALL         0x0400 
#define FFLAG_VIEWONLY       0x0800 
#define FFLAG_RONLY          0x1000 
#define FFLAG_WWRAP          0x2000 
#define FFLAG_PORPFONT       0x4000 
#define FFLAG_FIXEDFONT      0x8000 

#define SFLAG_INIT           0x0001 
#define SFLAG_FFIRST         0x0002 
#define SFLAG_SEARCHING      0x0004 
#define SFLAG_CMDLINE        0x0008 
#define SFLAG_SWITCHSTART    0x0010 
#define SFLAG_PASTING        0x0020 

//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);
BOOL CALLBACK SetTabsDlgProc (HWND, UINT, UINT, LONG);
LONG CALLBACK EditWndSCProc(HWND, UINT, UINT, LONG);

INT GetFreeBuffer (FILEDATA *, INT *);
void DisplayCurrStatus (HWND);
LONG FileOps (HFILE *, INT, LONG, LONG, INT *);
INT InitFile (LPSTR, PFILEDATA, HWND, LONG, INT);
INT WriteToFile (HWND, PFILEDATA, char *);
INT SaveFile (HWND, PFILEDATA);
INT TermFile (HWND, PFILEDATA);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyWritePrivateProfileInt (char *, char *, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
BOOL MyYield (void);
void PrintError (HWND, INT);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyGetSavename (HWND, char *, INT, char *, INT);
HWND MyDispFindtextBox (HWND, char far *, INT, DWORD);
HWND MyDispReptextBox (HWND, char far *, INT, char far *, INT, DWORD);
BOOL MyGetFont (HWND, LPLOGFONT, INT *, COLORREF *, DWORD);
//
// Program specific prototypes
//
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoSetFocusMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoInitMenuMain (HWND, UINT, UINT, LONG);
LONG DoVScrollMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
LONG DoMyMsgOpenMain (HWND, UINT, UINT, LONG);
LONG DoMyMsgReformatMain (HWND, UINT, UINT, LONG);
LONG DoFindNextMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainCtlEBox (HWND, UINT, HWND, UINT);
LONG DoMainMenuNew (HWND, UINT, HWND, UINT);
LONG DoMainMenuOpen (HWND, UINT, HWND, UINT);
LONG DoMainMenuSave (HWND, UINT, HWND, UINT);
LONG DoMainMenuSaveAs (HWND, UINT, HWND, UINT);
LONG DoMainMenuROnly (HWND, UINT, HWND, UINT);
LONG DoMainMenuExit (HWND, UINT, HWND, UINT);
LONG DoMainMenuUndo (HWND, UINT, HWND, UINT);
LONG DoMainMenuCut (HWND, UINT, HWND, UINT);
LONG DoMainMenuCopy (HWND, UINT, HWND, UINT);
LONG DoMainMenuPaste (HWND, UINT, HWND, UINT);
LONG DoMainMenuSelectAll (HWND, UINT, HWND, UINT);
LONG DoMainMenuWWrap (HWND, UINT, HWND, UINT);
LONG DoMainMenuFind (HWND, UINT, HWND, UINT);
LONG DoMainMenuFindNext (HWND, UINT, HWND, UINT);
LONG DoMainMenuReplace (HWND, UINT, HWND, UINT);
LONG DoMainMenuSelFont (HWND, UINT, HWND, UINT);
LONG DoMainMenuDefPFont (HWND, UINT, HWND, UINT);
LONG DoMainMenuDefFFont (HWND, UINT, HWND, UINT);
LONG DoMainMenuSetTabs (HWND, UINT, HWND, UINT);
LONG DoMainMenuAbout (HWND, UINT, HWND, UINT);
//
// Utility function prototypes
//
#define	ERR_OUT_OF_MEMORY       -1
#define	ERR_FILE_TOO_BIG        -2
#define	ERR_FILEREAD            -3
#define	ERR_FILEWRITE           -4
#define	ERR_FILESEEK            -5
#define	ERR_SCROLL              -6
#define	ERR_NOTFOUND            -7
#define	ERR_CANCELED            -8
#define	ERR_TEMPDIRFULL         -9
#define	ERR_SYNTAX              -10
#define	ERR_NUMTOOBIG           -11
#define	ERR_NODISKSPACE         -12
#define	ERR_LOSTSOURCEFILE      -13
#define	ERR_CLIPDATATOOBIG      -14
#define	ERR_FILEDATATOOBIG      -15
#define	ERR_CANTOPENCLIP        -16
#define	ERR_CANTSETCLIP         -17
#define	ERR_TOOBIGMARK          -18

// Error nums: -64 to -249 are file open error codes
#define	ERR_FOPEN_ERR           -63   //Err codes start at 1
#define	ERR_FILE_NOT_FOUND      -65
#define	ERR_PATH_NOT_FOUND      -66
#define	ERR_BADHANDLE           -69
#define	ERR_INVALID_DRIVE       -78

#define MYMSG_REFORMAT          WM_USER+100
#define MYMSG_OPEN              WM_USER+101

//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"
#define     PRO_XSIZE     "WinSizeX"
#define     PRO_YSIZE     "WinSizeY"
#define     PRO_TABS      "Tabs"
#define     PRO_FLAGS     "Flags"
#define     PRO_FONT1     "Font_lfHeight"
#define     PRO_FONT2     "Font_lfWidth"
#define     PRO_FONT3     "Font_lfEscapement"
#define     PRO_FONT4     "Font_lfOrientation"
#define     PRO_FONT5     "Font_lfWeight"
#define     PRO_FONT6     "Font_lfItalic"
#define     PRO_FONT7     "Font_lfUnderline"
#define     PRO_FONT8     "Font_lfStrikeOut"
#define     PRO_FONT9     "Font_lfCharSet"
#define     PRO_FONT10    "Font_lfOutPrecision"
#define     PRO_FONT11    "Font_lfClipPrecision"
#define     PRO_FONT12    "Font_lfQuality"
#define     PRO_FONT13    "Font_lfPitchAndFamily"
#define     PRO_FONT14    "Font_lfFaceName"

//
// Resource Idendifiers
//
#define     IDD_EBOX         100
#define     IDD_VSB          101

#define     IDM_FILE         0
#define     IDM_EDIT         1
#define     IDM_SEARCH       2
#define     IDM_HELP         3

#define     IDM_NEW          200
#define     IDM_OPEN         201
#define     IDM_SAVE         202
#define     IDM_SAVEAS       203
#define     IDM_RONLY        204
#define     IDM_EXIT	     205

#define     IDM_UNDO         210
#define     IDM_CUT	         211
#define     IDM_COPY         212
#define     IDM_PASTE        213
#define     IDM_DELETE       214
#define     IDM_SELALL       215
#define     IDM_WORDWRAP     217

#define     IDM_FIND         220
#define     IDM_FINDNEXT     221
#define     IDM_REPLACE      222

#define     IDM_SELFONT      230
#define     IDM_DEFPORP		 231
#define     IDM_DEFFIXED	 232
#define     IDM_SETTABS		 233

#define     IDM_ABOUT	     250

#define     IDD_TABVAL       300

#define     IDD_PROGSTR      600
#define     IDD_COPYRIGHT    601
#define     IDD_COPYDATE     602



