/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that the above copyright notice and all other copyright
 * notices listed herein, as well as the accompanying text appear unaltered
 * in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */

/*
 * Routines to select satellites sites and various attributes and to
 * manipulate the active list.
 *
 * Needs to be re-done.
 */

#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <time.h>

#include "resource.h"
#include "vstdefs.h"
#include "constant.h"
#include "vsttype.h"
#include "vstextrn.h"

static HWND hSiteListbox, hSatListbox, hSite, hSatellite, hDuration;
static HWND hMinElevation, hSelbox, hStartTime, hStepTime;
static int lsat=-1, lsite=-1, sbid=-1;
static satellite_t *osatp;
static site_t *ositep;
static double od, ost, osp, om;
static int ou;

void
MoreHook(HWND hwnd, select_t *selp, satellite_t *satp,
         site_t *sitep, int *flagp)
{
    extern void *LibFunc(const char *), LibClose(void);
    void (*SettingsHook)(int, HWND, select_t *, satellite_t *, site_t *, int *);

    SettingsHook = (void (*)) LibFunc("SettingsHook");
    if (SettingsHook == NULL) {
        LibClose();
        usermsg(dllinvalidmsg);
    }
    else
        (*SettingsHook)(VSTVERSION, hwnd, selp, satp, sitep, flagp);
}

struct ButtonTag {
    int fval, bval, oldf;
};

static struct ButtonTag BtnTab[16] = {
    SE_RTD_BOA,     IDC_SETTINGS_RTD_BOA,  0,
    SE_RTD_POA,     IDC_SETTINGS_RTD_POA,  0,
    SE_RTD_BEEP,    IDC_SETTINGS_RTD_BEEP, 0,
    SE_RTD_BMP,     IDC_SETTINGS_RTD_BMP,  0,
    SE_RTD_DIC,     IDC_SETTINGS_RTD_DIC,  0,
    SE_RTD_UTC,     IDC_SETTINGS_RTD_UTC,  0,
    SE_RTD_LOC,     IDC_SETTINGS_RTD_LOC,  0,
    SE_RTD_SLT,     IDC_SETTINGS_RTD_SLT,  0,
    SE_GTR_UTC,     IDC_SETTINGS_GTR_UTC,  0,
    SE_GTR_LOC,     IDC_SETTINGS_GTR_LOC,  0,
    SE_GTR_SLT,     IDC_SETTINGS_GTR_SLT,  0,
    SE_RTD_HIC,     IDC_SETTINGS_RTD_HIC,  0,
    SE_RTD_SIM,     IDC_SETTINGS_SIMULATE, 0,
    SE_RTD_USERA,	IDC_SETTINGS_UA, 0,
    SE_RTD_USERB,	IDC_SETTINGS_UB, 0,
    -1,             -1,
};


void
setbutton(HWND hwnd, int id, BOOL flag)
{
    SendDlgItemMessage(hwnd, id, BM_SETCHECK, flag ? (WPARAM) 1 : 0, (LPARAM) 0);
}
    

#define flag_toggle(flagp, value)	*flagp ^= value

static void
clrbtnflgs()
{
    register struct ButtonTag *btp;
    for (btp = BtnTab; btp->fval != -1; btp++)
        btp->oldf = 0;
    om = ost = od = osp = -2.0;
    osatp = NULL, ositep = NULL;
    ou = -2;
}

static void
setbuttons(HWND hwnd, int state)
{
	register struct ButtonTag *btp;
	int p;

	for (btp = BtnTab; btp->fval != -1; btp++) {
		p = btp->fval & state;
		if (p != btp->oldf)
			setbutton(hwnd, btp->bval, p ? TRUE : FALSE);        
		btp->oldf = p;
	}
}


static int
checkbuttons(hwnd, wParam, flagp)
HWND hwnd;
WPARAM wParam;
unsigned int *flagp;
{
    int cmd;

	cmd = LOWORD(wParam);

    switch (cmd) {
    case IDOK:
    case IDMORE:
    case IDSAVE:
    case IDMODIFY:
	case IDADDSEL:
	case IDDELSEL:
	case IDC_SETTINGS_SHOWSAT:
    case IDC_SETTINGS_SHOWLOC:
        return cmd;
    default:
		break;
    }
    
    if (HIWORD(wParam) != BN_CLICKED)
        return -1;
        
    switch (cmd) {
    case IDC_SETTINGS_RTD_BEEP:
        flag_toggle(flagp, SE_RTD_BEEP);
        goto bset;
        
    case IDC_SETTINGS_RTD_BOA:
        flag_toggle(flagp, SE_RTD_BOA);
        goto bset;

    case IDC_SETTINGS_RTD_POA:
        flag_toggle(flagp, SE_RTD_POA);
        goto bset;

    case IDC_SETTINGS_RTD_BMP:
        flag_toggle(flagp, SE_RTD_BMP);
        goto bset;

    case IDC_SETTINGS_RTD_DIC:
        flag_toggle(flagp, SE_RTD_DIC);
        goto bset;

    case IDC_SETTINGS_RTD_HIC:
        flag_toggle(flagp, SE_RTD_HIC);
        goto bset;
        
    case IDC_SETTINGS_SIMULATE:
        flag_toggle(flagp, SE_RTD_SIM);
        goto bset;
        
    case IDC_SETTINGS_UA:
    	flag_toggle(flagp, SE_RTD_USERA);
    	goto bset;
    	
    case IDC_SETTINGS_UB:
    	flag_toggle(flagp, SE_RTD_USERB);
    	goto bset;
        
    case IDC_SETTINGS_RTD_SLT:
		*flagp |= SE_RTD_SLT;
		*flagp &= ~(SE_RTD_UTC|SE_RTD_LOC);
		goto bset;

    case IDC_SETTINGS_RTD_UTC:
        *flagp |= SE_RTD_UTC;
        *flagp &= ~(SE_RTD_SLT|SE_RTD_LOC);
        goto bset;

    case IDC_SETTINGS_RTD_LOC:
        *flagp |= SE_RTD_LOC;
        *flagp &= ~(SE_RTD_SLT|SE_RTD_UTC);
        goto bset;

    case IDC_SETTINGS_GTR_SLT:
        *flagp |= SE_GTR_SLT;
        *flagp &= ~(SE_GTR_UTC|SE_GTR_LOC);
        goto bset;
                
    case IDC_SETTINGS_GTR_UTC:
        *flagp |= SE_GTR_UTC;
        *flagp &= ~(SE_GTR_SLT|SE_GTR_LOC);
        goto bset;

    case IDC_SETTINGS_GTR_LOC:
        *flagp |= SE_GTR_LOC;
        *flagp &= ~(SE_GTR_SLT|SE_GTR_UTC);
    bset:
        setbuttons(hwnd, *flagp);
        break;
        
     default: /* Warning: must return -1 */
        break;
     }
     return -1;
}

static void
lselect(hwnd, index)
HWND hwnd;
int index;
{
    SendMessage(hwnd, LB_SETCURSEL, (WPARAM) index, (LPARAM) 0);
    SendMessage(hwnd, LB_SETTOPINDEX, (WPARAM)
        ( ((index-2) < 0) ? 0 : (index - 2) ) , (LPARAM) 0);
}

static BOOL
OnReturn(hwnd, selpp, satpp, sid, sitepp, stid,
		 startp, durp, stepp, minelevp, updp)
HWND hwnd;
select_t **selpp;
satellite_t **satpp;
int *sid;
site_t **sitepp;
int *stid;
double *startp, *durp, *stepp, *minelevp;
int *updp;
{
    satellite_t *satp;
    site_t *sitep;
    double f;
    int d, error = FALSE;
    select_t *sp;

    if (!(satp = findSatbyID(*sid))) {
		GetEditText(hwnd, IDC_SETTINGS_SATELLITE, tmpbuf, BUFLEN);
        if (!(satp = findSatbyName(tmpbuf))) {
	        usermsg("Satellite Not Found");
    	    error = TRUE;
        }
    }
    if (!error) {
        *satpp = satp;
       	*sid = satp->s_lbid;
        SendMessage(hSatellite, WM_SETTEXT, (WPARAM) 0, (LPARAM) satp->s_name);
    }
    if (!(sitep = findSitebyID(*stid))) {
		GetEditText(hwnd, IDC_SETTINGS_LOCATION, tmpbuf, BUFLEN);
        if (!(sitep = findSitebyName(tmpbuf))) {
            usermsg("Site Not Found");
   	        error = TRUE;
       	}
    }
    if (!error) {
        *sitepp = sitep;
       	*stid = sitep->c_lbid;
        sprintf(tmpbuf,"%s, %s",sitep->c_name, sitep->c_locale);
   	    SendMessage(hSite, WM_SETTEXT, (WPARAM)0, (LPARAM) tmpbuf);
   	}
    if (GetEditText(hwnd, IDC_SETTINGS_GTR_STEPTIME, tmpbuf, 64)) {
        f = atof(tmpbuf);
        if (f <= 0.0) {
            usermsg("Step Time Cannot Be Negative Or Zero!");
            error = TRUE;
        }
        else {
            *stepp = f / SPD;
        }
    }
    if (GetEditText(hwnd, IDC_SETTINGS_GTR_DURATION, tmpbuf, 64)) {
        f = atof(tmpbuf);
        if (f <= 0.0) {
            usermsg("Duration cannot be negative or zero!");
            error = TRUE;
        }
        else
            *durp = f;
    }
    if (GetEditText(hwnd, IDC_SETTINGS_MINELEVATION, tmpbuf, 64)) {
        if (sscanf(tmpbuf, "%lf", &f) != 1) {
            usermsg("Invalid Value for Minimum Elevation"); 
            error = TRUE;
        }
        else
            *minelevp = f * CDR;
    }
    if (GetEditText(hwnd, IDC_SETTINGS_GTR_STARTTIME, tmpbuf, 64)) {
        if (tmpbuf[0] == '*' && tmpbuf[1] == 0)
            *startp = -1.0;
        else {
            if ((f = dateStrtoTime(tmpbuf)) < 0.0 ) {
                usermsg("Invalid Date/Time");
                error = TRUE;
            }
            else
                *startp = f;
        }
    }
    if (GetEditText(hwnd, IDC_SETTINGS_RTD_UPD, tmpbuf, 64)) {
        d = 0;
        if (sscanf(tmpbuf, "%d", &d) != 1 || d <= 0) {
            usermsg("Invalid Update Time");
            error = TRUE;
        }
        else
            *updp = d;
    }
    if (satp && sitep) {
        sp = findSelectionbyName(satp, sitep);
        if (!sp) {
            SendMessage(hSelbox, LB_SETCURSEL, (WPARAM) -1, (LPARAM) 0);
            sbid = -1;
        }
        else if (sp->sl_index != sbid) {
            *selpp = sp;
            lselect(hSelbox, sbid = sp->sl_index);
        }
    }
    return error;
}

static void
setControls(hwnd, satp, sitep, start, dur, step, minelev, upd, flags)
HWND hwnd;
satellite_t *satp;
site_t *sitep;
double start, dur, step, minelev;
int upd,flags;
{
	double tstart;
	int tupd;
	BOOL r;
	
    if (satp) {
        r = GetEditText(hwnd, IDC_SETTINGS_SATELLITE, tmpbuf, BUFLEN);
        if (!r || strcmp(tmpbuf, satp->s_name)) {
            SendMessage(hSatellite, WM_SETTEXT, (WPARAM) 0, (LPARAM) satp->s_name);
            lselect(hSatListbox, satp->s_lbid);
        }
    }
    if (sitep) {
        r = GetEditText(hwnd, IDC_SETTINGS_LOCATION, textbuf, BUFLEN);
        sprintf(tmpbuf,"%s, %s", sitep->c_name, sitep->c_locale);
        if (!r || strcmp(textbuf, tmpbuf)) {
            SendMessage(hSite, WM_SETTEXT, (WPARAM) 0, (LPARAM) tmpbuf);
            lselect(hSiteListbox, sitep->c_lbid);
        }
    }

    r = GetEditText(hwnd, IDC_SETTINGS_GTR_STEPTIME, textbuf, BUFLEN);
    if (!r || (atof(textbuf) != (step * SPD))) {
        sprintf(tmpbuf,"%-.0lf", step * SPD);
        SendMessage(hStepTime, WM_SETTEXT, (WPARAM) 0, (LPARAM) tmpbuf);
    }

	r = GetEditText(hwnd, IDC_SETTINGS_GTR_DURATION, textbuf, BUFLEN);
	if (!r || (atof(textbuf) != dur)) {
        sprintf(tmpbuf,"%-.2lf", dur);
        SendMessage(hDuration, WM_SETTEXT, (WPARAM) 0, (LPARAM) tmpbuf);
    }

	r = GetEditText(hwnd, IDC_SETTINGS_MINELEVATION, textbuf, BUFLEN);
    if (!r || (atof(textbuf) != (minelev*CRD))) {
        sprintf(tmpbuf,"%-.0lf", minelev * CRD);
        SendMessage(hMinElevation, WM_SETTEXT, (WPARAM) 0, (LPARAM) tmpbuf);
    }

	r = GetEditText(hwnd, IDC_SETTINGS_GTR_STARTTIME, tmpbuf, BUFLEN);
    if ((tmpbuf[0] == '*') && (tmpbuf[1] == 0))
        tstart = -1.0;
    else
        tstart = dateStrtoTime(tmpbuf);
        
    if (!r || (start != tstart)) {
        if (start != -1.0) {
            dateStr(start, sitep, SE_GTR_UTC, 0, tmpbuf);
            SendMessage(hStartTime, WM_SETTEXT, (WPARAM) 0, (LPARAM) tmpbuf);
        }
        else 
            SendMessage(hStartTime, WM_SETTEXT, (WPARAM) 0, (LPARAM) "*");
    }

	r = GetEditText(hwnd, IDC_SETTINGS_RTD_UPD, tmpbuf, BUFLEN);
	tupd = -1;
	sscanf(tmpbuf, "%d", &tupd);
	if (!r || (tupd != upd)) {
        sprintf(tmpbuf,"%d", upd);
        SendDlgItemMessage(hwnd, IDC_SETTINGS_RTD_UPD, WM_SETTEXT, (WPARAM)0,
            (LPARAM) tmpbuf);
    }

    setbuttons(hwnd, flags);
}


static int
setSel(hwnd, selp, satpp, sitepp, startp, durp, stepp, minelevp, updp, flagsp)
HWND hwnd;
select_t *selp;
satellite_t **satpp;
site_t **sitepp;
double *startp, *durp, *stepp, *minelevp;
int *updp;
unsigned int *flagsp;
{
    track_t *tp;

    if (!selp)
        return FALSE;

    if (currentSel != selp &&
		( (serverInfo[0].srv_state == ST_SRV_RUNNING) ||
          (serverInfo[1].srv_state == ST_SRV_RUNNING)
		) && !yesno("Radio/Rotator Control running. Are you sure you want \
to change the current satellite ?"))
                return 0;

    tp = selp->sl_tp;

    *satpp = tp->satp;
    *sitepp = tp->sitep;
    *startp = tp->starttime;
    *durp = tp->duration;
    *stepp = tp->steptime;
    *minelevp = tp->minelevation;
    *updp = selp->updatetime;
    *flagsp = selp->flags;

    setControls(hwnd, tp->satp, tp->sitep, tp->starttime, tp->duration,
        tp->steptime, tp->minelevation, selp->updatetime, selp->flags);

    currentSel = selp;

    lselect(hSelbox, selp->sl_index);
    return 1;
}

BOOL CALLBACK
GetSetProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
        POINT *p;
        static site_t *sitep;
        static satellite_t *satp;
        static select_t *selp;
        static int flag; /* must be static */
        static int flags;
        static int updateTime;
        int i, cmd;
        HDC hdc;
        extern HFONT hPica;
        select_t *tmpsp;

        if (message == WM_MOUSEMOVE)
            return TRUE;
            
        switch(message) {
            case WM_INITDIALOG:
                p = DialogPos(Gwnd, hwnd);
                hSiteListbox = GetDlgItem(hwnd, IDC_SETTINGS_SITELIST);
                hSelbox = GetDlgItem(hwnd, IDC_SETTINGS_SELLIST);
                SendMessage(hSelbox, WM_SETFONT, (WPARAM) hPica, (LPARAM)
                    MAKELPARAM(TRUE, 0));
                hSatListbox = GetDlgItem(hwnd, IDC_SETTINGS_SATLIST);
                hSite = GetDlgItem(hwnd, IDC_SETTINGS_LOCATION);
                hSatellite = GetDlgItem(hwnd, IDC_SETTINGS_SATELLITE);
                hMinElevation = GetDlgItem(hwnd, IDC_SETTINGS_MINELEVATION);
                hStartTime = GetDlgItem(hwnd, IDC_SETTINGS_GTR_STARTTIME);
                hDuration = GetDlgItem(hwnd, IDC_SETTINGS_GTR_DURATION);
                hStepTime = GetDlgItem(hwnd, IDC_SETTINGS_GTR_STEPTIME);
                listSites(hSiteListbox);
                listSatellites(hSatListbox);
                listSelections(hSelbox);
                clrbtnflgs();

                selp = currentSel;
                if (!selp)
                    selp = selInfo;
                if (selp) {
                    sbid = selp->sl_index;
                    setSel(hwnd, selp, &satp, &sitep, &startTime, &duration,
                        &stepTime, &minElevation, &updateTime, &flags);
                }
                SendMessage(hwnd, DM_SETDEFID, (WPARAM) IDNONE, (LPARAM)0 );
                SendMessage(GetDlgItem(hwnd, IDOK), WM_SETFOCUS, 0, (LPARAM)0);
                SetWindowPos(hwnd, 0, (int)p->x, (int)p->y, 0, 0,
                         SWP_NOSIZE | SWP_NOZORDER | SWP_SHOWWINDOW);

                return TRUE;

            case WM_COMMAND:
                if ((cmd = checkbuttons(hwnd, wParam, &flags)) >= 0) {
                    switch (cmd) {
                    case IDOK:
                        EndDialog(hwnd, wParam);
                        return TRUE;

                    case IDSAVE:
                        saveactivelist();
                        return TRUE;

                    case IDMORE:
                        MoreHook(hwnd, selp, satp, sitep, &flags);
                        return TRUE;

                    case IDADDSEL:
                        selp = addSelection(satp, sitep, startTime, duration,
                            		stepTime, minElevation, updateTime, flags);
						if (!selp)
							return TRUE;

                        i = SendMessage(hSelbox, LB_ADDSTRING, (WPARAM)0,
			                               (LPARAM) selp->sl_buf);
                        if (i == LB_ERR) {
                            usermsg("No space left in active list");
                            deleteSelection(selp);
                          	break;
                        }
                        selp->sl_index = sbid = i;        /* IMPORTANT */
                        setSel(hwnd, selp, &satp, &sitep, &startTime,
                               &duration, &stepTime, &minElevation,
                               &updateTime, &flags);
                                                                
                        sbid = selp->sl_index;
                        return TRUE;

                    case IDMODIFY:
	                    OnReturn(hwnd, &selp, &satp, &lsat, &sitep, &lsite,
    	                    &startTime, &duration, &stepTime, &minElevation,
        	                &updateTime);
                        if (modifySelectionbyName(hSelbox, selp, satp, sitep,
							startTime, duration, stepTime, minElevation,
								updateTime, flags)) {
                            setSel(hwnd, selp, &satp, &sitep, &startTime,
                                    &duration, &stepTime, &minElevation,
                                    &updateTime, &flags);
                            sbid = selp->sl_index;
                        }
                        return TRUE;

                    case IDDELSEL:
                        if (selp)
                            sbid = selp->sl_index;

                        if (sbid >= 0)
                            selp = findSelectionbyID(sbid);

                        if (deleteSelection(selp) >= 0) {
                            SendMessage(hSelbox, LB_DELETESTRING,
                                (WPARAM) sbid, (LPARAM) 0);
                            sbid -= 1;
                            selp = findSelectionbyID(sbid);
                            if (selp) {
                                setSel(hwnd, selp, &satp, &sitep,
                                    &startTime, &duration, &stepTime,
                                    &minElevation, &updateTime, &flags);
                            }
                        }
                        return TRUE;

                    case IDC_SETTINGS_SHOWSAT:
                        if (satp)
                            showSatellite(hwnd, satp);
                        return TRUE;

                    case IDC_SETTINGS_SHOWLOC:
                        if (sitep)
                            showSite(hwnd, sitep);
                        return TRUE;

                    default:
                        break;
                    }
                    return TRUE;
                }

                if (LOWORD(wParam) == IDNONE) {
                    OnReturn(hwnd, &selp, &satp, &lsat, &sitep, &lsite,
                        &startTime, &duration, &stepTime, &minElevation,
                        &updateTime);
                    return TRUE;
                }
                cmd = HIWORD(wParam);

                if (cmd == EN_CHANGE) {
                    switch(LOWORD(wParam)) {
                    case IDC_SETTINGS_SATELLITE:
                    	tmpbuf[0] = 0;
                        GetEditText(hwnd, IDC_SETTINGS_SATELLITE, tmpbuf, BUFLEN);
                        i = SendMessage(hSatListbox, LB_SELECTSTRING,
                                (WPARAM) -1, (LPARAM) tmpbuf);
                        if (i != LB_ERR) {
							if (i != lsat)
								lselect(hSatListbox, lsat = i);
	                    }
                        else
                        	lsat = -1;
                        break;

                    case IDC_SETTINGS_LOCATION:
                    	string[0] = 0;
                        GetEditText(hwnd, IDC_SETTINGS_LOCATION, string, BUFLEN);
                        i = SendMessage(hSiteListbox, LB_SELECTSTRING,
                            (WPARAM) -1, (LPARAM) string);
                        if (i != LB_ERR) {
							if (i != lsite)
	                            lselect(hSiteListbox, lsite = i);
	                    }
                        else
                        	lsite = -1;
                        break;
                    }
                    SendMessage(hwnd, DM_SETDEFID, (WPARAM)IDNONE, (LPARAM)0);
                    return TRUE;
                }

				if (cmd == LBN_SELCHANGE) {
				    switch (LOWORD(wParam)) {
                    case IDC_SETTINGS_SELLIST:
                        i = SendMessage(hSelbox, LB_GETCURSEL, (WPARAM)0 , (LPARAM) 0);
                        if (i == LB_ERR)
                            break;
                        if ((tmpsp = findSelectionbyID(i)) == NULL)
                        	break;
                        if (setSel(hwnd, tmpsp, &satp, &sitep, &startTime, &duration,
                               &stepTime, &minElevation, &updateTime, &flags)) {
                            selp = tmpsp;
	                        sbid =  selp->sl_index;
    	                    lsite = sitep->c_lbid;
        	                lsat =  satp->s_lbid;
        	                break;
        	            }
        	            if (selp)
        	            	lselect(hSelbox, sbid = selp->sl_index);
                        break;

                    case IDC_SETTINGS_SITELIST:
                        i = SendDlgItemMessage(hwnd, IDC_SETTINGS_SITELIST,
                                LB_GETCURSEL, (WPARAM) 0 , (LPARAM) 0 );
                        if (i != LB_ERR && i != lsite) {
	                        sitep = findSitebyID(lsite = i);
                            sprintf(tmpbuf,"%s, %s", sitep->c_name, sitep->c_locale);
                            SendMessage(hSite, WM_SETTEXT,
                                   (WPARAM) 0, (LPARAM) tmpbuf);
                            lsite = sitep->c_lbid;
                        }
                        goto dosel;

                    case IDC_SETTINGS_SATLIST :
                        i = SendMessage(hSatListbox, LB_GETCURSEL,
                                (WPARAM)0 , (LPARAM)0 );
                        if (i != LB_ERR && i != lsat) {
	                        satp = findSatbyID(lsat = i);
                            SendMessage(hSatellite, WM_SETTEXT,
                                        (WPARAM) 0, (LPARAM) satp->s_name);
                        }
                      dosel:
                      	tmpsp = findSelectionbyName(satp, sitep);
                      	if (tmpsp && selp != tmpsp) {
                      	    sbid = tmpsp->sl_index;
                            setSel(hwnd, selp = tmpsp, &satp, &sitep,
                                   &startTime, &duration, &stepTime,
                                   &minElevation, &updateTime, &flags);
                        }
	                    break;
	                    
	                default:
	                	break;
	                }
                    SendMessage(hwnd, DM_SETDEFID, (WPARAM)IDNONE, (LPARAM)0);
                    return TRUE;
                }
    	        break;

            case WM_CLOSE:                
                PostMessage(hwnd, WM_COMMAND, (WPARAM) IDOK, (LPARAM) 0);
                return TRUE;
#define DARKGRAY    7
#define LIGHTGRAY   8
            case WM_CTLCOLORLISTBOX:
#ifdef TACKYCOLORS
                if ((HWND)lParam == hSelbox) {
                    ColorSet(wParam, CWHITE, 5);
                    return (BOOL) hDrawBrush[5];
                }
#endif
                ColorSet(wParam, CWHITE, DARKGRAY);
                return (BOOL) hDrawBrush[DARKGRAY];

            case WM_CTLCOLOREDIT:
                ColorSet(wParam, CWHITE, 6);
                return (BOOL) hDrawBrush[6];
                
            case WM_PAINT:                
                hdc = GetDC(hwnd);
                DrawIcon(hdc, 458, 135, hVersa);
                ReleaseDC(hwnd, hdc);
                break;
                
            case WM_CTLCOLORDLG:
                ColorSet(wParam, CBLACK, LIGHTGRAY);
                return (BOOL) hDrawBrush[LIGHTGRAY];

            case WM_CTLCOLORSTATIC:
            case WM_CTLCOLORMSGBOX:
            case WM_CTLCOLORBTN:
                ColorSet(wParam, CBLACK, LIGHTGRAY);
                return (BOOL) hDrawBrush[LIGHTGRAY]; 

            case WM_CTLCOLORSCROLLBAR:
                ColorSet(wParam, CBLACK, 6);
                return (BOOL) hDrawBrush[6];

            default:
                break;
        }
        return FALSE;
}

       
BOOL
GetEditText(hwnd, ItemId, buf, maxlen)
HWND hwnd;
int ItemId;
char *buf;
int maxlen;
{
    int i;
    char tbuf[80], *cp;
    
    i = SendDlgItemMessage(hwnd, ItemId, (UINT)WM_GETTEXTLENGTH, (WPARAM) 0, (LPARAM) 0);

    if (i <=0 || i >= sizeof(tbuf)-1)
        return FALSE;
    else if (i > 0) {
        SendDlgItemMessage(hwnd, ItemId, (UINT)WM_GETTEXT, (WPARAM) i+1, (LPARAM) tbuf);
        tbuf[i+1] = 0;
        cp = stripLeadingSpace(tbuf);
        strncpy(buf, cp, sizeof(tbuf));
        stripTrailingSpace(buf);
    }

    return TRUE;
}

