/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#include <windows.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "vstdefs.h"
#include "constant.h"
#include "vsttype.h"
#include "libxtrns.h"


static site_t *siteinfop; 
static char *memmsg = "Can't allocate memory";
/*
 * Read the site database, sort and return address of list of ptrs to site_t's.
 */
site_t **
readSiteDB(int version, char *dirp, char *sitefile, unsigned char *ES, char *tbuf)
{
	char c;
	FILE *fp;
	HANDLE hg;
	int d, m, s, index;
	site_t *ci, **cii;
	char linebuf[180], *line;
	char *city, *stcntry, *lat, *lon, *elev, *stz, *tzstr;
	double sinLat, cosLat, sinLong, cosLong, now;
	extern int sitecmp(const void *, const void *);
	
    sprintf(linebuf,"%s\\%s", dirp, sitefile);
	if ((fp = fopen(linebuf, "r")) == NULL) {
        sprintf(tbuf,"Can't open %s", linebuf);
        return NULL;
    }

	index = 0;
	now = utctime();
	while ((line = getline(linebuf, sizeof(linebuf), fp)) != NULL) {
	    if ((*line == '#') || (*line == '\n'))
		    continue;

        city = strtok(line, ",");
        stripTrailingSpace(city);
                
		stcntry = strtok(NULL, ";");
		if (stcntry == NULL)
		    stcntry = "";

        stripTrailingSpace(stcntry);
        stcntry = stripLeadingSpace(stcntry);

        if (strlen(city) > 31)
            city[31] = 0;
		if (strlen(stcntry) > 39)
		    stcntry[39] = 0;

		lat = strtok(NULL, ";");
        lon = strtok(NULL, ";");
		elev = strtok(NULL, ";");
        stz = strtok(NULL, "; ");
        tzstr = strtok(NULL, "; ");

        if (!(hg = GlobalAlloc(GPTR, sizeof(site_t)))) {
	        strcpy(tbuf,memmsg);
	        return NULL;
	    }
		if (siteinfop == NULL) {
            siteinfop = (site_t *) GlobalLock(hg);
		    ci = siteinfop;
        }
    	else {
	        ci->c_next = (site_t *) GlobalLock(hg);
	        ci = ci->c_next;
	    }
		if (tzstr) {
		    tzstr = stripLeadingSpace(tzstr);
        	    strncpy(ci->c_tzname, tzstr, sizeof(ci->c_tzname));
       	}
       	else
       	    strcpy(ci->c_tzname, "UTC");

        ci->c_lbid = index++;
        ci->c_next = NULL;
                
		if ((ci->c_name = saveString(city ? city : "?")) == NULL) {
		    strcpy(tbuf, memmsg);
		    return NULL;
		}

		if ((ci->c_locale = saveString(stcntry ? stcntry : "?")) == NULL) {
		    strcpy(tbuf, memmsg);
		    return NULL;
		}

        c = 0;
		sscanf(lat ? lat : "00 00 00 N", "%d %d %d %c", &d, &m, &s, &c);

        ci->c_lat = (double)d + (double) m / 60.0 + (double) s / 3600.0;

		if ((c == 'S') || (c == 's'))
			ci->c_lat = 0.0 - ci->c_lat;

		sscanf(lon ? lon : "00 00 00 W", "%d %d %d %c", &d, &m, &s, &c);

		ci->c_lng = (double) d + (double) m / 60 + (double) s / 3600.0;

		if ((c == 'E') || (c == 'e'))
			ci->c_lng = 0.0 - ci->c_lng;

		ci->c_alt = atof(elev ? elev : "0.0") * CMKM;

   		ci->c_timezone = atof(stz ? stz : "0.0") / 24.0;                
		ci->c_lat   *= CDR;
		ci->c_lng   *= CDR;

        cosLat  = cos(ci->c_lat);
        sinLat  = sin(ci->c_lat);
        cosLong = cos(ci->c_lng);
        sinLong = sin(ci->c_lng);

        ci->c_vecX = ci->c_alt * cosLong * cosLat;
        ci->c_vecY = ci->c_alt * sinLong * cosLat;
        ci->c_vecZ = ci->c_alt * sinLat;

       	if (hg)
    	    GlobalUnlock(hg);
	}
	fclose(fp);

    if ((hg = GlobalAlloc(GPTR, sizeof(site_t **) * (index+1))) == NULL)
        return NULL; /* need a message here */

    cii = (site_t **) GlobalLock(hg);

    for (index=0, ci=siteinfop; ci; ci = ci->c_next)
        cii[index++] = ci;
    cii[index] = 0;

    qsort(cii, index, sizeof(site_t *), sitecmp);

	return cii;
}

static int
sitecmp(const void *a, const void *b)
{
    char abuf[80], bbuf[80];

	strncpy(abuf,(*(site_t **)a)->c_name, 39);
    strncat(abuf,(*(site_t **)a)->c_locale, 40);
    strncpy(bbuf,(*(site_t **)b)->c_name, 39);
    strncat(bbuf,(*(site_t **)b)->c_locale, 40);
    return cistrcmp(abuf, bbuf);
}
