/*
 * %W% %E% %U%
 * Debugging printf-like functions, assert, etc.
 */
 

#include <windows.h>
#include <stdio.h>
#ifdef WIN32
#include <wincon.h>
#else
#include <stdarg.h>
#endif

#ifdef _DEBUG_
static char buf[256+2];
static char *bufp = buf, *endp = buf+256;
static HANDLE Console_Handle;
int debugflag = 1;		/* Turn printfs off/on when _DEBUG_ is defined. */
#endif

/*
 * DebugFunc() - same as printf(), but with less formatting capabilities.
 * It will open a console window automatically when the first character
 * is about to be printed.
 */

#ifdef _DEBUG_
 
void
DebugFunc(char *fmt, ...)
{
    char *s;
    extern void output(unsigned int);
    va_list ap;
    
    if (debugflag == 0)
        return;

    va_start (ap, fmt);
    buf[0] = 0;
    vsprintf(buf, fmt, ap);
    for (s = buf; *s; s++)
        output(*s & 0xff);
}


void _vst_assert_(s, asrt, file, line)
BOOL s;
char *asrt;
char *file;
int line;
{
    if (s)
        DebugFunc("VST ASSERTION FALIED: file %s line %d ( %s )\n",file,line,asrt);
}

void
dowrite()
{
    static int init;
    int r;
    extern void writeaux();

    if (!init) {
        init++;
        AllocConsole();
        if ((Console_Handle = GetStdHandle(STD_OUTPUT_HANDLE)) ==
                 INVALID_HANDLE_VALUE) {
            Console_Handle = NULL;
        }
    }
    r = 0;
    if (Console_Handle && WriteFile(Console_Handle, buf, bufp-buf, &r, NULL) ==
        FALSE)
        writeaux();
    else if (r != (bufp-buf))
        writeaux();
}

static void
writeaux()
{
    /* Open COM? assuming dumb terminal connected. */
}

void
ConsClose()
{
    /* CloseHandle */
}

/*
 * Output a character to screen. Uses bios functions.
 * video memory.
 */

void
output(c)
unsigned int c;
{
    if (bufp >= endp) {
        dowrite();
        bufp = buf;
    }
    *bufp++ = c;
    if (c == '\n' || c == '\r') {
        dowrite();
        bufp = buf;
    }
}
#endif /* _DEBUG_ */

#undef _sanitycheck_debug_
#ifdef _sanitycheck_debug_
main()
{
    void DebugFunc(char *, ...);
    
    DebugFunc("Testing 1 2 3...\n");
    DebugFunc("%d (%%d) %s (%%s) %c (%%c) and then 0x%x and 0x%05x\n",
        123, "character", 'Z', 0x45678978, 0x54321);
    DebugFunc("neg. numbers %d (negative # in %%u) %u %d (%%d)\n", -10, -20, 0xfffa000);
    DebugFunc("pos. large numbers %d (%%d) 0x%x\n", 637848766, 0x7fffffff);
    DebugFunc("neg. large numbers 0x%08x=%d (%%d)\n",0x80000002, 0x80000002);
    DebugFunc("float: (1.2000211) = %f - Double (1.20302020101) = %lf\n", 1.2000211,1.20302020101);
}
#endif 
