#ifndef _VSTPROP_H
#define _VSTPROP_H
/*
 * %W% %E% %U%  [EXTREL_1.2]
 *
 * VersaTrack orbit calculations are based on those that appear in Dr. Manfred
 * Bester's sattrack program (the Unix(tm) versions 1 and 2).
 *
 * The data from which the maps where generated come from "xsat", an
 * X-Windows program by David A. Curry (N9MSW).
 *
 * Site coordinates come from various sources, including a couple of
 * World Almanacs, and also from both of the programs mentioned above.
 *
 * The following are authors' applicable copyright notices:
 *
 *                                                                               
 * Copyright (c) 1992, 1993, 1994 Manfred Bester. All Rights Reserved.        
 *                                                                           
 * Permission to use, copy, modify, and distribute this software and its      
 * documentation for educational, research and non-profit purposes, without   
 * fee, and without a written agreement is hereby granted, provided that the  
 * above copyright notice and the following three paragraphs appear in all    
 * copies.                                                                    
 *                                                                              
 * Permission to incorporate this software into commercial products may be    
 * obtained from the author, Dr. Manfred Bester, 1636 M. L. King Jr. Way,     
 * Berkeley, CA 94709, USA.                                                   
 *                                                                             
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,  
 * SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OF    
 * THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE AUTHOR HAS BEEN ADVISED   
 * OF THE POSSIBILITY OF SUCH DAMAGE.                                         
 *                                                                             
 * THE AUTHOR SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING, BUT NOT       
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A    
 * PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS ON AN "AS IS"       
 * BASIS, AND THE AUTHOR HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,  
 * UPDATES, ENHANCEMENTS, OR MODIFICATIONS.                                   
 *                                                                             
 *                                                                             
 * Copyright 1992 by David A. Curry                                            
 *                                                                             
 * Permission to use, copy, modify, distribute, and sell this software and its 
 * documentation for any purpose is hereby granted without fee, provided that  
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.  The  
 * author makes no representations about the suitability of this software for  
 * any purpose.  It is provided "as is" without express or implied warranty.   
 *                                                                             
 * David A. Curry, N9MSW                                                       
 * Purdue University                                                           
 * Engineering Computer Network                                                
 * 1285 Electrical Engineering Building                                        
 * West Lafayette, IN 47907                                                    
 * davy@ecn.purdue.edu                                                         
 *                                                                             
 * VersaTrack Copyright (c) 1993, 1994 Siamack Navabpour. All Rights Reserved.
 *
 * Permission is hereby granted to copy, modify and distribute VersaTrack
 * in whole, or in part, for educational, non-profit and non-commercial use
 * only, free of charge or obligation, and without agreement, provided that
 * all copyrights and restrictions noted herein are observed and followed, and
 * additionally, that this and all other copyright notices listed herein
 * appear unaltered in all copies and in all derived work.
 *
 * This notice shall not in any way void or supersede any of the other authors
 * rights or privileges.
 *
 * VersaTrack IS PRESENTED FREE AND "AS IS", WITHOUT ANY WARRANTY OR SUPPORT.
 * YOU USE IT AT YOUR OWN RISK. The author(s) shall not be liable for any
 * direct, indirect, incidental, or consequential damage, loss of profits or
 * other tangible or intangible losses or benefits, arising out of or related
 * to its use. VersaTrack carries no warranty, explicit or implied, including
 * but not limited to those of merchantablity and fitness for a particular
 * purpose.
 *
 * Siamack Navabpour, 12342 Hunter's Chase Dr. Apt. 2114, Austin, TX 78729.
 * sia@bga.com or sia@realtime.com.
 */


#define AE       1.0
#define AE2      (AE * AE)
#define AE3      (AE2 * AE)
#define AE4      (AE2 * AE2)

#define KE       0.0743669161          /* (KEPLER/EARTHRADIUS)^3/2 *
                                          TWOPI/MPD */
#define Q0       120.0
#define S0       78.0

#define Q0MS0T4  (pow(((Q0 - S0) * AE / EARTHRADIUS),4.0))
#define S        (AE * (1.0 + S0 / EARTHRADIUS))

#define JJ2      1.082616e-3
#define JJ3      -0.253881e-5
#define JJ4      -1.655970e-6

#define CK2      (0.5 * JJ2 * AE2)      /* WGS-72 physical and    */
#define CK4      (-0.375 * JJ4 * AE4)   /* geopotential constants */

#define A30CK2   (-(JJ3) / CK2 * AE3)

#define ZNS      1.19459e-5
#define C1SS     2.9864797e-6
#define ZES      0.01675
#define ZNL      1.5835218e-4
#define C1L      4.7968065e-7
#define ZEL      0.05490

#define cosIS    0.91744867
#define sinIS    0.39785416
#define cosGS    0.1945905
#define sinGS   -0.98088458
#define cosHZ    1.0
#define sinHS    0.0

#define Q22      1.7891679e-6
#define Q31      2.1460748e-6
#define Q33      2.2123015e-7

#define G22      5.7686396
#define G32      0.95240898
#define G44      1.8014998
#define G52      1.0508330
#define G54      4.4108898

#define ROOT22   1.7891679e-6
#define ROOT32   3.7393792e-7
#define ROOT44   7.3636953e-9
#define ROOT52   1.1428639e-7
#define ROOT54   2.1765803e-9

#define THDT     4.3752691e-3


typedef struct tag_satProp {
#ifdef LATER
    double a1, a2, a3, a4, a5, a6, a7, a8, a9, a10;
    double bfact, capU, clc0, capEpAP;
    double cosG, cosGL, cosH, cosHL, cosI, cosIL, cosIQ;
    double cosQ2, cosTEM, cosU, cos2U, gAM, kep1;
    double c2, coef1, delta0, delta1, delta12, delta13;
    double delta2, delta3, delA, delAM, delArgPer, delE;
    double delInc, delMeanAn, delMeanMot, delL, delR, delRDot, delRFDot;
    double delRaan, delU, eE2, e3, eL2, eM, eQ, etaSQ;
    double dAlp, dBet, dLS, d2, d3, d4, eccSQ, eccCB, eSinE, eCosE;
    double g200, g201, g211, g300, g310, g322, g410, g422, g520, g521, g532, g533;
    double lngGr, meanAn, meanMotCof, meanMotDot, meanMotDF, meanMotP;
    double piDot, preEpoch, pE, pGH, pH, pInc, pInvSQ, pL, psiSQ;
    double saveT, stepp, stepn, step2;
    double sinG, sinGL, sinH, sinHL, sinI, sinI2, sinIL, sinIQ;
    double meanAnp, sinMeanAnp, sinMeanAn0, sinTEM, sinU, sin2U, sinZF;
    double sma0, sma1, smallR, smallU;
    double d2201, d2211, d3210, d3222, d4410, d4422, d5220, d5232, d5421, d5433;
    double fASX2, fASX4, fASX6, fF2, fF3, fT;
    double f220, f221, f311, f321, f322, f330, f441, f442, f522, f523, f542, f543;
    double s1, s2, s3, s5, s6, s7;
    double sE, sE2, sE3, sEL, sES, sGH, sGH2, sGH3, sGH4, sGHL, sGHS;
    double SH, SH2, SH3, SHL;
    double sHS, sI, sI2, sI3, sIL, sIS, sL, sL2, sL3, sL4, sLL, sLS;
    double sS, sSE, sSG, sSH, sSI, sSL;
    double t2Cof, t3Cof, t4Cof, t5Cof;
    double upd1, upd2, upd3, upd4, upd5, upd6;
    double xfact, xlamo, xNodeS, x2LI, x2OMI, xGH2, xGH3, xGH4, xH2, xH3;
    double xI2, I3, xL2, xL3, xL4, xLCof, xLDot, xLL, xLI, xLLDot, xLS, xMAM;
    double x1, x2, x3, x4, x5, x6, x7, x8;
    double zE, zF, zM, zMO, zMOL, zMOS, zN, zX, zY;
    double z1, z2, z3, z11, z12, z13, z21, z22, z23, z31, z32, z33;
#endif /* LATER */

    double argPer, argPer0, argPerCof, argPerDot, argPerDF;
    double axN, ayN, ayNL;
    double beta, betaL, beta0, beta02, beta03, bStar;
    double clc1, clc2, clc3;
    double cosEpAP, cosInc, cos2Inc, cos4Inc;
    double c1, c1SQ, c3, c4, c5, coef0;
    double decRate, decRateDot;
    double ecc0, epoch0, eccEta, eL2, eta;
    double inc, inc0, incK, kep2, kep3, kep4, kep5, lngGr, qmst4;
    double meanAn0, meanAnCof, meanAnDot, meanAnDF;
    double meanMot, meanMot0, meanMotDeep;
    double raan, raan0, raanCof, raanK, raanDot, raanDF;
    double rDot, rk, rkDot, rfDot, rfkDot;
    double sinEpAP, sinInc, sStar, sma0Deep, smallA, smallE;
    double tFP, tSQ, tCB, tQD, tQN, uk;
    double xi, x1m1th, x1m5th, x3thm1, x7thm1, xL, xLT;
        
    double trueAnomalyX, curRaanX, curArgPerigeeX, curMotionX, curArgNodeX;
    double perigeeHeight, semiMajorAxis;
    int    deepSpaceFlag, truncFlag;
    BOOL   satCrashFlag;
} satprop_t;

#endif /* _VSTPROP_H */
