/* CoolWorx Editor Module -- Al Williams */
#include <windows.h>
#include <commdlg.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <sys/stat.h>
#include "coolworx.h"

#include "cwh.h"

/* Window word defintions */
#define ECTL 0          // Handle of edit control
#define OLDSTAT 2       // Last displayed status
#define FINDREPL 4      // Find replace active?
#define SARWIN 6        // Handle to search/replace window
#define FREPSTRUCT 8    // Handle for find/replace structure


static void savefile(HWND w,HWND ectl,DWORD wParam);

/* Edit component procedure */
long WINAPI _export cwed_proc(HWND hWnd, UINT message,
   UINT wParam, LONG lParam)
   {
   HWND ewin;
   RECT r;
   switch (message)
     {
     case WM_CREATE:
       {
       LPCREATESTRUCT cs=(LPCREATESTRUCT)lParam;
       LONG sty,scrolls;
       sty=cs->style;
/* Check for CE_?SCROLL -- use these instead of
   WS_?SCROLL to make scroll bars appear on the
   child edit control and not the parent window */
       scrolls=sty&CE_HSCROLL?WS_HSCROLL:0;
       scrolls|=sty&CE_VSCROLL?WS_VSCROLL:0;
       sty=WS_CHILD|WS_VISIBLE|ES_MULTILINE|
         ES_AUTOVSCROLL|ES_AUTOHSCROLL|scrolls;
       GetClientRect(hWnd,&r);
/* Create child edit control */
       ewin=CreateWindow("edit",NULL,sty,
         0,0,r.right,r.bottom,hWnd,1,cw_hInst,0);
       SetWindowWord(hWnd,ECTL,ewin);  // store it
/* Set no limit to text */
       SendMessage(ewin,EM_LIMITTEXT,0,0);
/* Force inital status bar update */
       SetWindowWord(hWnd,OLDSTAT,0xFFFF);
/* Init variables */
       SetWindowWord(hWnd,FINDREPL,0);
       SetWindowWord(hWnd,SARWIN,0);
       SetWindowWord(hWnd,FREPSTRUCT,0);
/* Set font */
       SendMessage(ewin,WM_SETFONT,
         GetStockObject(ANSI_FIXED_FONT),FALSE);
       }
     break;

/* Pass focus to child edit control */
     case WM_SETFOCUS:
       ewin=GetWindowWord(hWnd,ECTL);
       SetFocus(ewin);
       break;

/* Force edit control to same size */
     case WM_SIZE:
       ewin=GetWindowWord(hWnd,ECTL);
       GetClientRect(hWnd,&r);
       MoveWindow(ewin,0,0,r.right,r.bottom,TRUE);
       break;

/* Process menu/toolbar init */
     case CW_INITTOOL:
     case WM_INITMENU:
       {
       HMENU m=(HMENU)wParam;
       HWND bar=(HWND) LOWORD(lParam);
       BOOL vis=(BOOL)HIWORD(lParam);
       DWORD sel;
       WORD state;
       if (message==WM_INITMENU)
         bar=NULL;  // no tool bar for INITMENU
       ewin=GetWindowWord(hWnd,ECTL);
       sel=SendMessage(ewin,EM_GETSEL,0,0);
/* Set state TRUE if there is a selection
   (unless iconic) */
       state=LOWORD(sel)!=HIWORD(sel);
       if (IsIconic(hWnd)) state=FALSE;
/* Enable cut/copy based on selection */
       cw_EnableCommand(m,bar,CM_EDITCUT,state,vis);
       cw_EnableCommand(m,bar,CM_EDITCOPY,state,vis);
/* Set state TRUE if clipboard data is present
  (unless iconic) */
       state=IsClipboardFormatAvailable(CF_TEXT);
       if (IsIconic(hWnd)) state=FALSE;
/* Enable paste based on clipboard */
       cw_EnableCommand(m,bar,CM_EDITPASTE,state,vis);
/* Set undo state */
       state=(WORD)SendMessage(ewin,EM_CANUNDO,0,0);
       if (IsIconic(hWnd)) state=FALSE;
       cw_EnableCommand(m,bar,CM_EDITUNDO,state,vis);
/* Set save based on dirty bit */
       state=(WORD)SendMessage(ewin,EM_GETMODIFY,0,0);
       cw_EnableCommand(m,bar,CM_FILESAVE,state,vis);
       break;
       }

/* Process standard menu items */
     case CW_STDMENU:
       ewin=GetWindowWord(hWnd,ECTL);
       switch (wParam)  // these cases do what you think
         {
         case CM_FILESAVE:
         case CM_FILESAVEAS:
           savefile(hWnd,ewin,wParam);
           break;

         case CM_EDITUNDO:
           SendMessage(ewin,WM_UNDO,0,0);
           break;

         case CM_EDITCUT:
           SendMessage(ewin,WM_CUT,0,0);
           break;

         case CM_EDITCOPY:
           SendMessage(ewin,WM_COPY,0,0);
           break;

         case CM_EDITCLEAR:
           {
           DWORD sel;
           sel=SendMessage(ewin,EM_GETSEL,0,0);
           if (HIWORD(sel)==LOWORD(sel))
             SendMessage(ewin,EM_SETSEL,0,
               MAKELONG(LOWORD(sel)+1,LOWORD(sel)));
           SendMessage(ewin,WM_CLEAR,0,0);
           break;
           }

         case CM_EDITSELALL:
           SendMessage(ewin,EM_SETSEL,0,
             MAKELONG(0,0xFFFF));
           break;

          case CM_EDITPASTE:
            SendMessage(ewin,WM_PASTE,0,0);
            break;

          default:
            return FALSE;
          }

        return TRUE;

/* Prepare to close for some reason */
        case WM_QUERYENDSESSION:
          ewin=GetWindowWord(hWnd,ECTL);
/* If dirty, prompt for save */
          if (SendMessage(ewin,EM_GETMODIFY,0,0))
            {
            char msg[256];
            int act;
/* Assume file name is in title */
            SendMessage(hWnd,WM_GETTEXT,sizeof(msg),
              (DWORD)msg);
            lstrcat(msg," not saved! Save before"
              " closing?");
            act=MessageBox(hWnd,msg,"Confirm",
               MB_ICONEXCLAMATION|MB_YESNOCANCEL);
            if (act==IDCANCEL)
               return FALSE;
            if (act==IDYES)
               SendMessage(hWnd,WM_COMMAND,CM_FILESAVE,0);
            }
           return TRUE;

/* Clean up your mess */
           case WM_DESTROY:
             {
             HFONT hf;
             hf=(HFONT)SendMessage(
               ewin=GetWindowWord(hWnd,ECTL),
               WM_GETFONT,0,0);
             if (hf)  // clean up font, if necessary
               {
               SendMessage(ewin,WM_SETFONT,0,0);
               DeleteObject(hf);
               }
             break;
             }

           case WM_COMMAND:  // pass to parent
             {
             HWND w=GetParent(hWnd);
             SendMessage(w,message,wParam,lParam);
             break;
             }

/* Delegate all these to edit control */
           case WM_CUT:
           case WM_COPY:
           case WM_PASTE:
           case WM_SETFONT:
           case WM_GETFONT:
           case WM_UNDO:
           case WM_CLEAR:
           case EM_CANUNDO:
           case EM_EMPTYUNDOBUFFER:
           case EM_FMTLINES:
           case EM_GETHANDLE:
           case EM_GETLINE:
           case EM_GETLINECOUNT:
           case EM_GETMODIFY:
           case EM_GETRECT:
           case EM_GETSEL:
           case EM_LIMITTEXT:
           case EM_LINEFROMCHAR:
           case EM_LINEINDEX:
           case EM_LINELENGTH:
           case EM_LINESCROLL:
           case EM_REPLACESEL:
           case EM_SETHANDLE:
           case EM_SETMODIFY:
           case EM_SETPASSWORDCHAR:
           case EM_SETRECT:
           case EM_SETRECTNP:
           case EM_SETSEL:
           case EM_SETTABSTOPS:
           case EM_SETWORDBREAK:
           case EM_UNDO:
           case EM_GETFIRSTVISIBLELINE:
           case EM_GETPASSWORDCHAR:
           case EM_GETWORDBREAKPROC:
           case EM_SETREADONLY:
           case EM_SETWORDBREAKPROC:
             ewin=GetWindowWord(hWnd,ECTL);
             return SendMessage(ewin,message,
                 wParam,lParam);
           }

   return DefWindowProc(hWnd,message,wParam,lParam);
   }


/* Open file with dialog */
BOOL WINAPI _export cw_EditOpenFile(HWND editor,
  LPSTR fn,int siz)
  {
  char fbuf[66];
  BOOL ro,rv;
  *fbuf='\0';
  if (!cw_GetFilename(editor,fbuf,
    sizeof(fbuf),NULL,0,0,NULL,&ro,
    (BOOL)(GetWindowLong(editor,
    GWL_STYLE)&CW_USEHELP)))
      return FALSE;
  if (fn) strncpy(fn,fbuf,siz);
/* Clear file */
  cw_EditNew(editor);
/* Open given file name */
  rv=cw_EditOpen(editor,fbuf,ro);
/* Set title */
  if (rv) SendMessage(editor,WM_SETTEXT,0,(DWORD)fbuf);
  return rv;
  }

/* Open file by name */
BOOL WINAPI _export cw_EditOpen(HWND editor,LPCSTR fbuf,
  BOOL ro)
    {
    HWND ectl;
    FILE *f;
    LPSTR p;
    LONG fct=0;
    char lbuf[513];
    struct stat st;
    f=fopen(fbuf,"r");
    if (!f)
      {
      MessageBox(editor,"Can't Open File",
        NULL,MB_OK|MB_ICONSTOP);
      return FALSE;
      }
    fstat(fileno(f),&st);
// we know we can't do more than 64K
    if (st.st_size>0xFFFF)
        {
toobig:
        fclose(f);
        MessageBox(editor,"File too large",
          NULL,MB_OK|MB_ICONSTOP);
        return FALSE;
        }
    ectl=(HWND)GetWindowWord(editor,ECTL);
/* Turn off redraw while we jam text in */
    SendMessage(ectl,WM_SETREDRAW,FALSE,0);
    while (fgets(lbuf,sizeof(lbuf),f))
      {
      p=strchr(lbuf,'\n');
/* This code extends the \n end to \r\n
   Could have used binary file open, but this
   works with UNIX-style line ends too */
      if (p)
        {
        *p='\r';
        *(p+1)='\n';
        *(p+2)='\0';
        }
      fct+=lstrlen(lbuf);
      SendMessage(ectl,EM_REPLACESEL,0,(DWORD)lbuf);
/* If the text length doesn't match what we expect,
   we must be out of memory */
      if (SendMessage(ectl,WM_GETTEXTLENGTH,0,0)!=fct)
        goto toobig;
      }
    if (f)
      {
      fclose(f);
/* set cursor at top */
      SendMessage(ectl,EM_SETSEL,0,0);
/* Turn drawing back on! */
      SendMessage(ectl,WM_SETREDRAW,TRUE,0);
/* Force redraw sometime */
      InvalidateRect(ectl,NULL,TRUE);
      }
/* Set read only if necessary */
    if (ro&&f)
      SendMessage(ectl,EM_SETREADONLY,TRUE,0);
/* Don't let user undo our work */
    SendMessage(ectl,EM_EMPTYUNDOBUFFER,0,0);
/* Clear dirty bit */
    SendMessage(ectl,EM_SETMODIFY,0,0);
    return f!=NULL;
    }

/* Save file */
BOOL WINAPI _export cw_EditSaveFile(HWND w,LPCSTR filename)
  {
  HWND ectl=GetWindowWord(w,ECTL);
  LPSTR data;
  HANDLE eddata;
  DWORD ct;
  FILE *f;
  BOOL rv=TRUE;
  if (!ectl) return FALSE;
  data=LocalLock(
  eddata=(HANDLE)
  SendMessage(ectl,EM_GETHANDLE,0,0));
/* Write binary to preserve MSDOS line ends */
  f=fopen(filename,"wb");
  ct=(unsigned)lstrlen(data);
  if (!f) rv=FALSE;
/* Write data in 512 byte blocks,
   except maybe last block */
  for (;rv&&ct;ct-=min(ct,512),data+=512)
    {
    if (fwrite(data,(int)min(ct,512),1,f)!=1)
      {
      rv=FALSE;
      break;
      }
    }
  if (f&&fclose(f)) rv=FALSE;
  LocalUnlock(eddata);
/* Reset dirty bit on success */
  if (rv)
  SendMessage(ectl,EM_SETMODIFY,0,0);
  return rv;
  }

/* New document */
void WINAPI _export WINAPI cw_EditNew(HWND editor)
  {
  HWND ectl=GetWindowWord(editor,ECTL);
/* Check dirty bit */
  if (SendMessage(editor,EM_GETMODIFY,0,0))
    {
/* prompt if dirty */
    int id=
     MessageBox(editor,"File modified.\nSave Now?","Note",
      MB_YESNOCANCEL|MB_ICONQUESTION);
    if (id==IDCANCEL) return;
    if (id==IDYES)
      SendMessage(editor,CW_STDMENU,CM_FILESAVE,0);
    }
/* Turn off drawing */
  SendMessage(ectl,WM_SETREDRAW,FALSE,0);
/* Select all */
  SendMessage(ectl,EM_SETSEL,0,MAKELONG(0,0xFFFF));
/* Clear it */
  SendMessage(ectl,WM_CLEAR,0,0);
/* Clear dirty bit */
  SendMessage(ectl,EM_SETMODIFY,0,0);
/* Set untitled */
  SendMessage(editor,WM_SETTEXT,0,
    (DWORD)(LPSTR)"Untitled - 1");
/* Don't let them undo this */
  SendMessage(ectl,EM_EMPTYUNDOBUFFER,0,0);
/* Turn on draw again */
  SendMessage(ectl,WM_SETREDRAW,TRUE,0);
/* Clear status for next status update */
  SetWindowWord(editor,OLDSTAT,(unsigned)-1);
/* Force redraw eventually */
  InvalidateRect(ectl,NULL,TRUE);
  }

/* Save file  Send a CM_SAVEFILE to do this
   externally */
static void savefile(HWND w,HWND ectl,DWORD wParam)
  {
  char lbuf[512],*p;
  SendMessage(w,WM_GETTEXT,sizeof(lbuf),(DWORD)lbuf);
  p=strchr(lbuf,' ');      // only untitled file has space
  if (wParam==CM_FILESAVE)
    {
    if (!p) // not untitled so save
      {
      cw_EditSaveFile(w,lbuf);
      return;
      }
    }
/* Do save as */
  if (p) *lbuf='\0';
    if (cw_GetFilename(w,lbuf,
      sizeof(lbuf),NULL,0,1,NULL,NULL,
      (BOOL)(GetWindowLong(w,GWL_STYLE)&CW_USEHELP)))
      {
      if (cw_EditSaveFile(w,lbuf))
        {
        SendMessage(w,WM_SETTEXT,0,(DWORD)lbuf);
        SendMessage(ectl,EM_SETREADONLY,FALSE,0);
        }
      }
   }



/* Generic function to get a file name.
   Uses common dialogs. If how!=0 use Save,
   else use Open dialog */
BOOL WINAPI _export cw_GetFilename(HWND w,LPSTR filename,
  int flen,LPCSTR title,int len,
  int how,LPCSTR filter,BOOL FAR *ro,BOOL usehelp)
  {
  OPENFILENAME fn;
  int rv;
  char inttitle[66];
  memset(&fn,0,sizeof(fn));
  fn.lStructSize=sizeof(fn);
  fn.hwndOwner=w;
  fn.hInstance=GetWindowWord(w,GWW_HINSTANCE);
  if (!filter)
     fn.lpstrFilter="All Files\0*.*\0";
  else
    fn.lpstrFilter=filter;
  fn.nFilterIndex=1;
  fn.lpstrFile=filename;
  fn.nMaxFile=flen;
  if (title)
    {
    fn.lpstrFileTitle=(LPSTR)title;
    fn.nMaxFileTitle=len;
    }
  else
    {
    *inttitle='\0';
    fn.lpstrFileTitle=inttitle;
    fn.nMaxFileTitle=sizeof(inttitle);
    }
  fn.Flags=OFN_PATHMUSTEXIST;
  if (!ro) fn.Flags|=OFN_HIDEREADONLY;
  if (!how)
    fn.Flags|=OFN_FILEMUSTEXIST;
  else
    fn.Flags|=OFN_OVERWRITEPROMPT;
  if (usehelp)
    fn.Flags|=OFN_SHOWHELP;
  rv=how?GetSaveFileName(&fn):GetOpenFileName(&fn);
  if (ro)  // set read only flag
    if (!how&&(fn.Flags&OFN_READONLY))
      *ro=TRUE;
    else
      *ro=FALSE;
  return rv;
  }

/* Note this sets screen fonts only -- not printer fonts */
void WINAPI _export cw_EditSetFont(HWND w,LPLOGFONT lfp)
  {
  LOGFONT lf;
  HFONT font;
  CHOOSEFONT cf;
  memset(&cf,0,sizeof(cf));
  cf.lStructSize=sizeof(cf);
  cf.hwndOwner=w;
  cf.lpLogFont=&lf;
  cf.Flags=CF_SCREENFONTS|CF_FORCEFONTEXIST;
  if (GetWindowLong(w,GWL_STYLE)&CW_USEHELP)
  cf.Flags|=CF_SHOWHELP;
  cf.nFontType=SCREEN_FONTTYPE;
  if (ChooseFont(&cf))
    {
    font=CreateFontIndirect(&lf);
    SendMessage(w,WM_SETFONT,font,TRUE);
    if (lfp) *lfp=lf;
    }
  }

/* display cursor position */
void WINAPI _export cw_EditStatus(HWND w,LONG where,
  HWND ed,int id,BOOL force)
  {
  unsigned int pos,lno,cpos,maxl;
  char str[15];
  LONG r;
  HWND rib=cw_GetRibbon(w,where);
  r=SendMessage(ed,EM_GETSEL,0,0);
  pos=LOWORD(r);
  if (!rib&&id) return;
/* If position did not change, do nothing */
  if (pos==GetWindowWord(ed,OLDSTAT)&&!force) return;
/* Save position for next time */
  SetWindowWord(ed,OLDSTAT,pos);
  lno=(unsigned int)SendMessage(ed,EM_LINEFROMCHAR,pos,0);
  cpos=pos-(unsigned int)
    SendMessage(ed,EM_LINEINDEX,lno,0);
  maxl=(unsigned int)SendMessage(ed,EM_GETLINECOUNT,0,0);
  lno++;
  cpos++;
/* Format line#/max lines:column */
  wsprintf(str,"%d/%d:%d",lno,maxl,cpos);
  if (id)
    SendMessage(GetDlgItem(rib,id),
      WM_SETTEXT,0,(DWORD)str);
  else
    SendMessage(w,WM_SETTEXT,0,(DWORD)str);
  }

/* Get selected text */
void WINAPI _export cw_EditGetSel(HWND w,LPSTR bf,int sz)
  {
  LPSTR ptr;
  DWORD sel;
  HANDLE edh;
  int hi,lo;
  *bf='\0';
  w=GetWindowWord(w,(ECTL));
  if (w&&sz>1)
    {
    ptr=LocalLock(edh=
      (HANDLE)SendMessage(w,EM_GETHANDLE,0,0));
    sel=SendMessage(w,EM_GETSEL,0,0);
    hi=HIWORD(sel);
    lo=LOWORD(sel);
    sz--; // reserve 1 byte for terminator
    do
      {
      *bf++=ptr[lo++];
      } while (lo!=hi&&--sz);
    LocalUnlock(edh);
    }
  }


