/* CoolWorx Status Bar -- Williams */
#include <windows.h>
#include <time.h>
#include "coolworx.h"
#include "cwh.h"

#define KEYMASK 1  // shift state active


/* Update caplock/numlock/insert/scrolllock
   the int arguments are IDs for the static
   controls to get the state */
void WINAPI _export cw_StatusKeys(HWND w,LONG where,
  int cap,int num,int ins,int scr)
  {
  HWND target,ribbon=cw_GetRibbon(w,where);
  BYTE kstate[256];
  if (!ribbon) return;
  GetKeyboardState(kstate);
  target=GetDlgItem(ribbon,cap);
  if (target)
    EnableWindow(target,kstate[VK_CAPITAL]&KEYMASK);
  target=GetDlgItem(ribbon,num);
  if (target)
    EnableWindow(target,kstate[VK_NUMLOCK]&KEYMASK);
  target=GetDlgItem(ribbon,ins);
  if (target)
    EnableWindow(target,kstate[VK_INSERT]&KEYMASK);
  target=GetDlgItem(ribbon,scr);
  if (target)
    EnableWindow(target,kstate[VK_SCROLL]&KEYMASK);
  }

/* Toggle key status */
void WINAPI _export cw_ToggleKeyState(int key)
  {
  BYTE kstate[256];
  GetKeyboardState(kstate);
  kstate[key]^=1;
  SetKeyboardState(kstate);
  }

/* Put time (12 hour fmt) on status bar --
   usually call this every 500 or so WM_IDLE
   messages or on a WM_TIMER event.
   Ought to be fancy and get the time format from
   Windows, but I don't do that now */
void WINAPI _export cw_StatusTime(HWND w,LONG where,
  int id)
  {
  time_t tm;
  struct tm *tms;
  char tstr[9];
  int hr12;
  w=GetDlgItem(cw_GetRibbon(w,where),id);
  if (!w) return;
  tm=time(NULL);
  tms=localtime(&tm);
  hr12=tms->tm_hour;
  if (!hr12) hr12=12;
  if (hr12>12) hr12-=12;
  wsprintf(tstr,"%2d:%02d %s",hr12,
    tms->tm_min,(LPSTR)(tms->tm_hour>=12?"PM":"AM"));
  SendMessage(w,WM_SETTEXT,0,(DWORD)tstr);
  }


/* Place help on status bar -- if pane==0 then just
   set the text into sb otherwise sb is the status
   bar and pane is a static control id on the bar */
void WINAPI _export cw_StatusHelp(HANDLE hInst,HWND sb,
  UINT pane,UINT id)
   {
   char help[80];
/* Note: We look first in your program, then in the
   CoolWorx DLL for a help string that matches the ID.
   If you use the defaults, the debug kernel will
   complain that LoadString failed -- so what! We
   meant to do that! */
   if (!LoadString(hInst,id,help,sizeof(help)))
      if (!LoadString(cw_hInst,id,help,sizeof(help)))
         *help='\0';
   if (pane)
     cw_SetRibbon(sb,pane,help);
   else
     SendMessage(sb,WM_SETTEXT,0,(DWORD)help);
   }
