/*************************************************************************/
/*                    Multi-Colored Butterfly Figure                     */
/*     Based on an algorithm in Clifford Pickover's excellent book,      */
/*                    COMPUTERS AND THE IMAGINATION                      */
/*                                                                       */
/*                              M\Cooper                                 */
/*                      3425 Chestnut Ridge Rd.                          */
/*                    Grantsville, MD 21536-9801                         */
/*                    --------------------------                         */
/*                    Email:  thegrendel@aol.com                         */
/*************************************************************************/

#include <graphics.h>
#include <stdio.h>
#include <conio.h>
#include <math.h>

#include <dos.h>

//set PIXEL_COLOR to desired
#define PIXEL_COLOR LIGHTMAGENTA
#define GR_ERROR 10

#define SF1 56.0
#define SF2 250.0
#define THETA_DIV 12.0
#define MAXCOORDS 200.0
#define X_SHIFT 1.23
#define DELTA .02

void graphics_setup( int background_color );
void butterfly( double maxxy, double step );
void setpal();

void main()
{
   double maxcoords = MAXCOORDS,
	  step = .010;

	 graphics_setup( WHITE );
      setpal();


	 butterfly( maxcoords, step );

	 closegraph();

}



/*************************************************************************/
/*                         BUTTERFLY CURVES				 */
/*         int maxxy = max coordinates on x- and y-axes			 */
/*                     stepsize = size of step				 */
/*       see Pickover, COMPUTERS AND THE IMAGINATION, p. 21		 */
/*************************************************************************/

void butterfly( double maxxy, double stepsize )
{
   double theta,
	  r,  //radius, polar form
	  x,
	  y,
	  xx,
	  yy,
   dummy,
	  i_res; //intermediate result (theta/12.0)
   int tcolor = MAGENTA;

      for( theta = 0.0; theta <= maxxy * M_PI, !kbhit(); theta += stepsize )
	 {

	 i_res = sin( theta / THETA_DIV );
	 r = exp( cos( theta ) ) - 2.0*cos( 4.0 * theta ) + pow( i_res, 5.0 );

	 x = r * cos( theta );  //Convert to rectangular coordinates
	 y = r * sin( theta );  //from polar.

	 xx = ( x * SF1 ) + X_SHIFT * SF2;
	 yy = ( y * SF1 ) + SF2;

	 if( !theta )
	    moveto( xx, yy );
	 else
     {
	    lineto( xx, yy );
     if( modf( theta / M_PI, &dummy ) < DELTA )
        {
        tcolor = (int)yy & 0xf;
        if( tcolor < 0 || tcolor > 15 ) tcolor = (int)xx & 0xf;
        setcolor( tcolor );
        }
     }

	 }

      return;

}



/*************************************************************************/
/*                    GENERIC VGA GRAPHICS SETUP                         */
/*************************************************************************/

void graphics_setup( int background_color )
{
   int grdriver = VGA,
       grmode = VGAHI;

       registerfarbgidriver( EGAVGA_driver_far );
       registerfarbgifont( triplex_font_far );
       initgraph( &grdriver, &grmode, "" );

       if( graphresult() )  //Error in opening graphics mode..
          {
          closegraph();
	  puts( "Error in opening graphics systems!" );
	  exit( GR_ERROR );
          }

       setbkcolor( background_color );
       setcolor( PIXEL_COLOR );

       return;

}


void setpal()
{
      setpalette( 6, EGA_BROWN );
      setpalette( 8, EGA_DARKGRAY );
      setpalette( 9, EGA_LIGHTBLUE );
      setpalette( 10, EGA_LIGHTGREEN );
      setpalette( 11, EGA_LIGHTCYAN );
      setpalette( 12, EGA_LIGHTRED );
      setpalette( 13, EGA_LIGHTMAGENTA );
      setpalette( 14, EGA_YELLOW );
      setpalette( 15, EGA_LIGHTRED );

      return;
}

