@Echo Off
if "%1" == "" goto END
REM	This UPCHECK file checks and converts the following file formats:
REM
REM	.ZIP		PKZIP 1.1		PKWARE
REM			PAK 2.51		NoGate Consulting
REM	.LZH		LHARC 1.14b		Haruyasu Yoshizaki
REM	.ARJ		ARJ .20b		Robert K. Jung
REM	.ARC		ARC 6.x			SEA, Inc.
REM			PKARC/PKPAK 3.61	PKWARE
REM			PAK 2.51		NoGate Consulting
REM	.PAK		PAK 2.51		NoGate Consulting
REM	.COM		Self-extracting LHARC files
REM			Normal .COM files
REM	.EXE		Self-extracting LHARC, ARC, PKARC, PKPAK, PAK, ZIP files
REM			Normal .EXE files
REM
REM	The following path structure is assumed:
REM		Upload directory	Supplied By Gap
REM             Virus scan/zip dir.     G:\NODEx\SCAN (x = node #)
REM		Unknown file type dir	F:\MAIN\UL\UNKNOWN
REM		Corrupted file dir	F:\MAIN\UL\FAIL
REM		Infected file dir	F:\MAIN\UL\VIRUS
REM
REM	The following command line parameters are defined:
REM		Full path and name of file	(%1)
REM		Upload Directory path		(%2)
REM		Filename			(%3)
REM		Filename without the extension	(%4)
REM		Extension without the filename	(%5)
 
REM	Clear work directory
	Echo Y | del g:\node1\scan\*.*

REM	Display command parameters
	echo 1=%1
	echo 2=%2
	echo 3=%3
	echo 4=%4
	echo 5=%5
	echo.

REM	Determine file type
	if "%5"=="ZIP" goto ZIP
	if exist %2\%4.ZIP goto DUP
	if "%5"=="ARC" goto ARC
	if "%5"=="LZH" goto LZH
	if "%5"=="ARJ" goto ARJ
	if "%5"=="PAK" goto ARC
	if "%5"=="GIF" goto GIF
	if "%5"=="TXT" goto TXT
	if "%5"=="DOC" goto TXT
	if "%5"=="EXE" goto EXE
	if "%5"=="COM" goto EXE
	Goto Unknown

:ZIP
REM 	ZIP file ========================================================
	Sendcom 1 Testing ZIP file...
	Pkunzip -t %1
	If Errorlevel 1 Goto Bad
:isZIP
	Sendcom 1 Passed.
	Sendcom 1 CR
	Sendcom 1 Extracting file...
	Pkunzip %1 g:\node1\scan\
	Sendcom 1 Done.
	Sendcom 1 CR
	Goto Good

	REM ARC or PKARC or PKPAK or PAK file ===========================
:ARC
	Sendcom 1 Testing %5 file...
	pak t %1
	If Errorlevel 1 Goto Bad
:isARC
	Sendcom 1 Passed.
	Sendcom 1 CR
	Sendcom 1 Extracting file...
	Pak e %1 g:\node1\scan\
	Sendcom 1 Done.
	Sendcom 1 CR
	Goto Good

:LZH
REM 	LHARC file ======================================================
	Sendcom 1 Testing LZH file...
	Lharc t /v %1
	If Errorlevel 1 Goto Bad
:isLZH
	Sendcom 1 Passed.
	Sendcom 1 CR
	Sendcom 1 Extracting file...
	Lharc x %1 g:\node1\scan\
	Sendcom 1 Done.
	Sendcom 1 CR
	Goto Good

:ARJ
REM 	ARJ file ========================================================
	Sendcom 1 Testing ARJ file...
	Arj t %1
	If Errorlevel 1 goto Bad
	Sendcom 1 Passed.
	Sendcom 1 CR
	Sendcom 1 Extracting file...
	Arj e %1 g:\node1\scan\
	Sendcom 1 Done.
	Sendcom 1 CR
	Goto Good

:EXE
REM 	Check for self-extracting LZH/ARC/PAK/ZIP or EXE/COM file========
	Sendcom 1 Checking for Self-extracting file...
	Pkunzip -t %1
	If Errorlevel 1 goto tryLZH
	Goto isZIP
:tryLZH
	Lharc t /v %1
       	If Errorlevel 1 goto tryARC
	Goto isLZH
:tryARC
	pak t %1
	If Errorlevel 1 goto isEXE
	Goto isARC
:isEXE
	Sendcom 1 not found.
	Sendcom 1 CR
	REM Fall through to :TXT

:TXT
REM 	TXT or DOC files ================================================
	Sendcom 1 Next time, please ZIP *.%5 files before uploading.
	Sendcom 1 CR
	Copy %1 g:\node1\scan
	Goto Good

:GIF
REM 	GIF files =======================================================
	Sendcom 1 Thank You for the GIF File.
	Sendcom 1 CR
	Goto End

:DUP
REM 	Duplicate files =================================================
	Sendcom 1 File already exists in ZIP format.  File Deleted.
	Sendcom 1 CR
	Del %1
	Goto End

:Unknown
REM 	Unknown format files ============================================
	Sendcom 1 %3 is not a recognized file type.
	Sendcom 1 CR
	Sendcom 1 Please ZIP this file and repeat the upload.
	Sendcom 1 CR
	Copy %1 f:\main\ul\unknown
        Del %1
	Goto End

:Bad
	Sendcom 1 FAILED!
	Sendcom 1 CR
	Sendcom 1 Error(s) detected in %3, or file failed to Zip.
	Sendcom 1 CR
	Sendcom 1 Please check your copy for validity.
	Sendcom 1 CR
	Copy %1 f:\main\ul\fail
	Del %1
	Goto End

:Virus
	Sendcom 1 FAILED!
	Sendcom 1 CR
	Sendcom 1 Virus detected in %3!
	Sendcom 1 CR
	Sendcom 1 Please check your copy for contamination.
	Sendcom 1 CR
	Copy %1 f:\main\ul\virus
	Del %1
	Goto End

:Good
	Sendcom 1 Initiating virus check...
        Del %1
	Scan g:\node1\scan\*.* /D /NOMEM
	If Errorlevel 1 goto Virus
	Sendcom 1 Passed.
	Sendcom 1 CR
	If "%5" == "ZIP" Sendcom 1 Re-ZIPping file...
	If not "%5" == "ZIP" Sendcom 1 Creating ZIP file...
	Pkzip %2\%4 g:\node1\scan\*.*
	If Errorlevel 1 goto Bad
	Sendcom 1 Done.
	Sendcom 1 CR
        Sendcom 1 Inserting Label...
        Zipcomnt %2\%4
        Sendcom 1 Done.
        Sendcom 1 CR
	Sendcom 1 File %4.ZIP passed.
	Sendcom 1 CR

:End
