;==========================================================
; DIMVAR.LSP Copyright 1994 by Looking Glass Microproducts
;==========================================================
; Globally Update Dimension Variables 
;==========================================================
(defun C:DIMVAR (/ ERROR OLD-ERROR PUSHVARS POPVARS NOTRANS 
                 ITEM DIMVAR TEMP_STYLE DIMVARS GET_STRING 
                 GET_BLOCKNAME GET_REAL GET_DIST GET_ONOFF 
                 GET_COLOR GET_VARNAME DISPLAY 
                 GET_CURRENT_VALUE GET_INTRANGE)
   ;=======================================================
   ; Global variables
   (setq TEMP_STYLE "_UNNAMED")
   (setq
      DIMVARS '( ("DIMPOST"  3    'GET_STRING)
                 ("DIMAPOST" 4    'GET_STRING)
                 ("DIMBLK"   5    'GET_BLOCKNAME)
                 ("DIMBLK1"  6    'GET_BLOCKNAME)
                 ("DIMBLK2"  7    'GET_BLOCKNAME)
                 ("DIMSCALE" 40   'GET_REAL 4)
                 ("DIMASZ"   41   'GET_DIST 4)
                 ("DIMEXO"   42   'GET_DIST 4)
                 ("DIMDLI"   43   'GET_DIST 4)
                 ("DIMEXE"   44   'GET_DIST 4)
                 ("DIMRND"   45   'GET_DIST 4)
                 ("DIMDLE"   46   'GET_DIST 4)
                 ("DIMTP"    47   'GET_DIST 0)
                 ("DIMTM"    48   'GET_DIST 0)
                 ("DIMTXT"   140  'GET_DIST 4)
                 ("DIMCEN"   141  'GET_DIST 0)
                 ("DIMTSZ"   142  'GET_DIST 0)
                 ("DIMALTF"  143  'GET_REAL 4)
                 ("DIMLFAC"  144  'GET_REAL 4)
                 ("DIMTVP"   145  'GET_REAL 0)
                 ("DIMTFAC"  146  'GET_REAL 4)
                 ("DIMGAP"   147  'GET_DIST 0)
                 ("DIMTOL"   71   'GET_ONOFF)
                 ("DIMLIM"   72   'GET_ONOFF)
                 ("DIMTIH"   73   'GET_ONOFF)
                 ("DIMTOH"   74   'GET_ONOFF)
                 ("DIMSE1"   75   'GET_ONOFF)
                 ("DIMSE2"   76   'GET_ONOFF)
                 ("DIMTAD"   77   'GET_ONOFF)
                 ("DIMZIN"   78   'GET_INTRANGE 15)
                 ("DIMALT"   170  'GET_ONOFF)
                 ("DIMALTD"  171  'GET_INTRANGE 18)
                 ("DIMTOFL"  172  'GET_ONOFF)
                 ("DIMSAH"   173  'GET_ONOFF)
                 ("DIMTIX"   174  'GET_ONOFF)
                 ("DIMSOXD"  175  'GET_ONOFF)
                 ("DIMCLRD"  176  'GET_COLOR)
                 ("DIMCLRE"  177  'GET_COLOR)
                 ("DIMCLRT"  178  'GET_COLOR)
              )                   
   )
   ;=======================================================
   ; Error Handler
   ;=======================================================
   (defun ERROR (S)
      (if (not
             (member
                S
                '("Function cancelled" "console break")
             )
          )
         (princ S)
      )
      (POPVARS)
      (command ".undo" "end" ".undo" 1)
      (princ)
   )
   ;=======================================================
   ; Set and Save System Variables
   ;=======================================================
   (defun PUSHVARS (VLIST)
      (foreach PAIR VLIST
         (setq
            SYSVARS (cons
                       (cons
                          (strcase (car PAIR))
                          (getvar
                             (car PAIR)
                          )
                       )
                       SYSVARS
                    )
         )
         (if (cdr PAIR)
            (command
               ".setvar"
               (car PAIR)
               (cdr PAIR)
            )
         )
      )
   )
   ;=======================================================
   ; Restore System Variables
   ;=======================================================
   (defun POPVARS ()
      (foreach PAIR SYSVARS
         (command ".setvar" (car PAIR) (cdr PAIR))
      )
      (setq *error* OLD-ERROR)
      (setq SYSVARS nil)
   )
   ;=======================================================
   ; Disallow transparent invocation of routine.
   ;=======================================================
   (defun NOTRANS ()
      (cond
         ((zerop (logand (getvar "cmdactive") (+ 1 2 4 8))))
         ((alert
             "This command may not be invoked transparently."
          )
         )
      )
   )
   ;=======================================================
   ; Item from association list
   ;=======================================================
   (defun ITEM (A B) (cdr (assoc A B)))
   ;=======================================================
   ; Get Variable Name
   ;=======================================================
   (defun GET_VARNAME (/ VARNAME)
      (setq
         VARNAME (strcase
                    (getstring "\nDimension variable: ")
                 )
      )
      (cond
         ((= VARNAME "") nil)
         ((not (assoc VARNAME DIMVARS))
            (prompt
               "\nNot a global dimension variable."
            )
            nil
         )
         (VARNAME)
      )
   )
   ;=======================================================
   ; Display Value according to func
   ;=======================================================
   (defun DISPLAY (VALUE FUNC / TEMP DZ)
      (cond
         ((null VALUE) "varies")
         ((equal FUNC 'GET_REAL)
            (setq DZ (getvar "dimzin"))
            (command ".setvar" "dimzin" 0)
            (setq TEMP (rtos VALUE 2 4))
            (command ".setvar" "dimzin" DZ)
            TEMP
         )
         ((equal FUNC 'GET_DIST) (rtos VALUE))
         ((equal FUNC 'GET_ONOFF)
            (if (zerop VALUE) "Off" "On")
         )
         ((or
             (equal FUNC 'GET_STRING)
             (equal FUNC 'GET_BLOCKNAME)
          )
            VALUE
         )
         ((equal FUNC 'GET_INTRANGE) (itoa VALUE))
         ((equal FUNC 'GET_COLOR)
            (cond
               ((= 0 VALUE)   "BYBLOCK")
               ((= 256 VALUE) "BYLAYER")
               ((= 1 VALUE)   "1 (red)")
               ((= 2 VALUE)   "2 (yellow)")
               ((= 3 VALUE)   "3 (green)")
               ((= 4 VALUE)   "4 (cyan)")
               ((= 5 VALUE)   "5 (blue)")
               ((= 6 VALUE)   "6 (magenta)")
               ((= 7 VALUE)   "7 (white)")
               (t             (itoa VALUE))
            )
         )
      )
   )
   ;=======================================================
   ; Get Current Value
   ;=======================================================
   (defun GET_CURRENT_VALUE (VARENTRY / VARNAME VARNUM FUNC OLD_VALUES
   )
      (setq
         VARNAME (nth 0 VARENTRY)
         VARNUM  (nth 1 VARENTRY)
         FUNC    (eval (nth 2 VARENTRY))
      )
      (setq
         OLD_VALUES (mapcar
                       '(lambda (X) (ITEM VARNUM X))
                       DIMTABLE
                    )
      )
      (cons
         VARNAME
         (DISPLAY
            (if (apply '= OLD_VALUES) (car OLD_VALUES))
            FUNC
         )
      )
   )
   ;=======================================================
   ; Get Integer in range
   ;=======================================================
   (defun GET_INTRANGE (PRMPT LO HI / TEMP)
      (while (and
                (setq TEMP (getint PRMPT))
                (not
                   (<= LO TEMP HI)
                )
             )
         (prompt
            (strcat
               "\nRequires an integer between "
               (itoa LO)
               " and "
               (itoa HI)
               "."
            )
         )
      )
      TEMP
   )
   ;=======================================================
   ; Get On or Off
   ;=======================================================
   (defun GET_ONOFF ()
      (while (progn
                (setq TEMP (strcase (getstring PRMPT)))
                (not
                   (wcmatch TEMP "ON,OF,OFF,1,0,")
                )
             )
         (prompt "\nRequires 0 or 1, Off or On.")
      )
      TEMP
   )
   ;=======================================================
   ; Get color
   ;=======================================================
   (defun GET_COLOR (/ TEMP)
      (while (progn
                (initget
                   6
                   (strcat
                      "Red Yellow Green Cyan Blue "
                      "Magenta White BYLayer BYBlock"
                   )
                )
                (and
                   (setq TEMP (getint PRMPT))
                   (numberp TEMP)
                   (> TEMP 255)
                )
             )
         (prompt
            "\nA color number or standard color name is required."
         )
      )
      TEMP
   )
   ;=======================================================
   ; Get Blockname
   ;=======================================================
   (defun GET_BLOCKNAME (PRMPT / TEMP)
      (while (progn
                (setq TEMP (strcase (getstring PRMPT)))
                (cond
                   ((wcmatch TEMP ",DOT,`.") nil)
                   ((wcmatch
                       TEMP
                       "*[] `#`@`.`?`*`~`[`,`'!%^&()+={}|`\\:;\"<>/]*"
                    )
                      (prompt "\nInvalid block name.")
                      t
                   )
                   ((null (tblsearch "block" TEMP))
                      (prompt
                         (strcat
                            "\nBlock "
                            TEMP
                            " not defined."
                         )
                      )
                      t
                   )
                )
             )
      )
      TEMP
   )
   ;=======================================================
   ; Get New Value for Varname
   ;=======================================================
   (defun GET_NEW_VALUE (VARNAME / VARENTRY FUNC CURRENT_VALUE
                         PRMPT TEMP)
      (setq
         VARENTRY      (assoc VARNAME DIMVARS)
         FUNC          (eval (nth 2 VARENTRY))
         CURRENT_VALUE (ITEM VARNAME CURRENT_VALUES)
         PRMPT         (strcat
                          "\nGlobal value for "
                          VARNAME
                          (if (or
                                 (equal FUNC 'GET_STRING)
                                 (equal
                                    FUNC
                                    'GET_BLOCKNAME
                                 )
                              )
                             ", or . for none"
                             ""
                          )
                          " <"
                          CURRENT_VALUE
                          ">: "
                       )
      )
      (cond
         ((equal FUNC 'GET_REAL)
            (initget (nth 3 VARENTRY))
            (getreal PRMPT)
         )
         ((equal FUNC 'GET_DIST)
            (initget (nth 3 VARENTRY))
            (getdist PRMPT)
         )
         ((equal FUNC 'GET_ONOFF) (GET_ONOFF))
         ((equal FUNC 'GET_STRING) (getstring t PRMPT))
         ((equal FUNC 'GET_BLOCKNAME) (GET_BLOCKNAME PRMPT))
         ((equal FUNC 'GET_INTRANGE)
            (GET_INTRANGE PRMPT 0 (nth 3 VARENTRY))
         )
         ((equal FUNC 'GET_COLOR) (GET_COLOR))
      )
   )
   ;=======================================================
   ; Main Routine
   ;=======================================================
   (defun DIMVAR (/ DIMSTYLE DIMTABLE ENTRY CURRENT_VALUES DIMSCALE
                  VARNAME NEW_VALUE STYLENAME VARNUM OLD_VALUE
   )
      (setq DIMSTYLE (getvar "dimstyle"))
      (if (= DIMSTYLE "*UNNAMED")
         (command ".dim1" "save" TEMP_STYLE)
      )
      ;--------------------------
      ; Build a list of dimstyles
      (while (setq ENTRY (tblnext "dimstyle" (not DIMTABLE)))
         (setq DIMTABLE (cons ENTRY DIMTABLE))
      )
      ;--------------------------------------
      ; Build a list of current dimvar values
      (setq
         CURRENT_VALUES (mapcar 'GET_CURRENT_VALUE DIMVARS)
      )
      ;--------------------------------------
      ; Update dimstyles
      (if (and
             (setq VARNAME (GET_VARNAME))
             (setq NEW_VALUE (GET_NEW_VALUE VARNAME))
             (/= NEW_VALUE "")
          )
         (progn
            (setq VARNUM (car (ITEM VARNAME DIMVARS)))
            (foreach ENTRY DIMTABLE
               (setq
                  STYLENAME (ITEM 2 ENTRY)
                  OLD_VALUE (ITEM VARNUM ENTRY)
               )
               (if (/= OLD_VALUE NEW_VALUE)
                  (command
                     ".dim" "restore" STYLENAME VARNAME NEW_VALUE
                     "save" STYLENAME "exit"
                  )
               )
            )
         )
      )
      ;---------------------------------------------
      ; If current dimstyle was unnamed, 
      ; restore the dim variables
      ; and force the dimstyle to *UNNAMED.
      ; Otherwise, just restore the current dimstyle
      ;
      (if (= DIMSTYLE "*UNNAMED")
         (progn
            (command ".dim1" "restore" TEMP_STYLE)
            (setq DIMSCALE (getvar "dimscale"))
            (command ".setvar" "dimscale" (+ 2.0 DIMSCALE))
            (command ".setvar" "dimscale" DIMSCALE)
         )
         (command ".dim1" "restore" DIMSTYLE)
      )
   )
   ;==========================================================
   ; Body of c:dimvar  
   ;==========================================================
   (if (NOTRANS)
      (progn
         (setq OLD-ERROR *error* *error* ERROR)
         (setvar "cmdecho" 0)
         (command ".undo" "group")
         (PUSHVARS '(("expert" . 5)))
         (DIMVAR)
         (POPVARS)
         (command ".undo" "end")
         (setq *error* OLD-ERROR)
      )
   )
   (princ)
)
(princ
   (strcat
      "  DIMVAR.LSP v1.0 (Copyright 1994 by "
      "Looking Glass Microproducts) loaded."
   )
)
(princ)
