; TIP1012.LSP: MEDIT.LSP   Multiple Edit   (c)1994, Randy Steele

( defun C:MEDIT ( )
   (textscr)
   (setq OLDERR *error*
   *error* ERR)
   (setq CONT 0)
   ( setvar "cmdecho" 0)
   (entity_menu)
   (if ( = CONT 0)(action_menu))
   (if ( = CONT 0)(selection_menu))
) ; close mmenu.lsp
;-------------------------------
(defun entity_menu ()
   ( princ "\n\n\n\n\n\n\n \t\t\t SELECT ENTITY TO EDIT " )
   ( princ "\n  " )
   ( princ "\n 1. CIRCLES ")
   ( princ "\n 2. POLYLINES ")
   ( princ "\n 3. LINES ")
   ( princ "\n 4. TEXT ")
   ( initget 5  "0 1 2 3 4" )
   ( setq ENTITY ( getkword "\n\n\n ENTER SELECTION (ZERO TO EXIT):  "))
   (if ( = ENTITY "1")( setq  ETYPE "CIRCLE" ))
   (if ( = ENTITY "2")( setq  ETYPE "POLYLINE" ) )
   (if ( = ENTITY "3")( setq  ETYPE "LINE" ) )
   (if ( = ENTITY "4")( setq  ETYPE "TEXT" ) )
   (if ( = ENTITY "0")( ) )
)  ; end entity_menu
;  sub-menu function ------------------------
( defun action_menu ()
   ( princ "\n\n \t\t\t SELECT ACTION " )
   ( princ "\n  " )
   ( princ "\n 1. ERASE ")
   ( princ "\n 2. CHANGE LAYER ")
   ( princ "\n 3. EXPLODE ")
   ( initget 5 "0 1 2 3" )
   ( setq ACTION ( getkword "\n\n\n ENTER SELECTION (ZERO TO EXIT):  "))
   (if ( = ACTION "2")(clayer) )
   ;check for text & explode 
   (if ( = ACTION "3")
       (if ( = ENTITY "4" ) (error)))
   (if ( = ACTION "0")( finish ))
)
; --------------------------------
( defun selection_menu ()
   ( princ "\n\n \t\t\t SELECTION OPTION " )
   ( princ "\n  " )
   ( princ "\n 1. ALL ")
   ( princ "\n 2. USER SELECT ")
   ( initget 5 "0 1 2")
   ( setq SELECTION ( getkword "\n\n\n ENTER SELECTION (ZERO TO EXIT):  "))
   (if ( = SELECTION "1")( sel ) )
   (if ( = SELECTION "2")( sel2 ) )
)
; ---------------------------
(defun sel( )    ;function to select all of an entity
   ; create selection set circles from
   ; all entities in databse (drawing)
   ; made up of entity 0 etype
   ( setq COUNT 0 )  ; set up counter
   ( setq CIRCLES ( ssget "x"  ( list (cons 0 ETYPE )))  )
   (if  (null CIRCLES)
      (no_entities)
      (setq NUMBER ( sslength CIRCLES ))  ; get number of entities in selection set circles
   )
   ( while ( < COUNT NUMBER)
      ( setq NEXT ( ssname CIRCLES COUNT )) ; ssname returns the entity number (count)
      ; in selection set (circles)
      ; call function here based on action value
      ( if ( = ACTION "1" )
         ( command ".erase" NEXT "" )   ; do the desired action
      )
      ( if ( = ACTION "2" )
         ( command ".change" NEXT "" "p" "layer" LAYERNAME "" )  
      )
      ( if ( = ACTION "3" )
         ( command ".explode" NEXT )
      )
      ( setq COUNT ( 1+ COUNT ) )    ; increment counter
   )   ; end of while
)   ;  end of function sel
;  function to let user select entities ------------------
(defun  sel2 ()  
   (setq COUNT 0)
   (setq INC 0)
   ;OBJECT SELECTION:
   ( prompt ( strcat "\n SELECT "etype" ENTITIES"))
   (setq SSLGTH                  ; sslgth = sslength, how many entities selected?
      (sslength 
         (setq SS (ssget))         ; ssget gets user selected entities
   ) )
   (while (< INC SSLGTH)         ;Filters out nonTEXT, Loops thru ea entity in...
      ;...ss & Checks if current ss entity is TEXT
      (if (not (eq ETYPE (cdr (assoc '0 (entget (ssname ss INC))))))     ;If not...
         (progn                            ;...then...
            (ssdel (ssname SS INC) SS)      ;...remove entity name from set &...
            (setq SSLGTH (1- SSLGTH))       ;...decrement sslgth,ie shorten set.
         )
         (setq INC (1+ INC) )              ;...else,if TEXT, increment counter.
      )                                     ;Closes if
   )                                       ;Closes while
   ;   action required section 
   ( setq NUMBER ( sslength SS ))  ; number of entities in set 
   (while ( <  COUNT NUMBER )
      ( setq NEXT ( ssname SS COUNT ))
      ( if ( = ACTION "1" )
         ( command ".erase" NEXT "" )   ; do the desired action
      )
      ( if ( = ACTION "2" )
         ( command ".change" NEXT "" "p" "layer" LAYERNAME "" )
      )
      ( if ( = ACTION "3" )
         ( command ".explode" NEXT )
      )
      ( setq COUNT ( 1+ COUNT ))
   )
)
(defun error ()
   (prompt "\n CANNOT EXPLODE TEXT!\n" )
   (setq CONT 1)
)
(defun finish ()
   (setq CONT 1)
)
(defun clayer ()
   (setq LAYERNAME ( getstring "NEW LAYER: " ))
   (command "layer" "m" LAYERNAME "")
)
(defun no_entities ()
   (prompt ( strcat "\nNo " ETYPE " entities found in drawing. \n"))
   (setq NUMBER -1)
)
; error function
(defun err (s)                    
   (if (/= S "MEDIT WAS CANCELLED")
      (princ (strcat "\nError: " s))
   )
   (command "UNDO" "E")
   (princ)
)
(c:medit); end of medit.lsp
