; TIP1013.LSP: OU.LSP    Metric/Imperial Dimensions   (c)1994, Forbes Dodwell
;       $50 BONUS Winner

; OU.LSP written by Forbes Dodwell
; This program explodes associated dimensions and writes the imperial
; equivalant below the existing metric text. Original dimensions should
; be done with the following variables set accordingly: DIMALT=OFF,
; DIMASO=ON, DIMTAD=ON. Note "DIM" is the layer name I use for dimensions
; you should change all occurances of "DIM" to "YOUR LAYER NAME"
(defun C:OU (/ SS SSLEN SSD SSCTR STRNAME SSDATA STR INS HGT ROT 
   LEN CTR CHAR MET IMP TEMP CHG)
   (setvar "cmdecho" 0) (command "undo" "group")
   (setq SS (ssget "X" '((0 . "DIMENSION")(8 . "DIM"))) chg 0)
   (if SS (progn
         (setq SSLEN (sslength SS) SSCTR 0)
         (repeat SSLEN
            (setq SSD (ssname SS SSCTR)
            SSCTR (1+ SSCTR) )
            (command "explode" SSD)
         )
      )
   )
   (setq SS (ssget "X" '((0 . "TEXT")(8 . "0"))))
   (if SS (progn
         (command "change" SS "" "prop" "layer" "DIM" "c" "bylayer" "lt" "bylayer" "")
         (setq SSLEN (sslength SS) SSCTR 0)
         (repeat SSLEN
            (setq STRNAME (ssname ss ssctr)
               SSCTR (1+ SSCTR)
               SSDATA (entget STRNAME)
               STR (cdr (assoc 1 SSDATA))
               INS (cdr (assoc 11 SSDATA))
               HGT (cdr (assoc 40 SSDATA))
               ROT (/(* 180(cdr (assoc 50 SSDATA)))pi)
            LEN (strlen STR) CTR 0 CHAR "t" IMP "t")
            (while (and(/= (type (read CHAR)) 'INT)(/= CTR LEN))
               (setq CTR (1+ CTR) CHAR (substr STR CTR 1))
            )
            (if (/= CTR LEN) (setq IMP (substr STR CTR)))
            (if (=(type(read imp))'REAL)
               (progn
                  (setq IMP (rtos(/ (read IMP) 25.4)2 3) ;;*** Change '/' to '*' 
                     IMP (strcat IMP "\"")               ;;*** Delete this line
                     IMP (strcat "<" IMP ">") 
                  CHG (1+ CHG))    
                  (setvar "clayer" "DIM")
                  (command "text" "m" INS HGT ROT " ")
                  (command "text" "" IMP)
                  (setq TEMP (entlast)
                  INS (cdr (assoc 11 (entget TEMP))))
                  (entdel TEMP)
                  (command "text" "tc" INS HGT ROT IMP)
               )
            )
         )
      )
   )
   (command "undo" "end") (setvar "cmdecho" 1)
   (print (strcat (rtos CHG 2 0) 
   " Inch dimension(s) added to drawing."))    ;;*** change 'Inch' to 'Metric'        
(prin1)); end ou.lsp
