@echo off
rem -------------------------------------------------------------------
rem BBPULL is a sample batch file to indicate how to keep text or other
rem files in space-saving compressed format, and auto-extract them (via
rem BlueBook record) for viewing or editing as needed.  See ":winmode",
rem below, for a way to make this work for Windows applications........
rem
rem BBPull can be used "off the shelf" but you will need to have the
rem following programs available (ie, in your Path/current directory):
rem PKZip.Exe, PKUnZip.Exe, AskUser.Exe (supplied with BlueBook), and
rem BBView.Com (or if you wish to customise, some other viewer/editor).
rem
rem See ":help", below, for required input.
rem See the file "Zipping.Doc" for how to customise BBPull.
rem -------------------------------------------------------------------
rem Note that files do not have to be compressed BEFORE using BBPull
rem -------------------------------------------------------------------
rem ALL LINES STARTING "rem" CAN BE DELETED - ACTUAL BATCH FILE FOLLOWS
rem ===================================================================
cls
if "%1"=="?"  goto help
if "%1"==""   goto usage
if "%2"==""   goto usage
if "%3"==""   goto usage
if "%4"==""   goto usage
if not "%3"=="*.*" goto proceed
echo Warning
echo -------
echo You are about to unzip all files (*.*) from specified archive.
echo This will cause any files ALREADY in the destination directory to be
echo moved into the archive during the rezip step.
askuser Is this OK? (y/n)
if not errorlevel 1 goto end
:proceed
if "%4"=="~"  goto same
if "%4"=="%1" goto same
rem -------------------------------------------------------------------
rem               where %1 thru %4 are your four mandatory parameters
rem -------------------------------------------------------------------
:diff
PKUnZip   %1\%2 %3 %4\
if "%5"=="w" goto winmode
if "%5"=="W" goto winmode
BBView    %4\%3
goto zipdiff
rem -------------------------------------------------------------------
rem               BBView only displays ONE file, so only unzip ONE
rem               unless bypassing BBView with the WinMode switch.
rem               ANY [d:\path\]program can be substituted for BBView.
rem               If another batch file, it will need to be CALLed.
rem               It is your duty to ensure a zippable file of the same
rem               name exists afterward (if that's what you require).
rem -------------------------------------------------------------------
:same
PKUnZip   %1\%2 %3 %1\
if "%5"=="w" goto winmode
if "%5"=="W" goto winmode
BBView    %1\%3
goto zipsame
rem -------------------------------------------------------------------
rem               BBView same file, diff directory; note comments above
rem -------------------------------------------------------------------
:winmode
echo ----------------------------------------------------------------------
echo Extraction step completed for file(s)
echo   %1\%2 - %3
echo ----------------------------------------------------------------------
echo Successful?   Then switch to Windows [Alt+Tab] and complete your work.
echo Leave this running until you are ready to have your file(s) re-zipped.
echo When finished, return here and say if you wish to continue or abort...
echo ----------------------------------------------------------------------
echo READY TO RE-ZIP?
askuser (type Y to continue with re-zip, N to abort)
if not errorlevel 1 goto end
echo ----------------------------------------------------------------------
if "%4"=="~"  goto zipsame
if "%4"=="%1" goto zipsame
rem -------------------------------------------------------------------
rem               A simple pause, delaying the re-zip step, allows user
rem               to switch to another Windows application and work on
rem               his/her extracted file(s).  Switch back here & hit Y
rem               to re-archive.  Result -- a Windows document manager!
rem -------------------------------------------------------------------
:zipdiff
cd        %4
PKZip -mu %1\%2 %4\%3
goto end
rem -------------------------------------------------------------------
rem               PKZip: "-mu" (move/update) option moves files back to
rem               zip only if updated, a move being a recompression
rem               plus delete.  Unzipped files that have been BBViewed
rem               can't have changed, so are just deleted, saving time.
rem -------------------------------------------------------------------
:zipsame
cd        %1
PKZip -mu %1\%2 %1\%3
goto end
rem -------------------------------------------------------------------
rem               Note PKZip comments above.
rem               Note also the "cd" commands to change directory.
rem               These are essential.  They prevent PKZip removing a
rem               directory that is emptied by the re-zip step.
rem -------------------------------------------------------------------
:help
echo        BBPull.Bat - BlueBook "extract from ZIP file" batch file utility
echo        ----------------------------------------------------------------
echo        Allows text or other data files to be kept compressed & expanded
echo        as needed, then automatically rezipped after, from DOS/BlueBook.
echo        Needs PKZip/PKUnZip/BBView accessible at runtime, via your Path.
echo        WinMode switch simply pauses.  No WinMode runs "BBView" program.
echo        ----------------------------------------------------------------
echo            You must supply
echo        (1) PATH to zipfile                       [with NO trailing "\"]
echo        (2) NAME of zipfile                  [.EXTn optional if ".zip" ]
echo        (3) FILE or files to be unzipped     [OR zipped for first time!]
echo        (4) PATH (directory) to unzip to          [with NO trailing "\"]
echo        (5) Windows mode switch (OPTIONAL)        [ w or W, if supplied]
echo            in that order, separated by spaces.
echo            If (4) same as (1) you can use a tilde (~) as shorthand
echo        eg: bbpull  \docs   finance.zip  taxdept2.txt  \temp
echo        or: bbpull  a:      finance.zip  taxdept2.*    c:\temp  W
echo        or: bbpull  c:\zip  finance.zip  taxdept2.*    ~        w
echo        or: bbpull  c:\zip  finance.zip  *.*           c:\temp  w
echo                    (1)     (2)          (3)           (4)     (5)
echo        If (3)="*.*", an "All files will be rezipped" warning is issued.
echo        ----------------------------------------------------------------
echo        NB: For correct operation, PATHs must NEVER end in a "\"
echo        ----------------------------------------------------------------
goto end
:usage
echo BBPull.Bat
echo ----------
echo Parameters:  ZipPATH  ZipNAME.EXT  DocNAME.EXT  DestPATH  [WinMode]
echo eg:          c:\docs  finance.zip  taxdept2.*   c:\temp    w
echo would unzip "taxdept2.*" to "c:\temp" from "finance.zip" in "c:\docs"
echo then pause (in Windows mode), and rezip when released by keystroke.
echo ---------------------------------------------------------------------
echo NB - PATHs must NEVER end in "\"     (Run "BBPull ?" for fuller help)
echo ---------------------------------------------------------------------
:end
