/*ͻ*\
   Filename:  \MSI_WNDW.CPP                                     
   Name:      John Wiggins                                      
   Course:    Programming II                                    
   Function:  Window classes created for Database Program - JCW 
\*ͼ*/
#include <graphics.h>
#include <alloc.h>
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include "medusa.h"
#include "msi_wndw.h" // Medusa Systems, Ind. windows.
#include "mous.h"
#include "windw.h"

/*ķ*\
   Implementation of the EditDelWindw class 
                                            
   This function is the same as the ShowAll 
   class* with the exception being that the 
   user is not allowed to cancel, rather to 
   select a record to edit/remove.          
                                            
   Acknowledgement: I made this function on 
   a recomindation by Troy Cash because he  
   said that it would better follow the     
   rest of my code.                         
\*Ľ*/

/*Ŀ*\
   EditDelWindw::EditDelWindw()                  
                                                 
   This is the EditDelWindw class's constructor. 
\**/
EditDelWindw::EditDelWindw(int X, int Y, int width, int height,
   int BordrFlag, int BuferFlag, char *string) :
   CapWindw(X, Y, width, height, BordrFlag, BuferFlag, string)
{
   butn1 = butn2 = butn3 = NULL;
}

/*Ŀ*\
   EditDelWindw::~EditDelWindw()                
                                                
   This is the EditDelWindw class's destructor. 
\**/
EditDelWindw::~EditDelWindw()
{
   if (butn1 != NULL)
     delete butn1;
   if (butn2 != NULL)
     delete butn2;
   if (butn3 != NULL)
     delete butn3;
}

/*Ŀ*\
   EditDelWindw::DrawWindow() 
\**/
void EditDelWindw::DrawWindow()
{
   mouse.HideMouse();
   CapWindw::DrawWindow();
   butn1 = new Button(WindowX+(WindowWidth/2)-105,
		      WindowY+WindowHeight-50, "^Next", 64);
   butn1->DrawWindow();
   butn2 = new Button(WindowX+(WindowWidth/2)-32,
		      WindowY+WindowHeight-50, "^Prev", 64);
   butn2->DrawWindow();
   butn3 = new Button(WindowX+(WindowWidth/2)+41,
		      WindowY+WindowHeight-50, "^Select", 64);
   butn3->DrawWindow();
   mouse.ShowMouse();
}

/*Ŀ*\
   EditDelWindw::RunWindow()                               
                                                           
   This function allows the user to interact with a        
   EditDelWindw. It handles both mouse and keyboard events 
   in order to respond to button clicks.                   
\**/
void EditDelWindw::RunWindow()
{
   button = 0;
   while (!button)
   {
      GetEvent(eventMsg);
      if (butn1->Clicked(eventMsg)) button = NEXT;
      if (butn2->Clicked(eventMsg)) button = PREV;
      if (butn3->Clicked(eventMsg)) button = SELECT;
   }
}

/*ķ*\
   Implementation of the ShowAllWindw class 
                                            
   Function:  Shows data in each record.    
              Allows text to be printed via 
              outtext or outtextxy and      
              makes buttons for user to     
              select which record to view.  
\*Ľ*/

/*Ŀ*\
   ShowAllWindw::ShowAllWindw()                  
\**/
ShowAllWindw::ShowAllWindw(int X, int Y, int width, int height,
   int BordrFlag, int BuferFlag, char *string) :
   CapWindw(X, Y, width, height, BordrFlag, BuferFlag, string)
{
   butn1 = butn2 = butn3 = NULL;
}

/*Ŀ*\
   ShowAllWindw::~ShowAllWindw()                
                                                
   This is the ShowAllWindw class's destructor. 
\**/
ShowAllWindw::~ShowAllWindw()
{
   if (butn1 != NULL)
     delete butn1;
   if (butn2 != NULL)
     delete butn2;
   if (butn3 != NULL)
     delete butn3;
}

/*Ŀ*\
   ShowAllWindw::DrawWindow()          
                                       
   This function draws a DisplayWindw. 
\**/
void ShowAllWindw::DrawWindow()
{
   mouse.HideMouse();
   CapWindw::DrawWindow();
   butn1 = new Button(WindowX+(WindowWidth/2)-105,
		      WindowY+WindowHeight-50, "^Next", 64);
   butn1->DrawWindow();
   butn2 = new Button(WindowX+(WindowWidth/2)-32,
		      WindowY+WindowHeight-50, "^Prev", 64);
   butn2->DrawWindow();
   butn3 = new Button(WindowX+(WindowWidth/2)+41,
		      WindowY+WindowHeight-50, "^Cancel", 64);
   butn3->DrawWindow();
   mouse.ShowMouse();
}

/*Ŀ*\
   ShowAllindw::RunWindow()                                
                                                           
   This function allows the user to interact with a        
   ShowAllWindw. It handles both mouse and keyboard events 
   in order to respond to button clicks and the ESC key.   
\**/
void ShowAllWindw::RunWindow()
{
   button = 0;
   while (!button)
   {
      GetEvent(eventMsg);
      if (butn1->Clicked(eventMsg)) button = NEXT;
      if (butn2->Clicked(eventMsg)) button = PREV;
      if (butn3->Clicked(eventMsg)) button = CANCEL;
   }
}

/*ķ*\
   Implementation of the DisplayWindw class 
\*Ľ*/

/*Ŀ*\
   DisplayWindw::DisplayWindw()                  
                                                 
   This is the DisplayWindw class's constructor. 
\**/
DisplayWindw::DisplayWindw(int X, int Y, int width,
   int height, int BordrFlag, int BuferFlag, char *string) :
   CapWindw(X, Y, width, height, BordrFlag, BuferFlag, string)
{
   butn = NULL;
}

/*Ŀ*\
   DisplayWindw::~DisplayWindw()                
                                                
   This is the DisplayWindw class's destructor. 
\**/
DisplayWindw::~DisplayWindw()
{
   if (butn)
     delete butn;
}

/*Ŀ*\
   DisplayWindw::DrawWindow()          
                                       
   This function draws a DisplayWindw. 
\**/
void DisplayWindw::DrawWindow()
{
   mouse.HideMouse();
   CapWindw::DrawWindow();
   butn = new Button(WindowX + (WindowWidth/2)-32,
                     WindowY + WindowHeight-50, "^OK", 64);
   butn->DrawWindow();
   mouse.ShowMouse();
}

/*Ŀ*\
            DisplayWindw::RunWindow()                      
                                                           
   This function allows the user to interact with a        
   DisplayWindw. It handles both mouse and keyboard events 
   in order to respond to button clicks and the ESC key.   
\**/
void DisplayWindw::RunWindow()
{
   int done = FALSE;
   while (!done)
   {
      GetEvent(eventMsg);
      if (butn->Clicked(eventMsg)) done = TRUE;
      else if (eventMsg.type == KEYBD)
      {
         char KeyValue = eventMsg.key & 0x00ff;
         if (KeyValue == ESC) done = TRUE;
      }
   }
}