/*ͻ*\
   Filename:  \WNDW.CPP                                  
   Name:      John Wiggins                               
   Course:    Programming II                             
   Function:  Implementation of the DOS window classes. 
\*ͼ*/
#include <graphics.h>
#include <alloc.h>
#include <iostream.h>
#include <conio.h>
#include <stdlib.h>
#include "medusa.h"
#include "mous.h"  // includes dos.h
#include "windw.h" // includes event.h & string.h

// Values for CTRL-A through CTRL-Z.
unsigned ctrlkeys[] =
{
    0x1e01, // CTRL+A
    0x3002, // CTRL+B
    0x2e03, // CTRL+C
    0x2004, // CTRL+D
    0x1205, // CTRL+E
    0x2106, // CTRL+F
    0x2207, // CTRL+G
    0x2308, // CTRL+H
    0x1709, // CTRL+I
    0x240a, // CTRL+J
    0x250b, // CTRL+K
    0x260c, // CTRL+L
    0x320d, // CTRL+M
    0x310e, // CTRL+N
    0x180f, // CTRL+O
    0x1910, // CTRL+P
    0x1011, // CTRL+Q
    0x1312, // CTRL+R
    0x1f13, // CTRL+S
    0x1414, // CTRL+T
    0x1615, // CTRL+U
    0x2f16, // CTRL+V
    0x1117, // CTRL+W
    0x2d18, // CTRL+X
    0x1519, // CTRL+Y
    0x2c1a  // CTRL+Z
};

//---------------------------------------------------------
// Implementation of the Windw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// Windw::Wndw()
///////////////////////////////////////////////////////////
Windw::Windw(int X, int Y, int width, int height,
	     int BordrFlag, int BuferFlag)
{
   WindowX = X;
   WindowY = Y;
   WindowWidth = width;
   WindowHeight = height;
   border = BordrFlag;
   buffered = BuferFlag;
   buffer = NULL;
}

///////////////////////////////////////////////////////////
// Windw::~Wndw()
///////////////////////////////////////////////////////////
Windw::~Windw(void)
{
   if (buffer != NULL)
   {
      mouse.HideMouse();
      putimage(WindowX, WindowY, buffer, COPY_PUT);
      free(buffer);
      mouse.ShowMouse();
   }
}

///////////////////////////////////////////////////////////
// Windw::DrawWindow()
///////////////////////////////////////////////////////////
void Windw::DrawWindow(void)
{
   int size;
   mouse.HideMouse();
   // Save window screen area, if requested.
   if (buffered)
   {
      if ((size = imagesize(WindowX, WindowY,
			    WindowX+WindowWidth, WindowY+WindowHeight)) < 0)
	 WindwError("Image too large to store.");
      else
      {
/*       int **buffer2;
	 buffer2 = (int**)calloc(4,sizeof(int*));
	 for(int XXX=0;XXX < 4;XXX++)
	   buffer2[XXX] = (int*)calloc(size,sizeof(int));
	 if (buffer2 == NULL)*/
	 if ((buffer =(int *)malloc(size)) == NULL)
	    WindwError("Not enough memory.");
	 else
	   getimage(WindowX, WindowY,
		    WindowX+WindowWidth, WindowY+WindowHeight, buffer);
      }
   }
   //Draw basic 3D window.
   setcolor(WHITE);
   moveto(WindowX+WindowWidth, WindowY);
   lineto(WindowX, WindowY);
   lineto(WindowX, WindowY+WindowHeight);
   moveto(WindowX+WindowWidth-1, WindowY+1);
   lineto(WindowX+1, WindowY+1);
   lineto(WindowX+1, WindowY+WindowHeight-1);
   setcolor(DARKGRAY);
   moveto(WindowX+1, WindowY+WindowHeight);
   lineto(WindowX+WindowWidth, WindowY+WindowHeight);
   lineto(WindowX+WindowWidth, WindowY);
   moveto(WindowX+2, WindowY+WindowHeight-1);
   lineto(WindowX+WindowWidth-1, WindowY+WindowHeight-1);
   lineto(WindowX+WindowWidth-1, WindowY+1);
   setfillstyle(SOLID_FILL, LIGHTGRAY);
   bar(WindowX+2, WindowY+2, WindowX+WindowWidth-2, WindowY+WindowHeight-2);
   //Draw border, if requested.
   if (border)
   {
      setcolor(DARKGRAY);
      moveto(WindowX+WindowWidth-10, WindowY+10);
      lineto(WindowX+10, WindowY+10);
      lineto(WindowX+10, WindowY+WindowHeight-10);
      setcolor(WHITE);
      lineto(WindowX+WindowWidth-10, WindowY+WindowHeight-10);
      lineto(WindowX+WindowWidth-10, WindowY+10);
   }
   mouse.ShowMouse();
}

///////////////////////////////////////////////////////////
// Windw::RunWindow()
///////////////////////////////////////////////////////////
void Windw::RunWindow(void)
{
   GetEvent(eventMsg);
}

///////////////////////////////////////////////////////////
// Windw::WindwError()
///////////////////////////////////////////////////////////
void Windw::WindwError(char *string)
{
   cout << "ERROR: " << string << "\nPress a key to exit.";
   getch();
   abort();
}

//---------------------------------------------------------
// Implementation of the CapWindw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// CapWindw::CapWindw()
///////////////////////////////////////////////////////////
CapWindw::CapWindw(int X, int Y, int width, int height,
   int BordrFlag, int BuferFlag, char *string) :
   Windw(X, Y, width, height, BordrFlag, BuferFlag)
{
   strcpy(label, string);
}

///////////////////////////////////////////////////////////
// CapWindw::DrawWindow()
///////////////////////////////////////////////////////////
void CapWindw::DrawWindow()
{
   // Draw basic window.
   Windw::DrawWindow();
   // Draw caption bar.
   DrawCapBar();
}

///////////////////////////////////////////////////////////
// CapWindw::SetCaption()
///////////////////////////////////////////////////////////
void CapWindw::SetCaption(char *string)
{
   strcpy(label, string);
   DrawCapBar();
}

///////////////////////////////////////////////////////////
// CapWindw::DrawCapBar()
///////////////////////////////////////////////////////////
void CapWindw::DrawCapBar(void)
{
   int X;
   mouse.HideMouse();
   setcolor(WHITE);
   moveto(WindowX+20, WindowY+40);
   lineto(WindowX+20, WindowY+20);
   lineto(WindowX+WindowWidth-20, WindowY+20);
   setcolor(BLACK);
   lineto(WindowX+WindowWidth-20, WindowY+40);
   lineto(WindowX+20, WindowY+40);
   setfillstyle(SOLID_FILL, DARKGRAY);
   bar(WindowX+21, WindowY+21, WindowX+WindowWidth-21, WindowY+39);
   setcolor(WHITE);
   X = (WindowX+WindowWidth/2) - (strlen(label)*4);
   outtextxy(X, WindowY+27, label);
   mouse.ShowMouse();
}

//---------------------------------------------------------
// Implementation of the CapTWindw class.
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// CapTWindw::CapTWindw()
///////////////////////////////////////////////////////////
CapTWindw::CapTWindw(char *string1, char *string2, char *string3) :
   CapWindw(0, 0, 0, 150, FALSE, TRUE, string1)
{
   // Calculate which string is the longest and
   // use that width to calculate the window'string width.
   int width = strlen(string1) * 8 + 60;
   if (strlen(string2) > strlen(string3))
      WindowWidth = strlen(string2) * 8 + 60;
   else
     WindowWidth = strlen(string3) * 8 + 60;
   if (width > WindowWidth)
     WindowWidth = width;
   // Enforce a minimum width.
   if (WindowWidth < 230)
     WindowWidth = 230;
   // Calculate the window'string X,Y coordinates.
   WindowX = 320 - WindowWidth/2;
   WindowY = 164;
   // Set the window'string text.
   line1 = string2;
   line2 = string3;
}

///////////////////////////////////////////////////////////
// CapTWindw::DrawWindow()
///////////////////////////////////////////////////////////
void CapTWindw::DrawWindow(void)
{
   // Draw the captioned window.
   CapWindw::DrawWindow();

   // Position and draw window body text.
   mouse.HideMouse();
   int X = (WindowX+WindowWidth/2) - (strlen(line1)*8)/2;
   setcolor(BLACK);
   if (strlen(line2)==0)
     outtextxy(X, WindowY+68, line1);
   else
   {
      outtextxy(X, WindowY+56, line1);
      X = (WindowX+WindowWidth/2) - (strlen(line2)*8)/2;
      outtextxy(X, WindowY+71, line2);
   }
   mouse.ShowMouse();
}

//---------------------------------------------------------
// Implementation of the OKWindw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// OKWindw::OKWindw()
///////////////////////////////////////////////////////////
OKWindw::OKWindw(char *string1, char *string2, char *string3) :
   CapTWindw(string1, string2, string3)
{
   butn = NULL;
}

///////////////////////////////////////////////////////////
// OKWindw::~OKWindw()
///////////////////////////////////////////////////////////
OKWindw::~OKWindw(void)
{
   if (butn != NULL)
     delete butn;
}

///////////////////////////////////////////////////////////
// OKWindw::DrawWindow()
///////////////////////////////////////////////////////////
void OKWindw::DrawWindow()
{
   CapTWindw::DrawWindow();
   butn = new Button(WindowX+WindowWidth/2-32,
		     WindowY+WindowHeight-42, "^OK", 64);
   butn->DrawWindow();
}

///////////////////////////////////////////////////////////
// OKWindw::RunWindow()
///////////////////////////////////////////////////////////
void OKWindw::RunWindow(void)
{
   char KeyValue;
   button = 0;
   // Loop until a button is chosen.
   while (!button)
   {
      GetEvent(eventMsg);

      // Check for mouse click on button.
      if (butn->Clicked(eventMsg))
	button = OK;

      // Check for a keyboard event.
      else if (eventMsg.type == KEYBD)
      {
	 // Convert character code to ASCII,
	 // and check for Esc key.
	 KeyValue = eventMsg.key & 0x00ff;
	 if (KeyValue == ESC)
	   button = CANCEL;
      }
   }
}

//---------------------------------------------------------
// Implementation of the YesNoWindw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// YesNoWindw::YesNoWindw()
///////////////////////////////////////////////////////////
YesNoWindw::YesNoWindw(char *string1, char *string2, char *string3) :
   CapTWindw(string1, string2, string3)
{
   butn1 = butn2 = NULL;
}

///////////////////////////////////////////////////////////
// YesNoWindw::~YesNoWindw()
///////////////////////////////////////////////////////////
YesNoWindw::~YesNoWindw(void)
{
   if (butn1 != NULL)
     delete butn1;
   if (butn2 != NULL)
     delete butn2;
}

///////////////////////////////////////////////////////////
// YesNoWindw::DrawWindow()
///////////////////////////////////////////////////////////
void YesNoWindw::DrawWindow()
{
   CapTWindw::DrawWindow();
   butn1 = new Button(WindowX+WindowWidth/2-70, WindowY+108, "^Yes", 64);
   butn1->DrawWindow();
   butn2 = new Button(WindowX+WindowWidth/2+6, WindowY+108, "^No", 64);
   butn2->DrawWindow();
}

///////////////////////////////////////////////////////////
// YesNoWindw::RunWindow()
///////////////////////////////////////////////////////////
void YesNoWindw::RunWindow(void)
{
   button = 0;
   while (!button)
   {
      GetEvent(eventMsg);
      if (butn1->Clicked(eventMsg))
	button = YES;
      else if (butn2->Clicked(eventMsg))
	button = NO;
      else if (eventMsg.type == KEYBD)
      {
         char KeyValue = eventMsg.key & 0x00ff;
	 if (KeyValue == ESC)
	   button = CANCEL;
      }
   }
}

//---------------------------------------------------------
// Implementation of the YesNoCanWindw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// YesNoCanWindw::YesNoCanWindw()
///////////////////////////////////////////////////////////
YesNoCanWindw::YesNoCanWindw(char *string1, char *string2,
   char *string3) : CapTWindw(string1, string2, string3)
{
   butn1 = butn2 = butn3 = NULL;
}

///////////////////////////////////////////////////////////
// YesNoCanWindw::~YesNoCanWindw()
///////////////////////////////////////////////////////////
YesNoCanWindw::~YesNoCanWindw()
{
   if (butn1 != NULL)
     delete butn1;
   if (butn2 != NULL)
     delete butn2;
   if (butn3 != NULL)
     delete butn3;
}

///////////////////////////////////////////////////////////
// YesNoCanWindw::DrawWindow()
///////////////////////////////////////////////////////////
void YesNoCanWindw::DrawWindow(void)
{
   CapTWindw::DrawWindow();
   butn1 = new Button(WindowX+WindowWidth/2-105,
                      WindowY+WindowHeight-42, "^Yes", 64);
   butn1->DrawWindow();
   butn2 = new Button(WindowX+WindowWidth/2-32,
                      WindowY+WindowHeight-42, "^No", 64);
   butn2->DrawWindow();
   butn3 = new Button(WindowX+WindowWidth/2+41,
                      WindowY+WindowHeight-42, "^Cancel", 64);
   butn3->DrawWindow();
}

///////////////////////////////////////////////////////////
// YesNoCanWindw::RunWindow()
///////////////////////////////////////////////////////////
void YesNoCanWindw::RunWindow(void)
{
   button = 0;
   while (!button)
   {
      GetEvent(eventMsg);
      if (butn1->Clicked(eventMsg))
	button = YES;
      else if (butn2->Clicked(eventMsg))
	button = NO;
      else if (butn3->Clicked(eventMsg))
	button = CANCEL;
   }
}

//---------------------------------------------------------
// Implementation of the InputWindw class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// InputWindw::InputWindw()
///////////////////////////////////////////////////////////
InputWindw::InputWindw(char *string1, char *string2, char *string3) :
   CapTWindw(string1, string2, string3)
{
   input[0] = 0;
   butn1 = butn2 = NULL;
}

///////////////////////////////////////////////////////////
// InputWindw::~InputWindw()
///////////////////////////////////////////////////////////
InputWindw::~InputWindw()
{
   if (butn1 != NULL)
     delete butn1;
   if (butn2 != NULL)
     delete butn2;
}

///////////////////////////////////////////////////////////
// InputWindw::DrawWindow()
///////////////////////////////////////////////////////////
void InputWindw::DrawWindow(void)
{
   CapTWindw::DrawWindow();
   butn1 = new Button(WindowX+WindowWidth/2-70, WindowY+108, "^OK", 64);
   butn1->DrawWindow();
   butn2 = new Button(WindowX+WindowWidth/2+6, WindowY+108, "^Cancel", 64);
   butn2->DrawWindow();
   mouse.HideMouse();
   setfillstyle(SOLID_FILL, BLACK);
   bar(WindowX+15, WindowY+85, WindowX+WindowWidth-15, WindowY+99);
   mouse.ShowMouse();
}

///////////////////////////////////////////////////////////
// InputWindw::RunWindow()
///////////////////////////////////////////////////////////
void InputWindw::RunWindow(void)
{
   button = 0;
   while (!button)
   {
      GetEvent(eventMsg);
      if (butn1->Clicked(eventMsg))
	button = OK;
      else if (butn2->Clicked(eventMsg))
	button = CANCEL;
      else if (eventMsg.type == KEYBD)
      {
	 char KeyValue = eventMsg.key & 0x00ff;
         HandleInput(KeyValue);
      }
   }
}

///////////////////////////////////////////////////////////
// InputWindw::HandleInput()
///////////////////////////////////////////////////////////
void InputWindw::HandleInput(char KeyValue)
{
   int length = strlen(input),
       width = (WindowWidth - 30)/8;
   settextjustify(LEFT_TEXT, TOP_TEXT);

   // Check that an appropriate key was pressed
   // and that the string can hold another character.
   if ((KeyValue>31) && (KeyValue<127) && (length<80))
   {
      // Add character to string.
      input[length+1] = 0;
      input[length] = KeyValue;

      // Draw the portion of the string that will
      // fit into the text entry field.
      setcolor(WHITE);
      if (length < width)
	outtextxy(WindowX+15, WindowY+88, input);
      else
      {
	 int i = length - width + 1;
	 setfillstyle(SOLID_FILL, BLACK);
	 bar(WindowX+15, WindowY+85, WindowX+WindowWidth-15, WindowY+99);
         outtextxy(WindowX+15, WindowY+88, &input[i]);
      }
   }

   // Check for a Backspace character and that
   // the string has a character to delete.
   else if ((KeyValue==BACKSP) && (length>0))
   {
      // Delete the last character.
      length -= 1;
      input[length] = 0;

      // Draw the portion of the string that
      // will fit in the text entry field.
      setfillstyle(SOLID_FILL, BLACK);
      bar(WindowX+15, WindowY+85, WindowX+WindowWidth-15, WindowY+99);
      setcolor(WHITE);
      if (length < width+1)
	outtextxy(WindowX+15, WindowY+88, input);
      else
      {
         int i = length - width;
         outtextxy(WindowX+15, WindowY+88, &input[i]);
      }
   }
}
//---------------------------------------------------------
// Implementation of the Button class
//---------------------------------------------------------

///////////////////////////////////////////////////////////
// Button::Button()
///////////////////////////////////////////////////////////
Button::Button(int X, int Y, char *string, int size) :
   Windw(X, Y, size, 32, FALSE, FALSE) // size was 64 (default)
{
   strcpy(label, string);
   altkey = 0;
   hotkey = 0;
}

///////////////////////////////////////////////////////////
// Button::DrawWindow()
///////////////////////////////////////////////////////////
void Button::DrawWindow(void)
{
   int pos = -1;
   char tlabel[20];

   Windw::DrawWindow();
   mouse.HideMouse();

   // Find and remove the ^ character and
   // set the appropriate hot key.
   strcpy(tlabel, label);
   for (int i = 0; i<strlen(tlabel); ++i)
   {
      if (tlabel[i] == '^')
      {
	 pos = i;
         hotkey = ctrlkeys[tlabel[i+1]-65];
	 for (int j=i; j<strlen(tlabel); ++j)
	   tlabel[j] = tlabel[j+1];
      }
   }

   if (strcmp(tlabel,"OK") == 0)
     altkey = OKALT;
   else if (strcmp(tlabel, "Cancel") == 0)
     altkey = CANCELALT;

   // Center and draw text on button.
   int X = (WindowX+WindowWidth/2) - (strlen(tlabel)*4);
   setcolor(BLACK);
   outtextxy(X, WindowY+12, tlabel);

   // Underline the hot-key character.
   if (pos >= 0)
     line(X+pos*8, WindowY+20, X+pos*8+6, WindowY+20);
   mouse.ShowMouse();
}

///////////////////////////////////////////////////////////
// Button::Clicked()
///////////////////////////////////////////////////////////
int Button::Clicked(EventMsg eventMsg)
{
   int click = FALSE;
   // Check whether the user selected the
   // button with the mouse.
   if  ((eventMsg.type == MBUTTON) &&
       (eventMsg.mx>WindowX) && (eventMsg.mx<WindowX+WindowWidth) &&
       (eventMsg.my>WindowY) && (eventMsg.my<WindowY+WindowHeight))
   {
      ClickButton();
      click = TRUE;
   }
   // Check whether the user selected the
   // button from the keyboard.
   else if (eventMsg.type == KEYBD)
   {
      if ((eventMsg.key == hotkey) ||
	  (eventMsg.key == altkey))
      {
	 ClickButton();
	 click = TRUE;
      }
   }
   return click;
}

///////////////////////////////////////////////////////////
// Button::ClickButton()
///////////////////////////////////////////////////////////
void Button::ClickButton(void)
{
   int *buff;
   mouse.HideMouse();
   // Shift the image on the button down and right
   // to simulate button movement.
   int size = imagesize(WindowX+2, WindowY+2,
			WindowX+WindowWidth-2, WindowY+WindowHeight-2);
   buff = (int *)malloc(size);
   if (buff)
   {
      getimage(WindowX+2, WindowY+2, WindowX+WindowWidth-2,
	       WindowY+WindowHeight-2, buff);
      putimage(WindowX+3, WindowY+3, buff, COPY_PUT);
      free(buff);
   }
   // Draw the button'string borders so the
   // button appears to be depressed.
   setcolor(DARKGRAY);
   moveto(WindowX+WindowWidth, WindowY);
   lineto(WindowX, WindowY); lineto(WindowX, WindowY+WindowHeight);
   moveto(WindowX+WindowWidth-1, WindowY+1);
   lineto(WindowX+1, WindowY+1); lineto(WindowX+1, WindowY+WindowHeight-1);
   setcolor(WHITE);
   moveto(WindowX+1, WindowY+WindowHeight);
   lineto(WindowX+WindowWidth, WindowY+WindowHeight);
   lineto(WindowX+WindowWidth, WindowY);
   moveto(WindowX+2, WindowY+WindowHeight-1);
   lineto(WindowX+WindowWidth-1, WindowY+WindowHeight-1);
   lineto(WindowX+WindowWidth-1, WindowY+1);
   // Wait until user releases mouse button. - JW
   mouse.ButtonUp();
   // Redraw button in unselected form.
   DrawWindow();
   mouse.ShowMouse();
}

/*ķ*\
   Implementation of the ItemWindw class 
\*Ľ*/

/*Ŀ*\
   ItemWindw::ItemWindw() 
\**/
ItemWindw::ItemWindw(char *string1, char *string2, char *string3) :
   CapTWindw(string1, string2, string3)
{
   input[0] = 0;
}

/*Ŀ*\
   ItemWindw::~ItemWindw() 
\**/
ItemWindw::~ItemWindw()
{
}

/*Ŀ*\
   ItemWindw::DrawWindow() 
\**/
void ItemWindw::DrawWindow()
{
   CapTWindw::DrawWindow();
   mouse.HideMouse();
   setfillstyle(SOLID_FILL, BLACK);
   bar(WindowX + 15, WindowY + 85, WindowX + WindowWidth - 15, WindowY + 99);
   mouse.ShowMouse();
}

/*Ŀ*\
   ItemWindw::RunWindow() 
\**/
void ItemWindw::RunWindow()
{
   int repeat = TRUE;
   while (repeat)
   {
      GetEvent(eventMsg);
      if (eventMsg.type == KEYBD)
      {
	 char KeyValue = eventMsg.key & 0x00ff;
	 // My way of letting the user escape just by hitting enter. - JW
	 if (KeyValue == 13)
           repeat = FALSE;
	 else
	   HandleInput(KeyValue);
      }
   }
}

/*Ŀ*\
   ItemWindw::HandleInput() 
\**/
void ItemWindw::HandleInput(char KeyValue)
{
   int length = strlen(input),
       width = (WindowWidth - 30) / 8;
   settextjustify(LEFT_TEXT, TOP_TEXT);
   // Check that an appropriate key was pressed
   // and that the string can hold another character.
   if ((KeyValue > 31) && (KeyValue < 127) && (length < 80))
   {
      // Add character to string.
      input[length + 1] = 0;  input[length] = KeyValue;
      // Draw the portion of the string that will
      // fit into the text entry field.
      setcolor(WHITE);
      if (length < width)
	outtextxy(WindowX + 15, WindowY + 88, input);
      else
      {
	 int i = length - width + 1;
	 setfillstyle(SOLID_FILL, BLACK);
	 bar(WindowX + 15, WindowY + 85, WindowX + WindowWidth - 15, WindowY + 99);
	 outtextxy(WindowX + 15, WindowY + 88, &input[i]);
      }
   }
   // Check for a Backspace character and that
   // the string has a character to delete.
   else if ((KeyValue == BACKSP) && (length > 0))
   {
      // Delete the last character.
      length--;
      input[length] = 0;
      // Draw the portion of the string that
      // will fit in the text entry field.
      setfillstyle(SOLID_FILL, BLACK);
      bar(WindowX + 15, WindowY + 85, WindowX + WindowWidth - 15, WindowY + 99);
      setcolor(WHITE);
      if (length < width + 1)
        outtextxy(WindowX + 15, WindowY + 88, input);
      else
      {
         int i = length - width;
	 outtextxy(WindowX + 15, WindowY + 88, &input[i]);
      }
   }
}