/********************************* EXTUPD.C *************************

External update program for manipulating MBS PC INVENTORY hardware database:
HIFILE.MBX and software database SIFILE.MBX.

It is intended for use by manufacturers of pc hardware to markup the database
upon installation, deinstallation, or upgrade process.

The hardware database record structure is:

typedef struct { char szResource[40];
                 char szTitle[40];
                 char szName_Ad[120];
                 char szMsc[100];
                 char szComs[120];
                 char szDriver[800];
                 char szIrq[20];
                 char szIo_Ad[20];
                 char szBase_Ad[20];
                 char szDma[20];
                 BOOL bStatus;
                } Hard_Inv_Rec;  //1.3kb record


where:
 szResource[40]; resorce name e.g. com1
 szTitle[40]; the official TITLE of the hardware card e.g. XX super ide controller
 szName_Ad[120]; manufacturer name and address
 szMsc1[100]; communcation channels, e.g. phone/fax/bbs/internat address etc.
 szMsc2[120]; msc comments, e.g. com1 is used for serial mouse
 szDriver[800]; driver information, SEE NOTE 1
 szIrq[20]; irq number, 
 szIo_Ad[20]; io address
 szBase_Ad[20]; base address
 szDma[20]; dma number
 bStatus; status, set = 1 = activate(installation), 
                        0 = mark delete(uninstall), to be purged by user


The software database record structure is:                        

typedef struct { char szSTitle[40];
                 char szSNameAd[120];
                 char szSCom[120];
                 char szSDirs[1020];
                 BOOL  bSStatus;
               } SOFT_INV_REC;
               
SOFT_INV_REC soft_inv_rec;   

where:

szSTitle[40]; is the software title
szSNAMEAD[120]; is the manufacturer name and address
szSCom[120]; phone,fax, bbs, internet address etc of manufacturer
szSDirs[1020]; software settings:config.sys,ini settings,main directories,etc
bSStatus= 1 for active, 0 for mark for deletion

Two function in EXTUPDO.OBJ are provided for appending, altering or (mark)
deleting a record in the data bases: Rec_To_HIFILE() and Rec_To_SIFILE();
          
Per this example, the manufacturer's program fills the record structures
and makes the function call:

ret1=Rec_To_HIFILE(spath);  //record->to->hardware_inventory_file
and
ret2=Rec_To_SIFILE(spath);  //record->to->software_inventory_file

Thess functions attempt to open the right inventory file, look for the
the resource (szResouce in hardware database) or title (szSTitle in software 
database) as the database keys, replace the record if found(See NOTE3), 
append to inventory otherwise.

Function Params: 
 
char * spath; is the full path name of the inventory database :HIFILE.MBX.

int ret1; returns are:
          -3  PC Inventory full (max#=48 resources currently)
          -2  MBS PC Inventory nor registered (SEE NOTE 2)
          -1  inventory file didn't exist
          11  replaced an existing record
          10  replace failed
          21  added a new record
          20  add failed

--------------------------------------------------------------------------          
NOTE 1- settings information(szDriver in hardware and szSDirs in software
                             databses respective):use convention:
                             
   {SYSTEM.INI}
   
   [xxSection]

   driver infor
    
   [otherSection]
   other onfo
       .
       .
       .   
   {WIN.INI}
   
   [xxSection]
   
   setupinfo
       .
       .
       
   {CONFIG.SYS}
   dos sys info
       .
       .
       .          
   {GENERAL}
   (in szDriver) feature x uses irq? and dma!
   (in szSDirs) the main directories set up are C:\\xxx and C:\yyy and
                also win.ini and system ini are written to
                
       .
       .
       .
       
                    
i.e. the effected file is in {}, the section in the effected file, if
applicable, would be in [], and under it the actual textual info. 
(along the lines of windows .ini standards)       
We added the {GENERAL} section as a catch all msc field.


NOTE 2- MBS PC INVENTORY in it's initial shareware version can only
be manually maintained. Registerd versions can be maintained by 
Rec_To_HIFILE calls.

NOTE 3- STRING COMPARISONS in 2 functions above are done lexically 
and are not "white space smart", i.e. "RESOURCE" and "RESOURCE   " are
not equal, so a new hardware database entry is created instead of 
altering the old RESOURCE.

 ****************************************************************/

#include "extupd.h"

/***********************************************************************/
 
void main(void)
{
 char spath[70]; 
 int ret1,ret2;
 
 strcpy( hard_inv_rec.szResource,"a new res");
 strcpy( hard_inv_rec.szTitle,"Test Title");
 strcpy( hard_inv_rec.szName_Ad,"Test Name_Ad");
 strcpy( hard_inv_rec.szMsc1,"Test Coms");
 strcpy( hard_inv_rec.szMsc2,"Test Msc");
 strcpy( hard_inv_rec.szDriver," Test Driver set");
 strcpy( hard_inv_rec.szIrq,"ad Irq");
 strcpy( hard_inv_rec.szIo_Ad,"ad IO"); 
 strcpy( hard_inv_rec.szBase_Ad,"ad Basead alt");
 strcpy( hard_inv_rec.szDma,"ad Dma alt");
 hard_inv_rec.bStatus=1;  /*set to 0 to mark the record for deletion*/
 strcpy(spath,"d:\\test\\t3");
 ret1=Rec_To_HIFILE(spath);
 printf("Add Hardware Record result=%d\n",ret1);            
 
 /*-----------------------------------------------------*/
 
 strcpy( soft_inv_rec.szSTitle,"Test Software Title   ");
 strcpy( soft_inv_rec.szSNameAd,"Test Name_Ad");
 strcpy( soft_inv_rec.szSCom,"Test comunications1");
 strcpy( soft_inv_rec.szSDirs,"Test Software Settings alt"); 
 soft_inv_rec.bSStatus=1;  /*set to 0 to mark the record for deletion*/
 strcpy(spath,"d:\\test\\t3");
 ret2=Rec_To_SIFILE(spath);
 printf("Add Software Record result=%d\n",ret2);  
 
} 

 
