/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 B_BSP.H

 Created on Jun 9 1994 by Johannes Plass
 Converted to DEU 5.3 style on Jan 24 1995 by Renaud Paquay

*/

#ifndef _B_BSP_H_
#define _B_BSP_H_

#ifndef _W_LEVELS_H_
#include "w_levels.h"  /* LevelPtr */
#endif

/*!RP These vars are configuration vars for the Nodes Builder.
          Will we put them in the 'config' struct ? */
/*!RP Moved these vars to the 'config' struct (D_CONFIG.H)
extern Int16 BSP_splitfactor;
extern Int16 BSP_slopefactor;
extern Int16 BSP_speedfactor;
*/

/*RP These vars are for stats about what did the Nodes Builder */
extern UInt32 BSP_2S_splits;
extern UInt32 BSP_splits;
extern UInt32 BSP_vertex_corrections;

/*RP: Old Inteface of CreateNodes
int CreateNodes(LevelPtr, NPtr*, Int16 *, SEPtr *);
*/
int CreateNodes(LevelPtr level,        /*RP. IN: Pointer to the LevelInfo to build */
                NPtr   *nodes_root,    /*RP. OUT: Pointer to the Node root. */
                SEPtr  *segs_list,     /*RP. OUT: Pointer to the Segs list */
                UInt16 *num_segs,      /*RP. OUT: Pointer to the number of Segs var. */
                SSPtr  *ssectors_list, /*RP. OUT: Pointer to the SSectors list */
                UInt16 *num_ssectors); /*RP. OUT: Pointer to the number of SSectors var. */


#endif  /* _B_BSP_H_ */

/* end of file */
