/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 D_MISC.H

*/

#ifndef _D_MISC_H_
#define _D_MISC_H_

/* this pseudo-key is returned when the screen must be redrawn */
#define MAGIC_REDRAW_KEY   0x7FEE


void  MSleep(int msec);
void  Beep(void);
void  PlaySound(int freq, int msec);

Bool  Exists(char *filename);
char *GetFileExtension(char *filename);

void  ProgWarning(char *errstr, ...);
void  ProgError(char *errstr, ...);
void  LogMessage(char *logstr, ...);
void  OpenLogFile(char *logfilename);
void  CloseLogFile(void);

Bool  IsSelected(SelPtr list, Int16 objnum);
void  SelectObject(SelPtr *list, Int16 objnum);
void  UnSelectObject(SelPtr *list, Int16 objnum);
void  ForgetSelection(SelPtr *list);

void *GetMemory(size_t size);
void *ResizeMemory(void *old, size_t size);
void  FreeMemory(void *ptr);

void huge *GetFarMemory(UInt32 size);
void huge *ResizeFarMemory(void huge *old, UInt32 size);
void  FreeFarMemory(void huge *ptr);

char *StrDup(char *s);

#ifndef DEU_DOS
char *strupr(char *s);
#define stricmp(s1, s2)     strcasecmp(s1, s2)
#define strnicmp(s1, s2, n) strncasecmp(s1, s2, n)
#endif

#endif /* _D_MISC_H_ */
/* end of file */
