/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_MOUSE.H

*/

#ifndef _G_MOUSE_H_
#define _G_MOUSE_H_

extern Bool UseMouse;                   /* is there a mouse driver? */
#ifdef DEU_GFX_SGI
extern long x_origin, y_origin;         /* coords of origin */
#endif

/* prototypes */
void InitMouseDriver(void);
#ifdef DEBUG_MOUSE
void DebugShowMouse(char *file, int line);
void DebugHideMouse(char *file, int line);
#define ShowMousePointer()   DebugShowMouse(__FILE__, __LINE__)
#define HideMousePointer()   DebugHideMouse(__FILE__, __LINE__)
#else
void ShowMousePointer(void);
void HideMousePointer(void);
#endif /* DEBUG_MOUSE */

void GetMouseCoords(UInt16 *x, UInt16 *y, UInt16 *buttons);
void SetMouseCoords(UInt16 x, UInt16 y);

void SetMouseLimits(UInt16 x0, UInt16 y0, UInt16 x1, UInt16 y1);
void ResetMouseLimits(void);

#endif /* _G_MOUSE_H_ */
/* end of file */
