/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_PCKEYS.H - Definitions for the PC keys (see WaitForKey() in g_gfx???.c)

 Created by Raphael Quinet
*/

#ifndef _G_PCKEYS_H_
#define _G_PCKEYS_H_

/* Special "keys" corresponding to mouse buttons. */
#define MOUSE_LEFTDOWN    0xFF11
#define MOUSE_LEFTUP      0xFF19
#define MOUSE_RIGHTDOWN   0xFF12
#define MOUSE_RIGHTUP     0xFF1A
#define MOUSE_MIDDLEDOWN  0xFF14
#define MOUSE_MIDDLEUP    0xFF1C

/* Special "keys" which are not returned directly by the PC BIOS */
#define PCKEY_SHIFT_INS   0xFF52
#define PCKEY_SHIFT_DEL   0xFF53

/* Action keys (Enter, Escape, Backspace, Tab). */
#define PCKEY_ENTER       0x000D
#define PCKEY_ALT_ENTER   0x1C00
#define PCKEY_CTRL_ENTER  0x000A

#define PCKEY_ESC         0x001B

#define PCKEY_BACK        0x0008
#define PCKEY_ALT_BACK    0x0E00
#define PCKEY_CTRL_BACK   0x007F

#define PCKEY_TAB         0x0009
#define PCKEY_ALT_TAB     0xA400
#define PCKEY_SHIFT_TAB   0x0F00
#define PCKEY_CTRL_TAB    0x9400

/* Direction keys (arrows, PgUp, PgDn, Home, End), Insert, Delete. */
#define PCKEY_UP          0x4800
#define PCKEY_DOWN        0x5000
#define PCKEY_LEFT        0x4B00
#define PCKEY_RIGHT       0x4D00
#define PCKEY_INS         0x5200
#define PCKEY_DEL         0x5300
#define PCKEY_HOME        0x4700
#define PCKEY_END         0x4F00
#define PCKEY_PGUP        0x4900
#define PCKEY_PGDN        0x5100

#define PCKEY_ALT_UP      0x9800
#define PCKEY_ALT_DOWN    0xA000
#define PCKEY_ALT_LEFT    0x9B00
#define PCKEY_ALT_RIGHT   0x9D00
#define PCKEY_ALT_INS     0xA200
#define PCKEY_ALT_DEL     0xA300
#define PCKEY_ALT_HOME    0x9700
#define PCKEY_ALT_END     0x9F00
#define PCKEY_ALT_PGUP    0x9900
#define PCKEY_ALT_PGDN    0xA100

#define PCKEY_CTRL_UP     0x8D00
#define PCKEY_CTRL_DOWN   0x9100
#define PCKEY_CTRL_LEFT   0x7300
#define PCKEY_CTRL_RIGHT  0x7400
#define PCKEY_CTRL_INS    0x9200
#define PCKEY_CTRL_DEL    0x9300
#define PCKEY_CTRL_HOME   0x7700
#define PCKEY_CTRL_END    0x7500
#define PCKEY_CTRL_PGUP   0x8200
#define PCKEY_CTRL_PGDN   0x7600

/* Function keys (F1 -> F12). */
#define PCKEY_F1          0x3B00
#define PCKEY_F2          0x3C00
#define PCKEY_F3          0x3D00
#define PCKEY_F4          0x3E00
#define PCKEY_F5          0x3F00
#define PCKEY_F6          0x4000
#define PCKEY_F7          0x4100
#define PCKEY_F8          0x4200
#define PCKEY_F9          0x4300
#define PCKEY_F10         0x4400
#define PCKEY_F11         0x8300
#define PCKEY_F12         0x8400

#define PCKEY_SHIFT_F1    0x5400
#define PCKEY_SHIFT_F2    0x5500
#define PCKEY_SHIFT_F3    0x5600
#define PCKEY_SHIFT_F4    0x5700
#define PCKEY_SHIFT_F5    0x5800
#define PCKEY_SHIFT_F6    0x5900
#define PCKEY_SHIFT_F7    0x5A00
#define PCKEY_SHIFT_F8    0x5B00
#define PCKEY_SHIFT_F9    0x5C00
#define PCKEY_SHIFT_F10   0x5D00
#define PCKEY_SHIFT_F11   0x8700
#define PCKEY_SHIFT_F12   0x8800

#define PCKEY_ALT_F1      0x6800
#define PCKEY_ALT_F2      0x6900
#define PCKEY_ALT_F3      0x6A00
#define PCKEY_ALT_F4      0x6B00
#define PCKEY_ALT_F5      0x6C00
#define PCKEY_ALT_F6      0x6D00
#define PCKEY_ALT_F7      0x6E00
#define PCKEY_ALT_F8      0x6F00
#define PCKEY_ALT_F9      0x7000
#define PCKEY_ALT_F10     0x7100
#define PCKEY_ALT_F11     0x8B00
#define PCKEY_ALT_F12     0x8C00

#define PCKEY_CTRL_F1     0x5E00
#define PCKEY_CTRL_F2     0x5F00
#define PCKEY_CTRL_F3     0x6000
#define PCKEY_CTRL_F4     0x6100
#define PCKEY_CTRL_F5     0x6200
#define PCKEY_CTRL_F6     0x6300
#define PCKEY_CTRL_F7     0x6400
#define PCKEY_CTRL_F8     0x6500
#define PCKEY_CTRL_F9     0x6600
#define PCKEY_CTRL_F10    0x6700
#define PCKEY_CTRL_F11    0x8900
#define PCKEY_CTRL_F12    0x8A00

/* Alt-numbers (Alt-1 -> Alt-0). */
#define PCKEY_ALT_1       0x7800
#define PCKEY_ALT_2       0x7900
#define PCKEY_ALT_3       0x7A00
#define PCKEY_ALT_4       0x7B00
#define PCKEY_ALT_5       0x7C00
#define PCKEY_ALT_6       0x7D00
#define PCKEY_ALT_7       0x7E00
#define PCKEY_ALT_8       0x7F00
#define PCKEY_ALT_9       0x8000
#define PCKEY_ALT_0       0x8100

/* Alt-letters (Alt-A -> Alt-Z). */
#define PCKEY_ALT_A       0x1E00
#define PCKEY_ALT_B       0x3000
#define PCKEY_ALT_C       0x2E00
#define PCKEY_ALT_D       0x2000
#define PCKEY_ALT_E       0x1200
#define PCKEY_ALT_F       0x2100
#define PCKEY_ALT_G       0x2200
#define PCKEY_ALT_H       0x2300
#define PCKEY_ALT_I       0x1700
#define PCKEY_ALT_J       0x2400
#define PCKEY_ALT_K       0x2500
#define PCKEY_ALT_L       0x2600
#define PCKEY_ALT_M       0x3200
#define PCKEY_ALT_N       0x3100
#define PCKEY_ALT_O       0x1800
#define PCKEY_ALT_P       0x1900
#define PCKEY_ALT_Q       0x1000
#define PCKEY_ALT_R       0x1300
#define PCKEY_ALT_S       0x1F00
#define PCKEY_ALT_T       0x1400
#define PCKEY_ALT_U       0x1600
#define PCKEY_ALT_V       0x2F00
#define PCKEY_ALT_W       0x1100
#define PCKEY_ALT_X       0x2D00
#define PCKEY_ALT_Y       0x1500
#define PCKEY_ALT_Z       0x2C00

/* Ctrl-letters (Ctrl-A -> Ctrl-Z). */
#define PCKEY_CTRL_A      0x0001
#define PCKEY_CTRL_B      0x0002
#define PCKEY_CTRL_C      0x0003
#define PCKEY_CTRL_D      0x0004
#define PCKEY_CTRL_E      0x0005
#define PCKEY_CTRL_F      0x0006
#define PCKEY_CTRL_G      0x0007
#define PCKEY_CTRL_H      0x0008
#define PCKEY_CTRL_I      0x0009
#define PCKEY_CTRL_J      0x000A
#define PCKEY_CTRL_K      0x000B
#define PCKEY_CTRL_L      0x000C
#define PCKEY_CTRL_M      0x000D
#define PCKEY_CTRL_N      0x000E
#define PCKEY_CTRL_O      0x000F
#define PCKEY_CTRL_P      0x0010
#define PCKEY_CTRL_Q      0x0011
#define PCKEY_CTRL_R      0x0012
#define PCKEY_CTRL_S      0x0013
#define PCKEY_CTRL_T      0x0014
#define PCKEY_CTRL_U      0x0015
#define PCKEY_CTRL_V      0x0016
#define PCKEY_CTRL_W      0x0017
#define PCKEY_CTRL_X      0x0018
#define PCKEY_CTRL_Y      0x0019
#define PCKEY_CTRL_Z      0x001A

#endif /* _G_PCKEYS_H_ */
/* end of file */
