/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 G_MOUVGA.C - Mouse driver for SVGAlib

 Functions written by Per Allansson and adapted for SVGAlib by
 Sam Lantinga  (slouken@cs.ucdavis.edu)
*/

/* the includes */
#include "deu.h"
#include "g_gfx.h"
#include "g_colcnv.h"
#include "g_mouse.h"

/* SVGAlib mouse routines */
extern int mouse_update();
extern int mouse_getx();
extern int mouse_gety();
extern int mouse_getbutton();
extern void mouse_setposition(int x, int y);
extern void mouse_setxrange(int x, int y);
extern void mouse_setyrange(int x, int y);

/* the global data */
Bool UseMouse = FALSE;                  /* is there a mouse driver? */


/*
   Initialize the mouse driver.
*/

void InitMouseDriver(void)
{
  /* Initialization is done by SVGAlib internally */
  UseMouse = TRUE;
/*  MouseSetColors(TranslateToDoomColor(WHITE), GrNOCOLOR);*/
}



/*
   Show the pointer.
*/

void ShowMousePointer(void)
{
/*
  MouseDisplayCursor();
  MouseEventEnable(0, 1);
*/
}



/*
   Hide the pointer.
*/

void HideMousePointer(void)
{
/*
  MouseEraseCursor();
  MouseEventEnable(0, 0);
*/
}


/*
   Read pointer coordinates.
*/

void GetMouseCoords(UInt16 *x, UInt16 *y, UInt16 *buttons)
{
  mouse_update();
  *x = mouse_getx();
  *y = mouse_gety();
  *buttons = mouse_getbutton();
/*printf("GetMouseCoords() returning (%d,%d) <%d>\r\n", *x, *y, *buttons);*/
}


/*
   Change pointer coordinates.
*/

void SetMouseCoords(UInt16 x, UInt16 y)
{
  mouse_setposition(x, y);
}



/*
   Set horizontal and vertical limits (constrain pointer in a box).
*/

void SetMouseLimits(UInt16 x0, UInt16 y0, UInt16 x1, UInt16 y1)
{
  mouse_setxrange(x0, x1);
  mouse_setyrange(y0, y1);
}



/*
   Reset horizontal and vertical limits.
*/

void ResetMouseLimits(void)
{
  mouse_setxrange(0, ScrMaxX);
  mouse_setyrange(0, ScrMaxY);
}


/* end of file */
