/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 I_MENUS.H

*/

#ifndef _I_MENUS_H_
#define _I_MENUS_H_

/* prototypes */

Int16 DisplayMenu(Int16 x0, Int16 y0, char *menutitle, ...);
Int16 PullDownMenu(Int16 x0, Int16 y0, ...);
Int16 InputInteger(Int16 x0, Int16 y0, Int16 *valp, Int16 minv, Int16 maxv);
Int16 InputIntegerValue(Int16 x0, Int16 y0, char *prompt, Int16 minv, Int16 maxv, Int16 defv);
void InputNameFromListWithFunc(Int16 x0, Int16 y0, char *prompt, Int16 listsize, char **list, Int16 listdisp, char *name, Int16 width, Int16 height, void (*hookfunc)(Int16 px1, Int16 py1, Int16 px2, Int16 py2, char *name));
void InputNameFromList(Int16 x0, Int16 y0, char *prompt, Int16 listsize, char **list, char *name);
void InputFileName(Int16 x0, Int16 y0, char *prompt, Int16 maxlen, char *filename);
Bool Confirm(Int16 x0, Int16 y0, char *prompt1, char *prompt2);
void Notify(Int16 x0, Int16 y0, char *prompt1, char *prompt2);
void DisplayMessage(Int16 x0, Int16 y0, char *msg, ...);
void DisplayProgressMeter(Int16 x0, Int16 y0, Int16 minwidth, char *prompt);
void UpdateProgressMeter(float value);
void NotImplemented(void);

#endif /* _I_MENUS_H_ */
/* end of file */
