/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 I_TEXTUR.H

*/

/*! Yuck ! */
void DisplayFloorTexture(Int16 x0, Int16 y0, Int16 x1, Int16 y1, char *texname);
void DisplayThingPic(Int16 x0, Int16 y0, Int16 x1, Int16 y1, char *picname);
void DisplayPic(Int16 x0, Int16 y0, Int16 x1, Int16 y1, char *picname, Bool center);
void DisplayWallTexture(Int16 x0, Int16 y0, Int16 x1, Int16 y1, char *texname);
void GetWallTextureSize(Int16 *xsize_r, Int16 *ysize_r, char *texname);
void ChooseFloorTexture(Int16 x0, Int16 y0, char *prompt, Int16 listsize, char **list, char *name);
void ChooseWallTexture(Int16 x0, Int16 y0, char *prompt, Int16 listsize, char **list, char *name);
void ChooseSprite(Int16 x0, Int16 y0, char *prompt, char *sname);
