/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_EDIT.H

*/

#ifndef _M_EDIT_H_
#define _M_EDIT_H_

#include "w_levels.h"

/* information for the map editor window(s) */
struct MapEditorInfo
{
  LevelPtr level;        /* level being edited in this window */
  int      edit_mode;    /* current editing mode (object type) */
  SelPtr   selected;     /* list of selected objects */
  float    map_scale;    /* current zoom level */
  Int16    orig_x;       /* X origin for map coordinates */
  Int16    orig_y;       /* Y origin for map coordinates */
  int      grid_scale;   /* scale of the grid (0 = no grid) */
  Bool     grid_shown;   /* TRUE if the grid is drawn */
  Bool     show_rulers;  /* TRUE if the rulers are displayed */
  int      thing_mask;   /* mask for drawing things */
};
typedef struct MapEditorInfo *MapInfoPtr;

/* prototypes */
void OLD_EditLevel(char *mapname, Bool newlevel);

#endif /* _M_EDIT_H_ */
/* end of file */
