/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 M_EDOBJ.H

*/

#ifndef _M_EDOBJ_H_
#define _M_EDOBJ_H_

/* the includes */
#include "w_levels.h"
#include "i_dialog.h"

/* defines */
#define SB_CELL_SIZE 32   /* 32 cells *max* in each thing scrollbox */

/* prototypes */
void EditObjectsInfo(LevelPtr level, Int16 x0, Int16 y0, int objtype, SelPtr list);
void InsDelSidedef(va_list *args, DBSC *btn, Bool status);
void DbUpdateSidedef(va_list *args, DBSC *btn, Bool status);

#endif /* _M_EDOBJ_H_ */
/* end of file */
