/*----------------------------------------------------------------------------*
 | This file is part of DEU (Doom Editing Utilities), created by the DEU team:|
 | Raphael Quinet, Brendon Wyber, Ted Vessenes and others.  See README.1ST or |
 | the "about" dialog box for full credits.                                   |
 |                                                                            |
 | DEU is an open project: if you think that you can contribute, please join  |
 | the DEU team.  You will be credited for any code (or ideas) included in    |
 | the next version of the program.                                           |
 |                                                                            |
 | If you want to make any modifications and re-distribute them on your own,  |
 | you must follow the conditions of the DEU license.  Read the file LICENSE  |
 | in this directory or README.1ST in the top directory.  If do not have a    |
 | copy of these files, you can request them from any member of the DEU team, |
 | or by mail: Raphael Quinet, Rue des Martyrs 9, B-4550 Nandrin (Belgium).   |
 |                                                                            |
 | This program comes with absolutely no warranty.  Use it at your own risks! |
 *----------------------------------------------------------------------------*

 W_STRUCT.H - Definition of the elements inside a level

*/

#ifndef _W_STRUCT_H_
#define _W_STRUCT_H_

/*
   This data structure contains the information about the THINGS.
*/

struct Thing
{
  Int16  xpos;     /* x position */
  Int16  ypos;     /* y position */
  UInt16 angle;    /* facing angle */
  UInt16 type;     /* thing type - see W_THING.C for more info */
  UInt16 when;     /* appears when? - see W_NAMES.C for more info */
};
typedef struct Thing huge *TPtr;



/*
   This data structure contains the information about the LINEDEFS.
*/
struct LineDef
{
  Int16  start;    /* from this vertex ... */
  Int16  end;      /* ... to this vertex */
  UInt16 flags;    /* linedef flags - see W_NAMES.C for more info */
  UInt16 type;     /* linedef type - see W_LINDEF.C for more info */
  UInt16 tag;      /* crossing this linedef activates the sector with the same tag */  /*! UInt16 ? */
  Int16  sidedef1; /* first sidedef */
  Int16  sidedef2; /* only if this line adjoins 2 sectors */
};
typedef struct LineDef huge *LDPtr;



/*
   This data structure contains the information about the SIDEDEFS.
*/
struct SideDef
{
  Int16 xoff;      /* X offset for texture */
  Int16 yoff;      /* Y offset for texture */
  char  tex1[8];   /* texture name for the part above */
  char  tex2[8];   /* texture name for the part below */
  char  tex3[8];   /* texture name for the regular part */
  Int16 sector;    /* adjacent sector  */
};
typedef struct SideDef huge *SDPtr;



/*
   This data structure contains the information about the VERTEXES.
*/
struct Vertex
{
  Int16 x;         /* X coordinate */
  Int16 y;         /* Y coordinate */
};
typedef struct Vertex huge *VPtr;



/*
   This data structure contains the information about the SEGS.
*/
typedef struct Seg huge *SEPtr;
struct Seg
{
  SEPtr  next;     /* next Seg in list */
  Int16  start;    /* from this vertex ... */
  Int16  end;      /* ... to this vertex */
  UInt16 angle;    /* angle (0 = east, 16384 = north, ...) */
  Int16  linedef;  /* linedef that this seg goes along*/
  UInt16 flip;     /* true if not the same direction as linedef */
  UInt16 dist;     /* distance from starting point */
};



/*
   This data structure contains the information about the SSECTORS.
*/
typedef struct SSector huge *SSPtr;
struct SSector
{
  SSPtr next;     /* next Sub-Sector in list */
  Int16 num;      /* number of Segs in this Sub-Sector */   /*! UInt16 ? */
  Int16 first;    /* first Seg */
};



/*
   This data structure contains the information about the NODES.
*/
typedef struct Node *NPtr;
struct Node
{
  Int16 x, y;                        /* starting point */
  Int16 dx, dy;                      /* offset to ending point */
  Int16 miny1, maxy1, minx1, maxx1;  /* bounding rectangle 1 */
  Int16 miny2, maxy2, minx2, maxx2;  /* bounding rectangle 2 */
  Int16 child1, child2;              /* Node or SSector (if high bit is set) */  /*! UInt16 ? */
  NPtr  node1, node2;                /* pointer if the child is a Node */
  Int16 num;                         /* number given to this Node */  /*! UInt16 ? */
};



/*
   This data structure contains the information about the SECTORS.
*/
struct Sector
{
   Int16  floorh;    /* floor height */
   Int16  ceilh;     /* ceiling height */
   char   floort[8]; /* floor texture */
   char   ceilt[8];  /* ceiling texture */
   UInt16 light;     /* light level (0-255) */
   UInt16 type;      /* special behaviour (0 = normal, 9 = secret, ...) */   /*! UInt16 ? */
   UInt16 tag;       /* sector activated by a linedef with the same tag */   /*! UInt16 ? */
};
typedef struct Sector huge *SPtr;

#endif /* _W_STRUCT_H_ */
/* end of file */
