{$M 5120,0,10240}  { 10k reserved for data }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}
{$S- no stack checking code}

PROGRAM ImageDirectory;
USES DOS, ImageID;
CONST
  lf = #13#10;

PROCEDURE showhelp (problem : BYTE);
(* If any *foreseen* errors arise, we are sent here to
   give a little help and exit (relatively) peacefully *)
VAR
  message : STRING [50];
BEGIN
  WriteLn ('IMD v1.01 - Free DOS Image Directory utility.');
  WriteLn ('Copyright (c) August 12, 1995, by David Daniel Anderson - Reign Ware.' + lf);
  WriteLn ('Usage:    IMD [file_spec]' + lf);
  WriteLn ('Example:  IMD a:\mariah*.gif' + lf);
  IF problem > 0 THEN BEGIN
    CASE problem OF
      1 : message := 'No files matching specification found.';
      ELSE  message := 'Unanticipated error of unknown type.';
    END;
    WriteLn ('Error:    ' + message);
  END;
  Halt (problem)
END;

FUNCTION leadingzero (w : WORD) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w : 0, s);
  IF (Length (s) = 1) THEN
    s := '0' + s;
  leadingzero := s;
END;

FUNCTION Comma (li : LONGINT) : STRING;
VAR
  s : STRING [15];
  l : SHORTINT;
BEGIN
  Str (li, s);
  l := (Length (s) - 2);
  WHILE (l > 1) DO BEGIN
    Insert (',', s, l);
    Dec (l, 3);
  END;
  Comma := s;
END;

FUNCTION RPad (bstr: STRING; len: BYTE): STRING;
BEGIN
  WHILE (Length (bstr) < len) DO
    bstr := bstr + #32;
  RPad := bstr;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  dirinfo   : SEARCHREC;
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PStr;
  IF jPath = '' THEN jPath := '*.*';
  IF IsDir(jPath) THEN BEGIN
    IF NOT (jPath[Length(jPath)] in [':','\']) THEN
      jPath:=jPath+'\';
    jPath:=jPath+'*.*';
  END;

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir+jName+jExt;

  sDir := jdir;
  GetFilePath := jpath;
END;

PROCEDURE writetime (fdatetime : LONGINT);
VAR
  DateTimeInf : DATETIME;
BEGIN
  UnpackTime (fdatetime, DateTimeInf);
  WITH DateTimeInf DO BEGIN
    Write
    (LeadingZero (Month): 4, '-',
    LeadingZero (Day) , '-',
    Copy (LeadingZero (Year), 3, 2), '  ',
    LeadingZero (Hour), ':',
    LeadingZero (Min), ':',
    LeadingZero (Sec));
  END;
END;

(*****************************************************************************)

VAR
  iName,
  gpath: STRING;
  gdir: DIRSTR;
  dirinfo: SEARCHREC;
  numfiles: WORD;
  sizefiles: LONGINT;
  iType: STRING;
  iWidth, iHeight: LONGINT;
  iColors, GIFLite: STRING;

BEGIN
  FileMode := 0;
  numfiles := 0;
  sizefiles := 0;
  gPath := GetFilePath (ParamStr (1), gDir);
  FindFirst (gpath, ReadOnly+Hidden+Archive, dirinfo);
  IF (DosError <> 0) THEN showhelp (1);
  WriteLn ('Image Directory of: '+gpath+lf);
  WHILE (DosError = 0) DO BEGIN
    iName := gdir + dirinfo. Name;
    Write ((RPad (dirinfo. Name, 12)), dirinfo. Size : 9);
    Inc (numfiles);
    Inc (sizefiles, dirinfo. Size);
    writetime (dirinfo. Time);
    IF dirinfo.Size > 0 THEN
    BEGIN
       iType := IsImage (iName, iWidth, iHeight, iColors, GIFLite);
       IF (iType <> '')
         THEN WriteLn (#32#32, RPad(iType,6), ' [':2, iWidth:4, iHeight:5, iColors:7, #32#32, GIFLite:6)
         ELSE WriteLn; {-or- WriteLn (' ... Unrecognized format - skipping.');}
    END
    ELSE WriteLn;
    FindNext (dirinfo);
  END;
  WriteLn (comma (sizefiles):12,' bytes in ', numfiles, ' file(s)');
END.
