PROGRAM FixCPT;
{$M 5120,0,655360}
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}
{$S- no stack checking code}
USES DOS;
CONST
  progdesc = 'CPT-Fix - Fix CPT v1.36 database files.';
  author   = 'Copyright (c) August 3, 1995, by David Daniel Anderson - Reign Ware.';

PROCEDURE showhelp (problem : BYTE);
{----
 If any *foreseen* errors arise, we are sent here,
  to give a little help and exit (relatively) peacefully
----}
CONST
  usage    = 'Usage:  CPT-Fix <CPT v1.36 file(s)>';
VAR
  message : STRING [79];
BEGIN
  WriteLn;
  IF (problem > 0) THEN BEGIN
    CASE (problem) OF
      1 : message := 'Command line contains improper number of parameters.';
      3 : message := 'No files found.  One parameter must be a valid file specification.';
      6 : message := 'You cannot just specify a path, add "*.*" or "\*.*" for all files.';
      7 : message := 'Error opening, closing, or renaming a file.  Original may be renamed!'
      ELSE  message := 'Undefined error.'
    END;
    WriteLn ('Error encountered:'); WriteLn (message); WriteLn;
  END;
  WriteLn (usage);
  Halt (problem);
END;

PROCEDURE iocheck;
BEGIN
  IF (IOResult <> 0) THEN showhelp (7);
END;

FUNCTION Upper (w: STRING): STRING;
VAR
  cp : INTEGER;        {The position of the character to change.}
BEGIN
  FOR cp := 1 TO Length (w) DO
    w [cp] := UpCase (w [cp]);
  Upper := w;
END;

PROCEDURE EraseFile (CONST CurrentFile: STRING);
VAR
  Attr: WORD;
  df: FILE;
BEGIN
  Assign (df, CurrentFile);
  GetFAttr (df, Attr);
  IF (DosError = 0) THEN
  BEGIN
    SetFAttr (df, 0);
    Erase (df);
  END;
END;

FUNCTION GetName (fn : STRING): STRING;
BEGIN
  IF (Pos ('.', fn) > 0)
    THEN GetName := Copy (fn, 1, (Pos ('.', fn) - 1))
    ELSE GetName := fn;
END;

FUNCTION GetExt (fn : STRING): STRING;
BEGIN
  IF (Pos ('.', fn) > 0)
    THEN GetExt := Copy (fn, Pos ('.', fn), Length (fn))
    ELSE GetExt := '';
END;

PROCEDURE openfiles (VAR file_in, file_out : TEXT; Name1, Name2 : STRING);
BEGIN
  Assign (file_in, Name1);
  Reset (file_in);           iocheck;
  Assign (file_out, Name2);
  Rewrite (file_out);        iocheck;
END;

PROCEDURE swapnames (VAR FILE1, FILE2 : TEXT; Name1, Name2 : PATHSTR);
VAR
  dir1, dir2 : DIRSTR;
  fn1, fn2   : NAMESTR;
  ext1, ext2 : EXTSTR;
BEGIN
  FSplit (FExpand (Name1), dir1, fn1, ext1);
  FSplit (FExpand (Name2), dir2, fn2, ext2);
  Rename (FILE1, dir1 + fn1 + '.swp');  iocheck;
  Rename (FILE2, dir2 + fn2 + ext1);    iocheck;
  Rename (FILE1, dir1 + fn1 + ext2);    iocheck;
END;

FUNCTION FixLine (VAR FILE1, FILE2 : TEXT): BOOLEAN;
VAR
  cline : STRING;
  return : BOOLEAN;
BEGIN
  return := FALSE;
  ReadLn (FILE1, cline);
  IF Copy (cline, 1, 9) = 'CPT v1.36' THEN BEGIN
    return := TRUE;
    cline [9] := '7';
    WriteLn (FILE2, cline);
    WHILE (NOT EoF (FILE1)) DO BEGIN
      ReadLn (FILE1, cline);
      IF (Copy (cline, 1, 2) = ': ') AND (cline [38] <> ',') THEN BEGIN
        Insert (',', cline, 38);
        WHILE cline[55]=#32 DO BEGIN
          Delete (cline, 55, 1);
          Insert ('?', cline, 48);
        END;
        WHILE cline[68]=#32 DO BEGIN
          Delete (cline, 68, 1);
          Insert ('?', cline, 61);
        END;
      END;
      cline[50] := '-';
      cline[53] := '-';
      cline[63] := '-';
      cline[66] := '-';
      WriteLn (FILE2, cline)
    END;
  END;
  FixLine := return;
END;

{---- TYPEs, CONSTs and VARs for "main" program ----}
TYPE
  link = ^node;
  node = RECORD
           Name : STRING [8];
           next : link;
         END;
VAR
  ifn, ofn   : PATHSTR;   { Source/ Dest/ Temp Filename, including dir }
  inpath     : PATHSTR;   { source file path,          }
  indir      : DIRSTR;    {             directory,     }
  fname,
  inname     : NAMESTR;   {             name,          }
  inext      : EXTSTR;    {             extension.     }
  dirinfo    : SEARCHREC; { contains filespec info.    }
  infile, outfile : TEXT; { files read from/written to }
  okay : BOOLEAN;
  Processed : word;

  {----
  The boolean var "done" and pointers (type of 'link') of "anchor" and
  "chain" are used to cope with a bothersome quirk of DOS (I think),
  which allows "findnext" to find files more than once (under certain
  circumstances).  This quirk seems to be due to the order of the file
  names in the FAT, which is altered when a file is written to disk and
  then renamed.
  ----}
  done       : BOOLEAN;
  anchor, chain : link;

  {---- BEGIN the "main" program ----}
BEGIN
  WriteLn (progdesc);
  WriteLn (author);

  IF (ParamCount <> 1) THEN showhelp (1);
  inpath := ParamStr (1);
  FSplit (FExpand (inpath), indir, inname, inext);
  IF (inname = '') THEN showhelp (6);
  inpath := indir + inname+ inext;
  FindFirst (inpath, Archive, dirinfo);
  IF (DosError <> 0) THEN showhelp (3);
  WriteLn;

  New (anchor);
  anchor^. Name := '';
  anchor^. next := NIL;
  Processed := 0;

  {---- Okay, let's go! ----}
  WHILE (DosError = 0) DO BEGIN
    done := FALSE;                      { initialize for each "new" file found }
    ifn := indir + dirinfo. Name;
    fname := GetName (dirinfo. Name);
    IF (Upper (GetExt (dirinfo.Name)) = '.BAK') THEN done := TRUE;
    chain := anchor;                { check if file was processed file already }
    WHILE ((chain^. next <> NIL) AND (NOT done)) DO
      IF (chain^. Name = fname) THEN done := TRUE
      ELSE chain := chain^. next;

    {---- Only process if not processed before ----}
    IF (NOT done) THEN BEGIN
      New (chain);
      chain^. Name := fname;            { add current name to beginning of list }
      chain^. next := anchor;
      anchor := chain;

      {---- Process the file! ----}
      ofn := indir + fname+ '.bak';
      Inc (Processed);
      Write ('Checking ', ifn); {tell user file is being processed}
      openfiles (infile, outfile, ifn, ofn);
      Okay := FixLine (infile, outfile);

      {---- Close files, then find next file to process ----}
      Close (infile);     iocheck;
      Close (outfile);    iocheck;
      IF Okay THEN
      BEGIN
        WriteLn (', adjusted.');
        swapnames (infile, outfile, ifn, ofn);
      END
      ELSE
      BEGIN
        WriteLn (', skipped.');
        erasefile (ofn);
      END;
    END;
    FindNext (dirinfo);
  END;     { now loop back with name of next file to process }
  REPEAT   { dispose of pointers - not necessary at end, but good practice }
    chain := anchor^. next;
    Dispose (anchor);
    anchor := chain;
  UNTIL (anchor = NIL);
  Writeln('Processed ',Processed, ' file(s).');
END.
