;***********************************************************************
;*                                                                     *
;*     SPITFIRE.ASP  Procomm Plus Aspect Script File                   *
;*                                                                     *
;*     This aspect script is intended to be an example for             *
;*     automatic downloading of QWK mail packets and uploading         *
;*     of reply packets.  It uses BUFFALO CREEK'S BBS                  *
;*     as the example BBS to call.                                     *                                              
;*                                                                     *
;*     You will need to change ID, PASSWORD, and birthdate             *
;*     and change reply directory to reflect your own system           *
;*     and then compile for PROCOMM PLUS with the ASPCOMP Utility      *
;*                                                                     *
;*     It may be used with Microqwk from the command line as:          *
;*            microqwk /t /fspitfire                                   *
;*                                                                     *
;*     or added to the end of the terminal command from the            *
;*     Microqwk CONFIGURE / TERMINAL Main Menu Option                  *
;*                                                                     *
;*                                                                     *
;***********************************************************************


define SPITFIRE_NUMBER "1"                 ; entry number in PCPLUS directory
define ID "Your Name^M"                    ; change this
define PASSWORD "password^M"               ; and this

proc main                                  ; start of main procedure
   WHEN 0 "? [y/N]" TRANSMIT "N^M"
   WHEN 1 "birth" TRANSMIT "050750"        ; change to your birthdate

   clear                                   ; clear screen
   locate 0 0                              ; locate cursor at 0,0
   box 0 0 4 79 14                         ; draw box
                                           ; put message in box 

   atsay 2 10 14 "Logging onto BUFFALO CREEK BBS..." 

   locate 6 0                              ; cursor to row 6

   if not fromddir                         ; if not called via Dial Dir link
      dial SPITFIRE_NUMBER                 ; use dialing directory entry for CIS number
   endif
   waitfor "Enter your first name:" forever
   transmit ID                             ; send your ID
   waitfor "Enter your password:"          
   transmit PASSWORD                       ; send password
   waitfor "Main Menu"
   transmit "^M"
   waitfor "MAIN MENU -"
   CALL GETMAIL                            ; goto get mail proc
   pause 1
   transmit "G"
   pause 1
   transmit "Y"
   while connected
   endwhile
   quit
endproc    

PROC GETMAIL                                ; GETMAIL Proc
   transmit "M"
   waitfor "MESSAGE MENU -"
   transmit "L"
   waitfor "LAKOTA MAIN MENU -"             ; use LAKOTA
   transmit "D"
   waitfor "DOWNLOAD MENU -"
   transmit "N"
   waitfor "CONFERENCE MENU -"
   transmit "Y"
   waitfor "PROTOCOL MENU -" forever
                                            ; renames old QWK mail packets
   FINDFIRST "D:\BUFFALO3.QWK"              
       IF found
           delete "D:\BUFFALO3.QWK"
       ENDIF
   FINDFIRST "D:\BUFFALO2.QWK"
       IF found
           rename "D:\BUFFALO2.QWK" "D:\BUFFALO3.QWK"
       ENDIF
   FINDFIRST "D:\BUFFALO1.QWK"
       IF found
           rename "D:\BUFFALO1.QWK" "D:\BUFFALO2.QWK" 
       ENDIF
   FINDFIRST "D:\BUFFALO.QWK"
       IF found
           rename "D:\BUFFALO.QWK" "D:\BUFFALO1.QWK"
       ENDIF

   transmit "Z"                             ; set up for ZMODEM transfer
   waitfor "LAKOTA MAIN MENU -" forever
   CALL SENDMAIL                            ; goto SENDMAIL
   transmit "Q"                             ; return to Main Proc
endproc                  


proc SENDMAIL
   FINDFIRST "C:\MQWK\REPLY\BUFFALO.REP"    ; check for REP packet
   IF found
        transmit "U"                        ; upload by ZMODEM
        waitfor "PROTOCOL MENU -"
        transmit "Z"
        waitfor "Ready to receive"
        sendfile zmodem "C:\MQWK\REPLY\BUFFALO.REP" 
        if success
                                            ; if transmission was completed
                                            ; delete REP packet
            delete "C:\MQWK\REPLY\BUFFALO.REP"
        endif
        waitfor "LAKOTA MAIN MENU -" forever
   ENDIF                                    ; return to GETMAIL proc
endproc
