{$X+}

{
  This is the example file for Terraformer's 6th trainer convering fractal
  plasmas.  See TFTRAIN6.TXT for comments and explanation of code.  All text
  and code written by Jazm / Terraformer (6-2-95)
}

program fractal_plasma;
uses crt;

{ Global Stuff }
var
   chaos : byte;
   temp, tlc, trc, blc, brc, tc, bc, lc, rc, mc : byte;

{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure videomode(mode : byte);assembler;
asm
  xor   ah, ah
  mov   al, [mode]
  int   10h
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure waitforverticalretrace;assembler;
asm
  mov    dx, 3dah
@wait:
  in     al, dx
  test   al, 08h
  jz     @wait
@retr:
  in     al, dx
  test   al, 08h
  jnz    @retr
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure setpal(reg, r, g, b : byte);
begin
  port[$3c8] := reg;
  port[$3c9] := r;
  port[$3c9] := g;
  port[$3c9] := b;
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure plas_pal;
{1-85, 86-170, 171-256}
var x : integer;
    appx : real;
begin
  appx := 62/42;
  for x := 1 to 42 do
    begin
      setpal(x, trunc(appx * x), trunc(appx * x), trunc(appx * x));
      setpal(86-x, trunc(appx * x), trunc(appx * x), trunc(appx * x));
    end;
  setpal(43, 63, 63, 63);

  for x := 1 to 42 do
    begin
      setpal(x+85, trunc(appx * x), 0, 0);
      setpal(171-x, trunc(appx * x), 0, 0);
    end;
  setpal(128, 63, 0, 0);

  for x := 1 to 42 do
    begin
      setpal(x+170, 0, 0, trunc(appx * x));
      setpal(256-x, 0, 0, trunc(appx * x));
    end;
  setpal(213, 0, 0, 63);
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure putpixel(where : word; col : byte);
begin
  mem[$a000:where] := col;
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
function getpixel(where : word): byte;
begin
  getpixel := mem[$a000:where];
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
function min(b1, b2 : byte): byte;
begin
  if b1<b2 then
    min := b1
  else
    min := b2;
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
procedure fillbox(tl, tr, bl, br : word);
var  top, left, right, bottom, mid, sf : word;
begin
  if (tr+320 < br) and (tl+320 < bl) and (tl+1 < tr) then
    begin
      top := (tr-tl) shr 1 + tl;
      bottom := (br-bl) shr 1 + bl;
      right := (br-tr) shr 1 + tr;
      left := (bl-tl) shr 1 + tl;
      mid := (bottom-top) shr 1 + top;

      tlc := getpixel(tl);
      blc := getpixel(bl);
      trc := getpixel(tr);
      brc := getpixel(br);

      temp := getpixel(top-320);
      tc := random(abs(trc-tlc)) + min(trc, tlc);
      if temp <> 0 then
        tc := (temp+tc) shr 1;

      temp := getpixel(bottom+320);
      bc := random(abs(brc-blc)) + min(brc, blc);
      if temp <> 0 then
        bc := (temp+bc) shr 1;

      temp := getpixel(right+1);
      rc := random(abs(trc-brc)) + min(trc, brc);
      if temp <> 0 then
        rc := (temp+rc) shr 1;

      temp := getpixel(left-1);
      lc := random(abs(blc-tlc)) + min(blc, tlc);
      if temp <> 0 then
        lc := (temp+lc) shr 1;

      repeat
        sf:=(((tc+bc) shr 1)+((rc+lc) shr 1)) shr 1+(random(chaos shl 1+1)-chaos);
      until (sf>=0) and (sf<256);
      mc := sf;

      putpixel(top, tc);
      putpixel(bottom, bc);
      putpixel(right, rc);
      putpixel(left, lc);
      putpixel(mid, mc);

      fillbox(tl, top, left, mid);
      fillbox(top, tr, mid, right);
      fillbox(left, mid, bl, bottom);
      fillbox(mid, right, bottom, br);
    end;
end;
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}
{=-=-==-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-}

begin
  chaos := 1;

  randomize;
  videomode($13);

  plas_pal;

  putpixel(0, random(256)+1);
  putpixel(64, random(256)+1);
  putpixel(20480, random(256)+1);
  putpixel(20544, random(256)+1);

  fillbox(0, 64, 20480, 20544);

  readkey;
  videomode(3);
end.
