/********************************************************************/
/* REXX Script to Convert LaMail(TM) Address Files to PMMail Format */
/* This utility written by David J. Looney, 2 September 1995        */
/* Released into the public domain. NO WARRANTY of any kind applies */
/* to this utility.  Suitability, performance, and safety of your   */
/* data is not guaranteed. Use at your own risk.                    */
/********************************************************************/

/* Output Utility Message */
SAY "CVTADDR: UTILITY TO CONVERT LaMail/Ultimail ADDRESS FILES"
SAY "         TO PMMail ADDRESS FILE FORMAT.  D. Looney, 1995.  "
SAY ""
SAY "Create separate address files in PMMail for each file to"
SAY "import, or combine LaMail/UltiMail Lite files with a text"
SAY "editor prior to import under the name of a previously"
SAY "created PMMail address file.  LaMail addresses are found"
SAY "in the \tcpip\LaMail\nickname.nam file. UltiMail may create"
SAY "multiple address books.  They can be found by changing to"
SAY "the root directory and typing 'dir *.hnm /s'.  Under HPFS"
SAY "you may have to use quotes to enclose the long filenames "
SAY "(e.g. 'Address Book.HNM').  Run CVTADDR and designate the"
SAY "output file(s) under the name(s) of previously created "
SAY "PMMail address books, and either copy these files to the"
SAY "PMMail 'Address' directory, or use a text editor to add "
SAY "the converted addresses to an existing PMMail address book."
SAY "DO NOT OVERWRITE A PMMAIL FILE CONTAINING ADDRESSES."
SAY ""

/* Get File Parameters */
CALL CHAROUT ,"Enter Name of Input File: "
PARSE PULL InFile
CALL CHAROUT ,"Enter Name of Output File: "
PARSE PULL OutFile

/* Open Files */
rc=STREAM(InFile, 'c', 'open read')
IF rc<> 'READY:' THEN SIGNAL INFILE_ERROR
rc=STREAM(OutFile, 'c', 'open write')
IF rc<> 'READY:' THEN SIGNAL OUTFILE_ERROR

/* Initialize Variables */
Addresses.0=0
Tally=0
currentln=""

/* Start on beginning of record */
DO WHILE (POS(':nick.',currentln)<>1) & (LINES(InFile)<>0)
   currentln=LINEIN(InFile)
END

/* Parse File */
DO WHILE lines(InFile)<>0 
   RecordStart=POS(':nick.',currentln)
   Tally=Tally+1
   Addresses.0=Tally
   Nick=SUBSTR(currentln,7,LENGTH(currentln)-6)
   currentln=LINEIN(InFile)
   Name=''
   Node=''
   Userid=''
   Phone=''
   DO WHILE (POS(':nick',currentln)<>1) & (LINES(Infile)<>0)
       Strlen=LENGTH(currentln)
       IsName=POS(':name.',currentln)
       IF IsName<>0 THEN
         DO
           Name=RIGHT(currentln,Strlen-(IsName+5))
         END
       IsNode=POS(':node.',currentln)
       IF IsNode<>0 THEN
         DO
           Node=RIGHT(currentln,Strlen-(IsNode+5))
         END
       IsUserID=POS(':userid.',currentln)
       IF IsUserID<>0 THEN
         DO
           Userid=RIGHT(currentln,Strlen-(IsUserID+7))
         END
       IsPhone=POS(':phone.',currentln)
       IF IsPhone<>0 THEN
         DO
           Phone=RIGHT(currentln,Strlen-(IsPhone+6))
         END
       currentln=LINEIN(InFile)
   END
   /* Build PMMail Address File Lines */
   Addresses.Tally.TITLE=Name||' ('||Nick||')'
   Addresses.Tally.EMAIL=Userid||'@'||Node
   Addresses.Tally.COMPANY=' '
   Addresses.Tally.FONE=Phone
   Addresses.Tally.COMMENT=' '
   /* Write PMMail Address File Entry */
   CALL LINEOUT OutFile, Addresses.Tally.TITLE
   CALL LINEOUT OutFile, Addresses.Tally.EMAIL
   CALL LINEOUT OutFile, Addresses.Tally.COMPANY
   CALL LINEOUT OutFile, Addresses.Tally.FONE
   CALL LINEOUT OutFile, Addresses.Tally.COMMENT
END

/* Close Files */
CALL STREAM InFile, 'c', 'close'
CALL STREAM OutFile, 'c', 'close'

EXIT

/* Error Routines */
INFILE_ERROR:
Say ''
Say 'Error Opening File: '||InFile
Say ''
EXIT

OUTFILE_ERROR:
Say ''
Say 'Error Creating/Opening File: '||OutFile
Say ''
EXIT


