/* REXX */
/*
     OS/2 WARP REXX script to redial a PPP provider when busy. 

      Written by: Don Russell (c) 1995
      send email to drussell@direct.ca

Change log: (most recent first)
     10 May 19995 Version: 2.3
                    Fix the redial broken by SLIPPM.EXE V2.0 R1.8h :-(
                    Support CTRL- sequences in response file.
                    Issue OS/2 commands from the response file.
                    Recognize "protocol" as a valid connected response.
     23 April 1995  Version: 2.2
                    Recognize "COMPRESSION" result codes from some
                       modems. (TRON, Supra)
                    Change response file processing to be more flexible.
     15 April 1995  Version 2.1
                    Fix trapping of hung connection (dropped
                       by V2.0 changes)
     14 April 1995: Version 2.0
                    Recognize CARRIER ... response from some 28.8 modems
                    Support multiple phone numbers
                    Get userid/password from dialer
                    Get timing info from modem instead of "hard coded"
                    Support response after login
      8 April 1995: Original
pause
A note about distribution.... This script may be distributed freely provided
I am given credit for it. Please do not alter my name or email address
nor the manner in which they are displayed.

If you have comments regarding this script let me know by email. I'll
support it as time permits, and my ability ;-)

NOTE: I've tested this as well as I can with a single provider. Given the many
providers and configurations, this may not work properly the first time.

If you have problems with pppdial, please refer to the readme.txt file.

Specific things to watch for are the EXACT prompts used when the host
system is asking for a userid and password. (see line 47/48)

stop-----------------------------------------------------------------*/

/* ************************************************************** */
/*   YOU MAY NEED TO CHANGE THE FOLLOWING CONFIGURATION VARIABLES.   */
/*                                                                                                         */

ModemResetCommand = 'ATH0Z'
ModemEscapeSequence = '+++'
LoginPrompt = 'ogin:'
PasswordPrompt = 'ssword:'

/*                                                                                                         */
/* DO NOT CHANGE ANYTHING AFTER THIS POINT. */
/*   (unless you are familiar with REXX and do not use the IBM Dialer)      */
/* **************************************************************** */

/* A note to users of my first version of this script: */
/* I used to support the dial command, userid and password as parameters */
/* or coded here as k1=, k2= and k3= */
/* I did not like this because I felt it better to get them from the dialer */
/* where it is a little more intuitive and easier for people who know nothing of REXX */

/* For those of you who wish to use this script withOUT the dialer... */
/* change the next line to say UseDialer=0 (false) and define the appropriate labels */
/* (When UseDialer is 1, these variables are reassigned later from the dialer info) */

LoginId = 'userid'
Password = 'password'

/*                                                                                                         */
/* DO NOT CHANGE ANYTHING AFTER THIS POINT. */
/* **************************************************************** */

call rxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

parse upper source . . MyDrivePathName
etcDrivePath = translate( value( 'etc',,'OS2ENVIRONMENT') )
iniFile = etcDrivePath || '\TCPOS2.INI'

/* before we get too carried away, let's see what we're doing... */

if RxFuncQuery( 'ppp_com_input' ) = 1 then do
   if RxFuncQuery( 'slip_com_input' ) = 0 then do
      call lineout ,'This script is for PPP only.'
      call lineout ,'Your dialer is set for SLIP.'
      call lineout ,'Change your dialer and try again.'
      exit 4
   end  /* Do */
   
   call NotFromDialer
   exit 0
end  /* Do */

parse arg interface , port , . , RFile

if RFile \= '' then do
   RFile = stream( RFile, 'C', 'QUERY EXISTS' )
   if RFile = '' then do
       call lineout , 'Response file not found.'
       call lineout , 'Processing ended.'
       exit 8
   end  /* Do */
   
   x = linein( RFile )
   if (( x \= 'GO') & (x \= 'WAIT' )) then do
      call lineout , 'First line of response file must be GO or WAIT.'
      call lineout , 'Processing ended.'
      exit 8
   end /* Do */
end  /* Do */

/*--------------------------------------------------------------------------*/
/*                   Initialization and Main Script Code                    */
/*--------------------------------------------------------------------------*/

/* Set some definitions for easier COM strings */
cr='0d'x
crlf='0d0a'x

UsePhoneNumberFile = 0
UsePhoneNumberList = 0
Service = 'PPP'
Disable = 0

/* initialize variables that MAY be set by a response file... */
UseDialer = 1    /* yes, we're using the IBM "Dial Other..." */
init1 = ''
init2 = ''
ModemRegS7 = -1   /* if still < 0 later, we get it from the modem */
MaxAttempts = 32767
pause = 10             /* seconds between dial attempts */
prefix = 'ATDT'            /* add any other commands required */
PhoneNumber = 'xxx-xxxx'   /* may be a blank delimited list, or file name */

if RFile \= '' then do
   if \ProcessRFileCommands() then do
      say 'Processing ended due to response file error.'
      exit 8
   end  /* Do */
end

if UseDialer then do
    /* Get userid/password etc. from the dialer */
    ConnectTo = SysIni( iniFile, 'CONNECTION', 'CURRENT_CONNECTION' )

    Init1 = Strip( SysIni( iniFile, ConnectTo, 'INIT' ), 'T', '00'x )
    Init2 = Strip( SysIni( iniFile, ConnectTo, 'INIT2' ), 'T', '00'x )
    Prefix = Strip( SysIni( iniFile, ConnectTo, 'PREFIX' ), 'T', '00'x )
    PhoneNumber = Strip( SysIni( iniFile, ConnectTo, 'PHONE_NUMBER' ), 'T', '00'x )
    LoginId = Strip( SysIni( iniFile, ConnectTo, 'LOGIN_ID' ), 'T', '00'x )
    Password = Strip( SysIni( iniFile, ConnectTo, 'PWD' ), 'T', '00'x )
    Disable = Strip( SysIni( who, ConnectTo, 'DISABLE' ), 'T', '00'x )
    DisableSequence = Strip( SysIni( who, ConnectTo, 'DISABLE_SEQUENCE' ), 'T', '00'x )
    Service = Strip( SysIni( who, ConnectTo, 'SERVICE' ), 'T', '00'x )

    Disable = ( Disable = 'TRUE' )
end /* Do */

if \datatype( pause, 'N' ) then do
   call lineout , 'invalid time delay specified - 10 sec assumed'
   pause = 10
end  /* Do */

pause = max( 2, pause )  /* A 2 sec minimum delay is required to guarantee dial tone */

/* The "phone number" may be a list of numbers, or a file spec of a list of numbers. */
if words( PhoneNumber ) > 1 then do
   /* Yup, it's a list itself... */
   UsePhoneNumberList = 1
   PhoneNumberList = PhoneNumber
   PhoneNumberListSize = words( PhoneNumber )
end  /* Do */
else do
   PhoneNumberFile = stream( PhoneNumber, 'C', 'QUERY EXISTS' )
   if PhoneNumberFile \= '' then do
      UsePhoneNumberFile = 1
   end  /* Do */
   else /* it's not a list or a (found) file... */
       DialCmd = BuildDialCmd( 0 )
   end /* else */

/* Flush any stuff left over from previous COM activity */
call flush_receive

call ResetModem

/* How long will the modem wait for carrier? */
/* We have to wait a bit longer for a response then... */

/* This value may have been supplied in the response file... */
if ModemRegS7 < 0 then do
   call lineout , 'Determining modem timeout value...'
   call send 'ATS7?' || cr
   x = GetResult( 2 )
   parse var x ModemRegS7 '0d'x .
   if \datatype( ModemRegS7, 'N') then
      ModemRegS7 = 60
end /* Do */

FirstTime = 1
do count = 1 by 1 to MaxAttempts

    connected = 0
    hangup = 0

    if (UsePhoneNumberList | UsePhoneNumberFile) then do
        DialCmd = BuildDialCmd( count )
    end /* Do */

    if \FirstTime then do
       call lineout , 'Waiting' pause 'seconds before try' count
       call lineout , '  PPPDIAL V2.3 by: drussell@direct.ca'
       call lineout , '          Copyright 1995 Don Russell'
       call sysSleep pause
    end  /* Do */
    FirstTime = 0

    /* Dial the remote server */
    call charout , 'Dialing...'

    /* Wait for connection */
    call send dialcmd || cr
 
    do until \abbrev( ResultCode, 'RINGING' )
       ResultCode = getresult( ModemRegS7 + 10 )
    end /* Do until */

    select
       /* Modem responses that indicate we should redial */
       when abbrev( ResultCode, 'BUSY' ) then nop
       when abbrev( ResultCode, 'NO CARRIER' ) then nop

       /* Modem responses that indicate we should hangup and redial */
       /* My modem supports a &N command that allows me to set the */
       /* acceptable connect rate. By setting this at the highest setting */
       /* I cause redialing to occur until I get that speed. */
       /* when abbrev( ResultCode, 'CONNECT 1200' ) then hangup = 1 */

       /* modem responses that indicate we got connected */
       when abbrev( ResultCode, 'CONNECT' ) then connected = 1
       when abbrev( ResultCode, 'CARRIER' ) then connected = 1       /* ZOOM */
       when abbrev( ResultCode, 'COMPRESSION' ) then connected = 1   /* TRON, Supra  */
       when abbrev( ResultCode, 'PROTOCOL' ) then connected = 1      /* Megahertz */

       /* modem responses that indicate we should give up */
       when abbrev( ResultCode, 'ERROR' ) then exit 8
       when abbrev( ResultCode, 'VOICE' ) then exit 8

    otherwise do
       /* The modem response was not recognized.... */
       /* Can I query the serial port to check for DCD? */
       /* If DCD is present, then who cares about the response? :-)  */
            /* code to be developed */
       /* DCD is NOT present, and the response was not recognized... */
       /* ... so I don't know if the modem is on/off hook here :-(  */
       call ResetModem  
       end /* otherwise */
    end  /* select */

    if hangup then do
       call lineout , 'Hanging up due unsatisfactory connection'
       call ResetModem
       iterate
    end  /* Do */

    if \connected then do
       iterate
    end
  
    /* I'd like to include a check for a minimum connection data rate */
    /* here so that if, due to bad phone lines, we get a poor rate */
    /* we hang up and dial again... */
    /* code to be developed ... for now add the statements to the select above */
    /* or use something like the &N modem command. */

    /* OK.. all we've done so far is get the modems connected. */
    /* If there is a "response file"... process it, otherwise try */
    /* a "reasonable" combination of login and password prompts. */
    
    if RFile \= '' then do
       call lineout , 'Continuing with response file...'
       if \ProcessRFile() then do
          call ResetModem
          iterate
       end
       call lineout , ' '
       call lineout , 'Response file completed.'
    end  /* Do */
    else do
       if \ProcessLogin() then do
          call ResetModem
          iterate
       end
       call lineout , ' '
    end  /* Do */

    leave           /* force the end of the loop */
end /* do */

if UsePhoneNumberFile then
   call lineout PhoneNumberFile  /* close the phone number file */

call beep 262, 250
call beep 294, 250

exit 0

BuildDialCmd:
   Parse arg item
   DialCmd = Prefix
   If Disable then
      DialCmd = DialCmd || DisableSequence
     
   /* The phone number may be a group... get the next in the list/file */
   select
      when UsePhoneNumberList then do
          x = (item // PhoneNumberListSize) + 1
          num = word( PhoneNumberList, x )
      end  /* Do */
      when UsePhoneNumberFile then do
         FileWrapped = 0
         do until num \= ''
             num = linein( PhoneNumberFile )
             if num = '' then do
                if FileWrapped then do
                   call lineout ,'Phone number file appears empty.'
                   exit 8
                end  /* Do */
                call linein PhoneNumberFile, 1, 0 /* re-point to start */
                FileWrapped = 1
             end  /* Do */
         end  /* Do until */
      end /* Do when */
   otherwise
      num = PhoneNumber
   end  /* select */

   DialCmd = DialCmd || num
   return DialCmd

ProcessLogin:
   success = 1 /* we'll assume it works... */
   call waitfor LoginPrompt, 30
   if result = 1 then do
      call lineout , 'Host is not asking for userid.'
      success = 0
   end  /* Do */
   else do
      call send loginId || cr

      call waitfor PasswordPrompt, 30
      if result = 1 then do
         call lineout , 'Host is not asking for password.'
         success = 0
      end  /* Do */
 
      call send password || cr
   end /* do */
return success

ProcessRFile:
   RFileProcessed = 1         /* we'll assume success :-)  */
   call linein RFile, 1, 0    /* repoint the file to the beginning */
   x = linein( RFile )
   select
      when x = 'GO' then ResponseToggle = 1
      when x = 'WAIT' then ResponseToggle = 0
   end  /* select */
   do while lines( RFile ) & RFileProcessed
      x = linein( RFile )
      if x = '' then     /* ignore blank lines */
         iterate
      if abbrev( x, '[PPPDIAL_' ) then    /* ignore parm settings */
         iterate
      if abbrev( x, '[OS/2]' ) then do
         parse var x ']'os2Command
         address CMD os2Command
         iterate
      end  /* Do */

      if ResponseToggle then do
          /* we are sending to the host... */
          select
             when x = '[LOGINID]' then call send LoginId || cr
             when x = '[PASSWORD]' then call send Password || cr
             when abbrev( x, '[REPEAT]' ) then do
                parse var x . y z k     /* get string to send, string to wait for and count */
                if k = '' then k = 1000  /* repeat lots if not told otherwise */
                MatchFound = 0
                do k until MatchFound  /* successful match */
                   select
                      when pos( '^', y ) \= 0 then call send CtrlSequence( y )
                      when y = '\r' then call send cr
                   otherwise call send y || cr
                   end  /* select */
                   if waitfor( z , 5 ) = 0 then do /* successful match */
                      MatchFound = 1
                   end  /* Do */
                end /* until */
                if \MatchFound then do    /* retry count exhausted, no match found */
                   RFileProcessed = 0     /* we encountered a problem... */
                end  /* Do */
                else do
                   /* The string was repeated and we got the expected match... */
                   /* I change the toggle so that it will be set to "send" again for */
                   /* the next line in the response file. */
                   ResponseToggle = \ResponseToggle
                end  /* Do */
             end  /* when [REPEAT] */
             when pos( '^', x) \= 0 then call send CtrlSequence( x )
             when x = '\r' then call send cr
          otherwise call send x || cr
          end  /* select */
          end
      else do
          if waitfor( x, 20 ) = 1 then do
              call lineout , 'Host not responding'
              RFileProcessed = 0   /* terminate processing and dial again :-(  */
          end /* Do */
      end /* Do */
      ResponseToggle = \ResponseToggle
   end /* While */
   call lineout RFile /* close the file */
return RFileProcessed

ProcessRFileCommands:
   success = 1   /* assume all is OK */
   do while lines( RFile )
      x = linein( RFile )
      if x = '' then      /* ignore blank lines */
         iterate
      if \abbrev( x, '[PPPDIAL_' ) then
         iterate
      parse var x '_'kw']'val
      val = strip( val, 'B')
      select
         when kw = 'CARRIER_TIMEOUT' then ModemRegS7 = val
         when kw = 'DELAY' then pause = val
         when kw = 'DO_NOT_USE_DIALER' then UseDialer = 0
         when kw = 'INIT1' then init1 = val
         when kw = 'INIT2' then init2 = val
         when kw = 'MAX_REDIAL' then MaxAttempts = val
         when kw = 'PHONE' then PhoneNumber = val
         when kw = 'PREFIX' then prefix = val
         when kw = 'REM' then nop   /* allow comments... */
         when kw = 'USE_DIALER' then UseDialer = 1
      otherwise do 
         call lineout , kw 'is not a recognized keyword.'
         success = 0
      end /* otherwise */
      end  /* select */
   end /* while */
return success

CtrlSequence:
    parse arg string
    /* we do a logical AND X'1F' with the character... */
    /* The "character" should only be in the range of 40 through 5F, */
    /* but who cares... the effect will be the same */
 
    do until x = 0
       x = pos( '^', string )
       if x \= 0 then do
          y = substr( string, x+1, 1)   /* isolate the character following ^ */
          string = insert( bitand( y, '1F'x ), string, x+1 )
          /* delete the character pair from the string */
          string = delstr( string, x, 2 )
      end /* Do */
    end
    return string

ResetModem:
    call lineout , 'Initializing modem...'
    if init1 \= '' then do
       call send init1 || cr
       ResultCode = GetResult( 6 )
    end  /* Do */
    if init2 \= '' then do
       call send init2 || cr
       ResultCode = GetResult( 6 )
    end  /* Do */

    if ((init1 = '') & (init2 = '')) then do
       call send ModemResetCommand || cr
       ResultCode = GetResult( 6 )
    end  /* Do */
    
    if left(ResultCode , 2) \= 'OK' then do
        call lineout , 'Modem not resetting... Trying again'
        call sysSleep 2
        call send ModemEscapeSequence
        call waitfor crlf, 5
        call send ModemResetCommand || cr
        call getresult 3
    end /* Do */
    call flush_receive 'echo'
return

/* Routine to send a modem command. */

send:
   parse arg AtCmd
   call flush_receive
   call ppp_com_output interface , AtCmd
   return

/* Waits for any modem response, and returns the string.    */
/* If timeout is specified, it says how long to wait if data stops showing  */
/* up on the COM port (in seconds).                                                         */
getresult:
   parse arg timeout
   call waitfor crlf, timeout
   if result = 0 then
      call waitfor crlf, timeout

   if result = 1 then /* timed out */
      return '*timedout*'
   else
      return waitfor_buffer


/*--------------------------------------------------------------------------*/
/*                    waitfor ( waitstring , [timeout] )                    */
/*                                                                          */
/* Waits for a specific string from the modem. */
/* Timeout is specified in seconds.  */

waitfor:
   parse arg waitstring , timeout
   if timeout = '' then do
      timeout = 90    /* 1.5 minutes if delay not specified */
   end

   waitfor_buffer = ''
   done = -1
   curpos = 1

   if (remain_buffer = 'REMAIN_BUFFER') then do
      remain_buffer = ''
   end

   call time 'E'
   do while (done = -1)
      if (remain_buffer \= '') then do
         line = remain_buffer
         remain_buffer = ''
       end
       else do
         line = ppp_com_input(interface,,10)
      end
      waitfor_buffer = waitfor_buffer || line
      index = pos(waitstring,waitfor_buffer)
      if (index > 0) then do
         remain_buffer = substr(waitfor_buffer,index+length(waitstring))
         waitfor_buffer = delstr(waitfor_buffer,index+length(waitstring))
         done = 0
      end
      /* remove due slippm v2.0 r1.8h ... call charout , substr(waitfor_buffer,curpos) */
      /* the following code "translates" the modem responses that slippm chokes on */
      /* so that we can keep the user informed and still stay in control */
      x = substr(waitfor_buffer, curpos)
      select
         when pos('BUSY', x) > 0 then call lineout ,'Busy'
         when pos('NO CARRIER', x) > 0 then call lineout ,'No carrier'
      otherwise call charout , x
      end  /* select */
    
      curpos = length(waitfor_buffer)+1
      if ((done \= 0) & (time('E')>timeout)) then do
        done = 1   /* we timed out :-(  */
       end
   end

 return done

/*--------------------------------------------------------------------------*/
/*                             flush_receive()                             */
/*                                                                          */
/* Routine to flush any pending characters to be read from the COM port.    */
/* Reads everything it can until nothing new shows up for 100ms, at which   */
/* point it returns.                                                        */
/*                                                                          */
/*--------------------------------------------------------------------------*/

flush_receive:

   parse arg echo

   /* If echoing the flush - take care of waitfor remaining buffer */
   if (echo \= '') & (length(remain_buffer) > 0) then do
      call charout , remain_buffer
      remain_buffer = ''
   end

   /* Read anything left in the modem or COM buffers */
   /* Stop when nothing new appears for 100ms.      */

   do until line = ''
     line = ppp_com_input(interface,,100)
     if echo \= '' then
        call charout , line
   end

   return

NotFromDialer:
    parse upper source . . MyDrivePathName
    MyDrive = filespec( 'D', MyDrivePathName )
    MyPath = filespec( 'P', MyDrivePathName )
    MyDrivePath = MyDrive || MyPath

    etcDrivePath = translate( value( 'etc',,'OS2ENVIRONMENT') )
    binDrive = filespec( 'D', etcDrivePath )
    binPath = filespec( 'P', etcDrivePath ) || 'BIN\'
    binDrivePath = binDrive || binPath

    EraseFile = 0
    if binDrivePath \= MyDrivePath then do
        say 'This script will be moved to' binDrivePath
        say 'Do you wish to continue? (y/n)'
        say '(Saying no will still show help)'
        answer = translate( sysGetKey( 'ECHO' ) )
        if answer = 'Y' then do
            'COPY' MyDrivePathName binDrivePath
            if rc = 0 then do
               say MyDrivePathName 'will be erased after displaying help'
               EraseFile = 1
            end
           '@PAUSE'
           call sysCls
        end /* Do */
    end  /* Do */

    call sysCls
    stop = 0
    do i = 3 by 1 until stop
       x = sourceline( i )
       if left( x, 5 ) = 'pause' then do
          '@PAUSE'
          call sysCls
          iterate
       end  /* Do */
       
       if left( x, 4 ) \= 'stop'  then
          say x
       else
          stop = 1
    end /* do */
    '@PAUSE'
    if EraseFile then
        'ERASE' MyDrivePathName
return
