/* Script to install Program object Creation program */
/* Copyright (c) 1995 Anssi Blomqvist */

Call rxfuncadd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

/* Variables */
valid = 0
Name = 'Program Creator'
Filecount = 3
File = 'CrPrObj.cmd CrPrObj.ico ReadMe.txt'

Say '           Installation program for Program Object Creator'
Say '           -----------------------------------------------'
Say
Say '(c) 1995 Anssi Blomqvist, abblomqv@fltxa.helsinki.fi'
Say

Invalid = 'Invalid path!'
GetPath:
Do until valid
   Say 'Give the full path where to install the program.'
   Say 'e.g. D:\UTILS\CrProg :'
   Pull Dest
   valid = Pos(':', Dest)=2 & Pos('\', Dest)=3 & Lastpos('\', Dest)<>Length(Dest)
   If \valid Then Say Invalid
End

rc = SysMkDir(Dest)
If rc <> 0 & rc <> 5 then 
Do
   Say Invalid
   signal GetPath
End
Say 'Installation in progress...'
Do i=1 to filecount
   '@copy 'Word(File, i) Dest
   If rc <> 0 then signal error
end /* do */
Say

Program = Insert(Dest, "\CrPrObj.cmd")
Program = Insert('EXENAME=', Program)
result=SysCreateObject("WPProgram", Name, "<WP_DESKTOP>", Program, "r")
If result = 1 Then Say 'Installation was successfull.'
   Else Signal Error
If \SysSetIcon('CrPrObj.cmd', 'CrPrObj.ico') then signal error
Exit

Error:
   Beep(440,400)
   Say 'Installation failed!'
   '@Pause'
Exit
