/* SeaHaven Towers for OS/2 installation program */

  Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
  Call SysLoadFuncs

  Parse Arg InstallDir SeaVer
  Signal On Halt Name ErrorHandler

  Say " "
  Say " "
  Say " "
  Say " SeaHaven Towers for OS/2 Installation"

  If InstallDir=" " Then Do
    Say
    Say " Please specify the name of the subdirectory to"
    Say " which you would like to install SeaHaven Towers,"
    Say " hit <ENTER> to use the current directory, or type"
    Say " 'Q'<ENTER> to quit."
    Say " "
    Say " For Example:  C:\SEAHAVEN<ENTER>"
    Say " "
    Say " Directory to install to:"

    Parse Value SysCurPos() with Row Col
    Col=Col+26
    Row=Row-1
    Call SysCurPos Row, Col
    Pull InstallDir
    If (InstallDir="Q")|(InstallDir="q") Then Exit
  End

  If InstallDir=" " Then InstallDir=directory()

  Else Do

    Call SysFileTree InstallDir, FileDirectory, 'D'

    If FileDirectory.0='0' Then Do
      Say
      Say " Now creating directory "InstallDir" . . ."
      rc=SysMkDir(InstallDir)
      If rc\=0 Then Do
        Say " "
        Say " Error creating directory "InstallDir" . . ."
        Say " You may have specified an invalid directory name."
        Say " Rerun install to try again."
        Exit
      End
    End
   End

  If SeaVer=" " Then Do
    Say
    Say " Which version of SeaHaven Towers would you like to install:"
    Say " "
    Say " 'C'<ENTER>  Compatible with OS/2 2.x and higher.   (560K)"
    Say " 'W'<ENTER>  Only works with OS/2 Warp.             (240K)"
    Say " "
    Say " Note: There is no difference in playability between the "
    Say "       versions.  The Warp version only uses different "
    Say "       compiler switches to significantly reduce the size "
    Say "       of the executable. "
    Say " "
    Say " Version to install:"

    Parse Value SysCurPos() with Row Col
    Col=Col+21
    Row=Row-1
    Call SysCurPos Row, Col
    Pull SeaVer
  End


  Say " "
  Say " Now copying files . . ."                              /* Now copy files */
  Call FileUnpack 'SeaHaven.HL_', InstallDir
  Call FileCopy 'ReadMe', InstallDir
  if (SeaVer="C")|(SeaVer="c") then
    Call FileUnpack 'SeaHaven.EX_', InstallDir
  else if (SeaVer="W")|(SeaVer="w") then
    Call FileUnpack 'SeaWarp.EX_', InstallDir
  else do
    Say SeaVer" is not a valid version."
    Say "Rerun Install."
    Exit
  End
  Say " "
  Say " Now creating WPS program object . . ."                  /* Now create the Desktop object*/
  SetupString="EXENAME="InstallDir"\SeaHaven.EXE;STARTUPDIR="InstallDir

  rc=SysCreateObject("WPProgram","SeaHaven Towers","<WP_DESKTOP>",SetupString)
  If rc=0 Then Do
    Say
    Say " Sorry, couldn't create the SeaHaven Tpwers program object."
    Say " You may already have a SeaHaven Towers program object on your"
    Say " Desktop.  Delete this object and rerun install. "
    Exit
  End

  Say
  Say " SeaHaven Towers for OS/2 successfully installed."

  Exit


/******* FileCopy procedure */

  FileCopy: Arg FileName, Destination

    Command='@Copy 'FileName' 'Destination' >NUL'
    Command
    Return

/******** FileUnpack procedure ********/
  FileUnpack: Arg FileName, Destination

    Command='@Unpack 'FileName' 'Destination' >NUL'
    Command
    if rc\=0 Then Do
        Say " "
        Say " Error unpacking file "FileName".  Make sure "
        Say " this file is in the current directory and "
        Say " rerun install."
        exit
     End
     Return


/******* ErrorHandler procedure */

  ErrorHandler:

    Call SysCls
    Say "Unknown error - aborting installation . . ."
    Say "Contact the author with details please."
  Exit

