//  Listing 3 - Count3 program

#include <cstring.h>
#include <iomanip.h>
#include <algo.h>
#include <map.h>
#include <vector.h>

struct long_t { long v; long_t() : v(0) {} };

typedef map< string, long_t, less<string> > map_t;
struct ct_t { string str; long_t count; };
typedef vector< ct_t >                      vec_t;

static inline int show_m( const map_t::value_type& x )
  { cout << setw(7) << x.second.v << " - " << x.first << endl; }

static inline bool order( const ct_t& x, const ct_t& y )
  { return x.count.v > y.count.v; }

static inline int show_v( const ct_t& x )
  { cout << setw(7) << x.count.v << " - " << x.str << endl; }

int main() {

  string   str;
  map_t    ct_map;

  while ( cin >> str ) ++ct_map[str].v;

  cout << "Ordered by string:" << endl;
  for_each( ct_map.begin(), ct_map.end(), ptr_fun( show_m ) );

  vec_t    ct_vec;

  ct_vec.reserve( ct_map.size() );

  for ( map_t::iterator it = ct_map.begin();
        it != ct_map.end(); ++it ) {
    ct_t ct;
    ct.str = (*it).first;
    ct.count = (*it).second;
    ct_vec.push_back( ct );
    }

//  stable_sort( ct_vec.begin(), ct_vec.end(), ptr_fun( order ) );
  sort( ct_vec.begin(), ct_vec.end(), ptr_fun( order ) );

  cout << "Ordered by count:" << endl;
  for_each( ct_vec.begin(), ct_vec.end(), ptr_fun( show_v ) );

  return EXIT_SUCCESS;
  }
