article\Listing4

/////////////////////////////////////////////////////
//    ENGINE implementation, an abstract generator
/////////////////////////////////////////////////////
#include "ENGINE.HPP"
#include "BSTACK.HPP"
#include <stdio.h>
#include <time.h>
#include <stdlib.h>

const char ENGINE::_Class[] = "[CLASS]";
const char ENGINE::_FlagOn[] = "#[";
const char ENGINE::_FlagOff[] = "#]";

ENGINE::ENGINE(const char szHpp[], const char szCpp[])
    : _inHpp(szHpp), _inCpp(szCpp), _stamp(50)
{
_stamp += "//////// AB CLASSGEN ";
time_t t = time(&t);
_stamp += ctime(&t);
_stamp[_stamp.len() - 1] = ' ';
_stamp += "////////\n";
}

const char* ENGINE::_substitute(const char newClass[])
{
int i, last;
_outLine = "";
i = last = 0;
while(-1 != (i=_inLine.hasin(_Class, last))){
    for(int j = last; j < i; j++)
        _outLine += _inLine[j];
    _outLine += newClass;
    last = i+strlen(_Class);
    }
_outLine += _inLine+last;
return _outLine;
}

void ENGINE::_fileJob(const char szInFile[],
                const char szOutFile[],
                const char newClass[], SYM *pSym)
{
FILE *in, *out;
if(0 == (in = fopen(szInFile, "rt"))){
    cannotOpen(szInFile);
    return;
    }
if(0 != (out = fopen(szOutFile, "rt"))){
    fclose(out);
    if(0 == overwriteQuest(szOutFile)){
        fclose(in);
        return;
        }
    }
if(0 == (out = fopen(szOutFile, "wt"))){
    fclose(in);
    cannotOpen(szOutFile);
    return;
    }
fputs(_stamp, out);
BSTACK Markers;
STR InBuf(MAXLEN);
for(int l = 0;
        fgets((char*)(const char*)InBuf, MAXLEN, in);
        l++){
    _inLine = InBuf;
    STR sym(40);
    STR val(40);
    int i, k;
    if(-1 == (i = _inLine.hasin(_FlagOn))){
        if(-1 == _inLine.hasin(_FlagOff)){
            if(Markers.top())
                fputs(_substitute(newClass), out);
            continue;
            }
        else{    // it's the end of a block
            if(Markers.empty()){
                unexpectedEOB(szInFile, l+1);
                break;
                }
            Markers.pop();
            continue;
            }
        }
    // Ok, it's the beginning of a block:
    if(!Markers.top()){ // do not generate anyway
        Markers.push(BSTACK::NOT);
        continue;
        }
    i += strlen(_FlagOn);
    for(k = 0; _inLine[i] && _inLine[i] != '=';
            i++, k++)
        sym += _inLine[i];
    if(!_inLine[i]){
        Markers.push(BSTACK::NOT);
        continue;
        }
    for(k = 0, i++; _inLine[i] ; i++, k++)
        val += _inLine[i];
    sym.noTrailSpace(); sym.noFrontSpace();
    val.noTrailSpace(); val.noFrontSpace();
    Markers.push(atoi(val) == pSym->get(sym) ?
                        BSTACK::YES : BSTACK::NOT);
    continue;
    }
if(!Markers.empty())
    missingEOB(szInFile, l);
fclose(in);
fclose(out);
runEditor(szOutFile);
}

void ENGINE::go(const char szDir[],
            const char szClass[], SYM* pSym)
{
STR Hpp(szClass); Hpp += ".HPP";
STR Cpp(szClass); Cpp += ".CPP";
STR OutHpp(szDir); OutHpp += '\\'; OutHpp += Hpp;
STR OutCpp(szDir); OutCpp += '\\'; OutCpp += Cpp;
_fileJob(_inHpp, OutHpp, szClass, pSym);
_fileJob(_inCpp, OutCpp, szClass, pSym);
}
