article\Listing3

#if !defined(ENGINE_HPP)
#define ENGINE_HPP
/////////////////////////////////////////////////////
//    ENGINE + SYM definition, an abstract generator
/////////////////////////////////////////////////////
#include "STR.HPP"

class SYM {
public:
    virtual void set(const char szSym[], int nVal)= 0;
    virtual int get(const char szSym[]) = 0 ;
            // if szSym not found, should return 0
};

class ENGINE {
    enum { MAXLEN = 1024 };
public:
    ENGINE(const char szHppTemplate[],
            const char szCppTemplate[]);
    virtual ~ENGINE() {}

    void go(const char szTargetDir[],
            const char szClass[], SYM* pSym
            );
protected:
    static const char _Class[];
    static const char _FlagOn[];
    static const char _FlagOff[];
private:
// to be redefined for some presentation layer:
    virtual void cannotOpen(
                    const char szFileSpec[]) = 0;
    virtual int overwriteQuest(
                    const char szFileSpec[]) = 0;
    virtual void unexpectedEOB(
                    const char szFileSpec[],
                    int nLine) = 0;
    virtual void missingEOB(
                    const char szFileSpec[],
                    int nLine) = 0;
    virtual void runEditor(
                    const char szFileSpec[]) {}

    const STR _inHpp;
    const STR _inCpp;
    STR _inLine, _outLine, _stamp;

    void _fileJob(const char szInFile[],
                const char szOutFile[],
                const char newClass[], SYM *pSym
                );
    const char* _substitute(const char newClass[]);
};
#endif
