article\Listing5

/////////////////////////////////////////////////////
//    WENGINE + WSYM Implementation
/////////////////////////////////////////////////////
#include "WENGINE.HPP"
#include <stdlib.h>
#include <stdio.h>

WSYM::WSYM(const char szApp[], const char szSect[])
        : SYM(), _name(szApp),
        _sect(szSect ? szSect : "DEFAULT")
{
_name += ".INI";
}

int WSYM::get(const char szSym[])
{
return GetPrivateProfileInt(_sect, szSym, 0, _name);
}

void WSYM::set(const char szSym[], int nNumValue)
{
char Buff[16];
itoa(nNumValue, Buff, 10);
WritePrivateProfileString(_sect, szSym, Buff, _name);
}


WENGINE::WENGINE(const char szHppTemplate[],
        const char szCppTemplate[], HWND hWnd)
    : ENGINE(szHppTemplate, szCppTemplate)
{
_hWnd = hWnd;
}

void WENGINE::cannotOpen(const char szFile[])
{
MessageBox(_hWnd, "Unable to open file", szFile,
            MB_ICONSTOP | MB_OK);
}

int WENGINE::overwriteQuest(const char szFile[])
{
return IDYES == MessageBox(_hWnd,
        "File already exists, overwrite?",
        szFile, MB_ICONQUESTION | MB_YESNO);
}

void WENGINE::unexpectedEOB(const char szFile[],
                    int nLine)
{
_errorEOB("Unbalanced", szFile, nLine);
}

void WENGINE::missingEOB(const char szFile[],
                    int nLine)
{
_errorEOB("Missing", szFile, nLine);
}

void WENGINE::_errorEOB(const char szMsg[],
                    const char szFile[], int nLine)
{
STR s(256);
sprintf((char*)(const char*)s,
    "%s \"%s\", line %d", szMsg, _FlagOff, nLine);
MessageBox(_hWnd, s, szFile, MB_ICONSTOP | MB_OK);
}

void WENGINE::runEditor(const char szFile[])
{
char szCmd[256];
WinExec(strcat(strcpy(szCmd, "NOTEPAD.EXE "), szFile),
        SW_SHOWNORMAL);
}
