/* ============ */
/* elaptime.c	*/
/* ============ */
#include <defcodes.h>
#include <sys/types.h>
#include <etime.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */

static	time_t	ClockTicks F((void));
extern	time_t	ElapsedTimer F((int, ETIME_STRU *));

# undef F
/* INDENT ON */

/* ==================================================================== */
/* ElapsedTimer - calculates elapsed time in seconds and fraction	*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
time_t
ElapsedTimer(int request, ETIME_STRU * TimeData)
# else
time_t
ElapsedTimer(request, TimeData)
int	request;
ETIME_STRU *TimeData;
# endif
{
    time_t  RetVal;

    switch (request)
    {
    default:
	AX(("ElapsedTimer: Unknown request = %.4x\n", request));
	RetVal = 0;
	break;

    case START_TIMER:
	{
	    PX(("START TIMER\n"));

	    TimeData->StartTick = ClockTicks();

	    while (TimeData->StartTick == ClockTicks())
	        ;

	    TimeData->StartTick = ClockTicks();

	    RetVal = 0;
	    break;
	}
    case READ_TIMER:
	{
	    TimeData->LastRead = ClockTicks();

	    RetVal = TimeData->LastRead - TimeData->StartTick;
	    break;
	}
    }

    return(RetVal);
}
#include <dos.h>

# if _MSC_VER == 700
#	define INTERRUPT(name) void (interrupt far *name)()
# else
#	define INTERRUPT(name) void (interrupt far *name)(void)
# endif

#define GETVECT _dos_getvect
#define SETVECT _dos_setvect

#define MK_FP(segment, offset) ((void far *) \
             (((unsigned long)(segment) << 16) | (unsigned) (offset)))

/* ------------------------------- */
/* Use Int70 1ms clock by default. */
/* Use Int1C 55ms clock if 0.	   */
/* ------------------------------- */
static
int	RealTimeClockFlag = 1;

/* --------------------------- */
/* milliseconds per clock tick */
/* --------------------------- */
static
int	MsecPerTick;

/* -------------------------------------------------- */
/* clock tick counter returned by ClockTicks function */
/* -------------------------------------------------- */
static  time_t	ClockTickCounter;

static	INTERRUPT(OldInt70);
static	INTERRUPT(OldInt1C);

/* =============================================================== */
/* Interrupt 70 timer service (gets control 1024 times/sec or 1ms) */
/* =============================================================== */
static void interrupt far
Int70(void)
{
    int far *counter = MK_FP(0x40, 0x9e);
    *counter = 0xffff;
    ClockTickCounter++;
    OldInt70();				/* pass interrupt on */
}

/* ========================= */
/* Reset Interrupt 70 vector */
/* ========================= */
static void
ResetInt70(void)
{
    union REGS regs;
    regs.h.ah = 0x83;
    regs.h.al = 0x01;
    int86(0x15, &regs, &regs);
    SETVECT(0x70, OldInt70);
}

/*
/* ================================================================ */
/* Interrupt 1C timer service (gets control 18.2 times/sec or 55ms) */
/* ================================================================ */
static void interrupt far
Int1C(void)
{
    ClockTickCounter++;
    OldInt1C();
}

/* ========================= */
/* Reset Interrupt 1C vector */
/* ========================= */
static void
ResetInt1C(void)
{
    SETVECT(0x1C, OldInt1C);
}

/* ================================================================= */
/* Interrupt 23 Ctrl Break service (activated on Ctl Break or Ctl C) */
/* ================================================================= */
static void interrupt far
Int23(void)
{
    exit(0);				/* perform normal exit so interrupt
					 * vectors can be reset */
}
/* ================================================================= */
/* ClockTicks - Returns no. clock ticks occurring since first called */
/* ================================================================= */
static	time_t
ClockTicks(void)
{
    static char flag, first_time = '\xff';
    char far *fp;
    union REGS regs;
    struct SREGS sregs;

    /* ----------------------------------------- */
    /* check to see if this is first time called */
    /* ----------------------------------------- */
    if (first_time)
    {
	first_time = 0;
	/* ------------------------------------------- */
	/* perform normal exit on Ctrl C or Ctrl Break */
	/* ------------------------------------------- */
	SETVECT(0x23, Int23);

	/* ---------------------------------------------- */
	/* Trap real time clock interrupt 0x70 (1024/sec) */
	/* ---------------------------------------------- */
	OldInt70 = GETVECT(0x70);
	SETVECT(0x70, Int70);

	/* ----------------------------------------- */
	/* enable real time clock via interrupt 0x15 */
	/* ----------------------------------------- */
	regs.h.ah = 0x83;
	regs.h.al = 0x00;
	regs.x.cx = regs.x.dx = 0xffff;
	fp = &flag;
	sregs.es = FP_SEG(fp);
	regs.x.bx = FP_OFF(fp);

	if (RealTimeClockFlag != 0)
	    int86x(0x15, &regs, &regs, &sregs);
	else
	    regs.x.cflag = 1;

	/* ------------------------------------------------ */
	/* check to see if real time clock has been enabled */
	/* ------------------------------------------------ */
	if (regs.x.cflag == 0)
	{
	    /* ------------------------------------------ */
	    /* use Interrupt 70 clock with 1ms resolution */
	    /* ------------------------------------------ */
	    MsecPerTick = 1;

	    /* --------------------------------------------------- */
	    /* reset interrupt vector 0x70 when program terminates */
	    /* --------------------------------------------------- */
	    atexit(ResetInt70);
	}
	else
	{
	    /* ------------------------------------------- */
	    /* use Interrupt 1C clock with 55ms resolution */
	    /* ------------------------------------------- */
	    MsecPerTick = 55;

	    /* --------------------------- */
	    /* reset interrupt vector 0x70 */
	    /* --------------------------- */
	    SETVECT(0x70, OldInt70);

	    /* ----------------------------------------- */
	    /* Trap 8253 timer interrupt 0x1C (18.2/sec) */
	    /* ----------------------------------------- */
	    OldInt1C = GETVECT(0x1C);
	    SETVECT(0x1C, Int1C);

	    /* --------------------------------------------------- */
	    /* reset interrupt vector 0x1C when program terminates */
	    /* --------------------------------------------------- */
	    atexit(ResetInt1C);
	}
    }
    return ClockTickCounter;
}

