/* ============ */
/* ssort.c	*/
/* ============ */
#include <defcodes.h>
#include <assert.h>
/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define	F( P )	P
# else
#	define	F( P )	()
# endif
/* INDENT OFF */
extern	void	ssort F((void *, size_t, size_t,
			int (*)(const void *, const void *)));
static	void	ShellSort F((long));
static	void	Swap F((char *, char *));

static	int	(*Cmpr) F((const void *, const void *));
# undef F

/* INDENT ON */

extern	long	SwapCtr;

static	size_t	DataWidth;
static	char	*MyBase;

#define CMPR(a, b) (*Cmpr)(a, b)
/* ==================================================================== */
/* ssort - sort a set of elements by the Shell sort method		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
void
ssort(void *Base, size_t Num, size_t Width,
	int(*Compare) (const void *, const void *))
# else
void
ssort(Base, Num, Width, Compare)
void   *Base;
size_t	Num;
size_t	Width;
int	(*Compare)();
# endif
{
    Cmpr = Compare;
    DataWidth = Width;
    MyBase = Base;

    ShellSort((long)Num);
}
/* ==================================================================== */
/* ShellSort - executes the Shell sort (Decreasing Increment) algorithm */
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
static void
ShellSort(long Num)
# else
static void
ShellSort(Num)
long	Num;
# endif
{
    long    Gap;		/* Sort Gap Control	*/

    /* ----------------------------------------------- */
    /* Calculate starting gap as recommended by Knuth. */
    /* ----------------------------------------------- */
# if defined(GAPFAC_2)		/* Hibbard & Knuth   */
#	define	DVSR	2	/* Sort Loop Divisor */
#	define	GAPDIV	8       /* Start Gap Divisor */
# else				/* Knuth (3^k - 1)/2 */
#	define	DVSR    3
#	define	GAPDIV	9
# endif

    for (Gap = 1; Gap <= Num/GAPDIV; Gap = DVSR*Gap + 1)
	;

    for ( ; Gap > 0; Gap /= DVSR)
    {
	long	GapIncr;	/* No. Bytes in Gap   */
	long    Inner, Outer;	/* Sort Loop Controls */
	char    *InnerAdr,	/* Inner Loop Pointer */
		*NextAdr,	/* Inner Loop Pointer */
		*OuterAdr,	/* Outer Loop Pointer */
		*StartAdr;	/* Outer Loop Pointer */

	D1("Gap = %ld\n", Gap);

	GapIncr  = Gap * DataWidth;
	StartAdr = MyBase + GapIncr;

	for (Outer = Gap + 1; Outer <= Num; ++Outer)
	{
	    OuterAdr = StartAdr;
	    StartAdr += DataWidth;

	    InnerAdr = OuterAdr;

	    for (Inner = Outer - Gap; Inner > 0; Inner -= Gap)
	    {
		NextAdr  = InnerAdr;
		InnerAdr -= GapIncr;

		if (0 >= CMPR(InnerAdr, NextAdr))
		{
		    break;
		}

		Swap(InnerAdr, NextAdr);
	    }
	}
    }
}
/* ==================================================================== */
/* Swap - exchanges two data elements each of DataWidth bytes		*/
/* ==================================================================== */
# if defined(__STDC__) || defined(__PROTO__)
PRIVATE	void
Swap(char  * Elem1, char  * Elem2)
# else
PRIVATE void
Swap(Elem1, Elem2)
char  *Elem1;
char  *Elem2;
# endif
# if !defined(MAX_SWAP)
#	define	MAX_SWAP	256
# endif
{
    extern long SwapCtr;
    extern size_t DataWidth;

    ++SwapCtr;

    /* ----------------------------- */
    /* Swap in Most Efficient Manner */
    /* ----------------------------- */
    switch (DataWidth)
    {
    case 1:
	{
	    char    OneXfer;
	    OneXfer = *Elem1;
	    *Elem1 = *Elem2;
	    *Elem2 = OneXfer;
	    break;
	}
    case 2:
	{
	    short   TwoXfer;
	    TwoXfer = *(short *) Elem1;
	    *(short *) Elem1 = *(short *) Elem2;
	    *(short *) Elem2 = TwoXfer;
	    break;
	}
    case 4:
	{
	    long    FourXfer;
	    FourXfer = *(long *) Elem1;
	    *(long *) Elem1 = *(long *) Elem2;
	    *(long *) Elem2 = FourXfer;
	    break;
	}
    default:
	{
	    char    TempBuf[MAX_SWAP];
	    size_t  CopySize, XferSize;

	    /* ---------------------------------- */
	    /* Copy as much as possible each pass */
	    /* ---------------------------------- */
	    for (XferSize = DataWidth; 0 < XferSize; XferSize -= CopySize)
	    {
		CopySize = (XferSize < sizeof(TempBuf)) ? XferSize :
		    sizeof(TempBuf);

		memcpy(TempBuf, Elem1, CopySize);
		memcpy(Elem1, Elem2, CopySize);
		memcpy(Elem2, TempBuf, CopySize);
		Elem1 += CopySize, Elem2 += CopySize;
	    }
	    break;
	}
    }
}
# if defined(TEST)
#include "tsrtdefs.h"
# if defined(SORT_NAME)
# else
#	define	SORT_NAME	ssort
# endif
void
main(int argc, char **argv)
{
    SORT_TEST_STRU  SortParms;

    SortParms.argc	= argc;
    SortParms.argv	= argv;
    SortParms.SortFun	= SORT_NAME;
    SortParms.OKCodes	= (char *) NULL;
    SortParms.ExecName	= DQ(SORT_NAME);
    SortParms.ExecLabel = "Shellsort";

    tstsort(&SortParms);
}
# endif
