//========================= AQTEST.CPP ==================================
//  AutoQueue Class Test and Example File.
//  This presents a series of examples for the use of AutoQueueMessage.
//=======================================================================
#include "AQMSG.HPP"
#include <iostream.h>

// Local Function Prototype
void ListMessageQueues(AutoQueueMessage* List1, AutoQueueMessage* List2);

void main()
{
  AutoQueueMessage* pMessage = 0;
  AutoQueueMessage* NonLinked;
  AutoQueueMessage* NonLinked2;

  // -- Demonstrate stand alone (non-linked) instance of AutoQueueMessage --
  cout << "CREATE NON-LINKED INSTANCE and show its contents." << endl;
  NonLinked = new AutoQueueMessage(6, (string)"Hello World!");
  if(NonLinked)           // Make sure NonLinked exists.
    NonLinked->List();    // List contents of this non-linked instance.
  else
    cout << "The Non-Linked instance didn't create..." << endl;
  cout << endl;           // Add a blank line separator to output listing.

  // -- Copy previously created non-linked entry to a new stand alone entry --
  if(NonLinked)
  { cout << "COPY STAND ALONE ENTRY to STAND ALONE ENTRY." << endl;
    NonLinked2 = new AutoQueueMessage(NonLinked);
    if(NonLinked2)        // If it created, show contents of both.
    { cout << "  Source Instance: ";
      NonLinked->List();  // List of source.
      cout << "  New Instance   : ";
      NonLinked2->List(); // List of new entry.
    }
    else
      cout << "New stand alone entry failed to create..." << endl;

    // To effect a MOVE operation, include a delete of the source instance.
    delete NonLinked;
  }
  cout << endl;

  // -- CREATE 2 QUEUES --
  // Allocate Message list pointers. (Initialize to 0)
  AutoQueueMessage* pAQM_List1 = 0;
  AutoQueueMessage* pAQM_List2 = 0;

  // -- ADD NODES to a QUEUE --
  cout << "ADD NODES - Add 4 instances to List 1, none to list 2." << endl;
  (void) new AutoQueueMessage(&pAQM_List1, 1, (string)"Message 1");
  (void) new AutoQueueMessage(&pAQM_List1, 2, (string)"Message 2");
  (void) new AutoQueueMessage(&pAQM_List1, 3, (string)"Message 3");
  (void) new AutoQueueMessage(&pAQM_List1, 4, (string)"Message 4");
  ListMessageQueues(pAQM_List1, pAQM_List2);      // Show Queues

  // -- COPY STAND ALONE NODE to a QUEUE --
  cout << "COPY STAND ALONE ENTRY to List 2." << endl;
  (void) new AutoQueueMessage(&pAQM_List2, NonLinked2);
  ListMessageQueues(pAQM_List1, pAQM_List2);      // Show Queues

  // -- COPY QUEUE NODE to STAND ALONE ENTRY --
  // Find record in pAQM_List1 whos Number_ value is 4 and COPY
  // it to a stand alone instance.
  cout << "COPY NODE From List 1 to a STAND ALONE instance where Number_ = 4."
       << endl;
  if(pAQM_List1)                                       // If entries,
    if((pMessage = pAQM_List1->FindByNumber(4)) != 0)  // find match and
    { NonLinked = new AutoQueueMessage(pMessage);      // create copy.
      if(NonLinked)                                    // If it worked,
      { cout << "  New Instance: ";
        NonLinked->List();                             // List of new entry.
        cout << endl;
      }
    }

  // -- COPY QUEUE NODE to ANOTHER QUEUE --
  // Find record in pAQM_List1 whos Number_ value is 2 and COPY to pAQM_List2.
  cout << "COPY NODE From List 1 to List 2 where Number_ = 2." << endl;
  if(pAQM_List1)                                          // If entries,
    if((pMessage = pAQM_List1->FindByNumber(2)) != 0)     // find match and
      (void) new AutoQueueMessage(&pAQM_List2, pMessage); // create copy.
  ListMessageQueues(pAQM_List1, pAQM_List2);      // Show Queues

  // -- MOVE NODE from ONE QUEUE to ANOTHER QUEUE --
  // Find record in pAQM_List1 whos Number_ value is 3 and MOVE to pAQM_List2.
  cout << "MOVE NODE From List 1 to List 2 where Number_ = 3." << endl;
  if(pAQM_List1)                                          // If entries,
    if((pMessage = pAQM_List1->FindByNumber(3)) != 0)     // find match
    { // Create new message.
      (void) new AutoQueueMessage(&pAQM_List2, pMessage); // make copy and
      delete pMessage;                                    // delete original.
    }
  ListMessageQueues(pAQM_List1, pAQM_List2);              // Show Queues

  // -- DELETE NODE from a QUEUE --
  // Delete the record in List 1 whos Number_ value = 1.
  cout << "DELETE NODE From List 1 where Number_ = 1" << endl;
  if(pAQM_List1)                                          // If entries
    if((pMessage = pAQM_List1->FindByNumber(1)) != 0)     // find match
      delete pMessage;                                    // and delete.
  ListMessageQueues(pAQM_List1, pAQM_List2);              // Show Queues

  // -- EMPTY a QUEUE --
  cout << "EMPTY LIST  (Empty both lists)" << endl;
  while(pAQM_List1)                            // While an entry exists,
    delete pAQM_List1;                         // delete it.

  // Empty List 2
  while(pAQM_List2)                            // While an entry exists,
    delete pAQM_List2;                         // delete it.
  ListMessageQueues(pAQM_List1, pAQM_List2);   // Show Queues

  // Delete stand alone instances.
  delete NonLinked;
  delete NonLinked2;
}  // end main

// ===== ListMessageQueues =====
//  List the contents of both AutoQueueMessage lists.
void ListMessageQueues(AutoQueueMessage* List1, AutoQueueMessage* List2)
{
  // -- DISPLAY CONTENTS of both QUEUES --
  cout << "----- List 1 -----" << endl;    // Title for List 1
  if(List1)                                // If elements exist,
    List1->List();                         //   Call list routine.
  else                                     // else
    cout << "  <list is empty>" << endl;   //   Let user know list is empty.
  cout << "----- List 2 -----" << endl;    // Title for List 2
  if(List2)                                // If elements exist,
    List2->List();                         //   Call list routine.
  else                                     // else
    cout << "  <list is empty>" << endl;   //   Let user know list is empty.
  cout << endl;                            // Trailer.
}
// end file AQTEST.CPP
