#include "RCDEFS.H"
#include <dir.h>
#include <string.h>
#include "WENGINE.HPP"

#if defined(CTL3D)
#include <ctl3D.h>
#endif

static const char szAppName[] 		= "CLASSGEN";
static const char StkDIR[]			="Dir";

static const char StkCCAO[]			="CCAO";
static const char StkNEWHANDLER[]	="NewHandler";
static const char StkCOUNTINST[]	="CountInst";
static const char StkVIRTDEST[]		="VirtDest";
static const char StkCRC[]			="CRC";

static HINSTANCE hInst;
static WSYM *pSym;

static inline int GetCheck(HWND hWnd, int nID){
return
	SendDlgItemMessage(hWnd, nID, BM_GETCHECK, 0, 0);
}

static inline void
SetCheck(HWND hWnd, int nID, BOOL bVal)
{
SendDlgItemMessage(hWnd, nID, BM_SETCHECK, bVal, 0);
}

static void Init(HWND hWnd);
static void Ok(HWND hWnd);

BOOL FAR PASCAL _export WMainDlgProc (HWND hWnd,
					unsigned iMessage,
					WPARAM wParam, LPARAM lParam)
{
switch(iMessage){
	case WM_INITDIALOG:
		Init(hWnd);
		break;

	case WM_COMMAND:
		if(HIWORD(lParam)==BN_CLICKED)
			switch(wParam){
				case IDR_CCAO_0:
				case IDR_CCAO_1:
				case IDR_CCAO_2:{
					for(int i = IDR_CCAO_0; i<= IDR_CCAO_2; i++)
						SetCheck(hWnd, i, i == wParam);
					}break;

				case IDOK:
					if(!SendDlgItemMessage(hWnd, IDE_NAME, EM_LINELENGTH, 0, 0L)){
						MessageBeep(0);
						SetFocus(GetDlgItem(hWnd, IDE_NAME));
						return TRUE;
						}
					Ok(hWnd);
					EndDialog(hWnd, TRUE);
					break;
				case IDCANCEL:
					EndDialog(hWnd, FALSE);
					break;
				}
		break;

	case WM_CLOSE:
		EndDialog(hWnd, TRUE);
		break;

	default:
	 return FALSE;
	}
return TRUE;
}

int PASCAL WinMain(HINSTANCE hInstance,
					 HINSTANCE, LPSTR , int )
{
#if defined(CTL3D)
Ctl3dRegister(hInstance);
Ctl3dAutoSubclass(hInstance);
#endif

hInst = hInstance;

pSym = new WSYM(szAppName);

DLGPROC lpfn = (DLGPROC)MakeProcInstance(
				(FARPROC)WMainDlgProc, hInst);
DialogBox(hInst, szAppName, NULL, lpfn);
FreeProcInstance((FARPROC)lpfn);

delete pSym;

#if defined(CTL3D)
Ctl3dUnregister(hInstance);
#endif

return 0;
}

static void Init(HWND hWnd)
{
char szBuf[300] = "";

SetDlgItemText(hWnd, IDE_NAME, "");
SendDlgItemMessage(hWnd, IDE_NAME, EM_LIMITTEXT, 8, 0L);

GetProfileString(szAppName, StkDIR, "C:\\", szBuf, 300);
SetDlgItemText(hWnd, IDE_DIR, szBuf);
SendDlgItemMessage(hWnd, IDE_DIR, EM_LIMITTEXT, 299, 0L);

SetCheck(hWnd, IDC_NEWHANDLER, pSym->get(StkNEWHANDLER));
SetCheck(hWnd, IDC_COUNTINST, pSym->get(StkCOUNTINST));
SetCheck(hWnd, IDC_CRC, pSym->get(StkCRC));
SetCheck(hWnd, IDC_VIRTDEST, pSym->get(StkVIRTDEST));
for(int i = IDR_CCAO_0; i<= IDR_CCAO_2; i++)
	SetCheck(hWnd, i, i-IDR_CCAO_0 ==  pSym->get(StkCCAO));
}

static void Ok(HWND hWnd)
{
char szName[10] = "";
char szBuf[300] = "";
char szOrig[300];

GetDlgItemText(hWnd, IDE_NAME, szName, 10);
GetDlgItemText(hWnd, IDE_DIR, szBuf, 300);
WriteProfileString(szAppName, StkDIR, szBuf);

pSym->set(StkNEWHANDLER, GetCheck(hWnd, IDC_NEWHANDLER));
pSym->set(StkCOUNTINST, GetCheck(hWnd, IDC_COUNTINST));
pSym->set(StkCRC, GetCheck(hWnd, IDC_CRC));
pSym->set(StkVIRTDEST, GetCheck(hWnd, IDC_VIRTDEST));
for(int i = IDR_CCAO_0; i<= IDR_CCAO_2; i++)
	if(GetCheck(hWnd, i))
		 pSym->set(StkCCAO, i-IDR_CCAO_0);

GetModuleFileName(hInst, szOrig, 300);
for(i = strlen(szOrig)-1; i >= 0; i--){
	if(szOrig[i] == ':' || szOrig[i] == '\\')
		break;
	}

szOrig[i] = 0;
if(szBuf[strlen(szBuf)-1] == '\\')
	szBuf[strlen(szBuf)-1] = 0;

STR HppTemplate(szOrig); HppTemplate += "\\__GEN__.HPP";
STR CppTemplate(szOrig); CppTemplate += "\\__GEN__.CPP";
WENGINE *pWeng = new WENGINE(HppTemplate, CppTemplate, hWnd);
pWeng->go(szBuf, szName, pSym);
delete pWeng;
}
