//------------------------------------------------------------------
// Flow.cpp - Definition of the gpFlowControl class.
//
// Copyright 1994 Prodis Incorporated.
//
// Purpose: The gpParser replaces syntactic patterns with tokens,
//          and extracts parameters from the syntax line.
//
// Architect: TDE
// Developer: AKJ
//
// Modification History:
//------------------------------------------------------------------

#include <stdlib.h>
#include <parser\flow.h>

struct ControlBlock
  {
    CBType nType;
    int lIsTrue;
    long nLineNum;
    ControlBlock *cbNext;
    ControlBlock (CBType nNewType, long nNewLine, int lNewTrue = 0)
        {nType = nNewType; lIsTrue = lNewTrue, nLineNum = nNewLine, cbNext = 0;}
    ControlBlock ( ) {nType = CB_NORMAL, lIsTrue = nLineNum = 0;  cbNext = 0;}    
  };
  
gpFlowControl::gpFlowControl ( ) 
  {
    cbTop = new ControlBlock(CB_NORMAL, 0, 1);
    pParser = new gpParser ();
    nState = 1;
  }
    
gpFlowControl::gpFlowControl (SyntaxList *lsNewTable) 
  {
    cbTop = new ControlBlock(CB_NORMAL, 0, 1);
    pParser = new gpParser (lsNewTable);
    nState = 1;
  }
  
int gpFlowControl::Parse (gpString &sLine, StringList &lsParms, int nLineNo)
  {
    int nReturn = pParser->Parse (sLine, lsParms);

    if (nReturn > TK_USERDEF)
        return (nState ? nReturn : TK_NOOP);
    else
      {
        switch (nReturn)
          {
            case TK_IF :
              PushOntoControlStack(CB_IF, nLineNo, 1);
              if (!nState)
                  nReturn = TK_NOOP;
              break;
                
            case TK_WHILE :
              PushOntoControlStack(CB_WHILE, nLineNo, 1);
              if (!nState)
                  nReturn = TK_NOOP;
              break;

            case TK_ELSE :
              {
                if (cbTop->nType != CB_IF)
                    if (!((cbTop->nType == CB_GOTO) && (cbTop->cbNext->nType ==CB_IF)))
                        return TK_MISMATCHED_ELSE;
                if (nState)
                  {
                    cbTop->nType = CB_ELSE;
                    cbTop->lIsTrue = !cbTop->lIsTrue;
                    cbTop->nLineNum = nLineNo;
                  }    
                else
                  {
                    ControlBlock *cb = PopOffControlStack();
                    PushOntoControlStack(CB_ELSE, nLineNo, (nState && (!cb->lIsTrue)));  
                    delete cb;
                    nReturn = TK_NOOP;
                  }  
                ResetState();
              }
              break;

            case TK_ENDIF :
                if ((cbTop->nType != CB_IF) && (cbTop->nType != CB_ELSE))
                    if (!((cbTop->nType == CB_GOTO) && 
                         ((cbTop->cbNext->nType == CB_IF) || 
                          (cbTop->cbNext->nType == CB_ELSE))))
                        return TK_MISMATCHED_ENDIF;
                        
              if (!nState)
                  nReturn = TK_NOOP;
              if ((cbTop->nType == CB_IF) || (cbTop->nType == CB_ELSE))
                  delete (PopOffControlStack());
              break;

            case TK_ENDWHILE :
              {
                if (cbTop->nType != CB_WHILE)
                    if (!((cbTop->nType == CB_GOTO) && (cbTop->cbNext->nType == CB_WHILE)))
                        return TK_MISMATCHED_ENDWHILE;
                    
                ControlBlock *cb;
                if (nState)
                  {
                    char cInt[32];
                    lsParms.AddItem(new gpString(itoa(cbTop->nLineNum, cInt, 10)));
                  }
                else
                    nReturn = TK_NOOP;    

                    
                CBType ct = cbTop->nType;
                if ((ct == CB_WHILE) || (ct == CB_IF) || (ct == CB_ELSE))
                  {    
                    cb = PopOffControlStack();
                    delete cb;
                  }  
                break;
              }
              
            case TK_GOTO :
              if (nState)
                {
                  int i;
                  sTargetLabel = lsParms[1];
                  for (i = 1; i <= lLabels.ListSize(); i++)
                    {
                      if (lLabels[i] == sTargetLabel)
                          break;
                    }      
                  if (i <= lLabels.ListSize())
                  //Label was found
                    {
                      char cInt[16];
                      lsParms.AddItem(new gpString (itoa(anLines[i-1], cInt, 10))); 
                      nReturn = TK_REWIND;
                    }
                  else
                   {
                     PushOntoControlStack(CB_GOTO, nLineNo, 0);
                     nReturn = TK_NOOP;
                   }   
                }
              break;

            case TK_LABEL :
              if (!lLabels.Seek(lsParms[1]))
                {
                  anLines[lLabels.ListSize()] = nLineNo;
                  lLabels.AddItem(new gpString(lsParms[1]));
                }  
              if (cbTop->nType == CB_GOTO)
                {
                  if (sTargetLabel == lsParms[1])
                    {
                      delete (PopOffControlStack());
                    }  
                }    
          }   
      }
        
    return nReturn;    
  }

void gpFlowControl::PushOntoControlStack (CBType cbType, int nLine, int lTrue)
  {
    ControlBlock *cbBlock = new ControlBlock(cbType, nLine, lTrue);
    cbBlock->cbNext = cbTop;
    cbTop = cbBlock;
    ResetState();
  }

ControlBlock *gpFlowControl::PopOffControlStack ( )
 {
   ControlBlock *cbReturn = cbTop;
   if (cbTop)
       cbTop = cbTop->cbNext;
   ResetState();    
   return cbReturn;
 }

void gpFlowControl::PostExpressionValue (int lTrue)
  {
    cbTop->lIsTrue = lTrue;
    ResetState ();
  }
  
void gpFlowControl::ResetState ( )
  {
    nState = cbTop->lIsTrue;
  }
  
void gpFlowControl::AddSyntax (char *cExpress, int nNewToken)
  {
    pParser->AddSyntax (cExpress, nNewToken);
  }  

void gpFlowControl::AddSyntax (Syntax *pNew)
  {
    pParser->AddSyntax (pNew);
  }

  
