//------------------------------------------------------------------
// gpSList.cpp - Definition of the StringList class.
//
// Copyright 1994 Prodis Incorporated.
//
// Architect: TDE
// Developer: AKJ
// 
// Modification History:
//------------------------------------------------------------------

#include <gpstring\gpslist.h>

StringList::StringList ( ): List ()
  {
    pFirst = pLast = pCurrent = 0;
  }
         
StringList::~StringList ( )
  {
    for (gpString *eString = Reset ();
         eString;
         eString = GetNext ()
        )
         delete eString;            
  }
  
gpString *StringList::Seek (gpString &sName)
  {
    int lFound = 0;

    Reset ();
    while (!lFound && pCurrent)
      {
        if (*(Peek ()) == sName )
            lFound = 1;
        else
            GetNext ();
      }
   
    return pCurrent;
  }

gpString *StringList::Seek (char *cName)
  {
    gpString sName (cName);
    return (Seek (sName) );
  }

gpString *StringList::Reset ( ) 
  {
    return (pFirst = pCurrent = (gpString *)List::Reset () );
  }

gpString *StringList::GetNext ( ) 
  {
    return (pCurrent = (gpString *)List::GetNext () );
  }

gpString *StringList::AddItem (gpString *eNew) 
  {
    pLast = pCurrent = (gpString *)List::AddItem (eNew);
        
    if (!pFirst)
        pFirst = pLast;
        
    return (pCurrent);  
  }

gpString *StringList::Peek ( ) 
  {
    return pCurrent;
  } 

gpString *StringList::Seek (int nSequence)
  {
    if (nListSize < nSequence)
        return 0;
    Reset (); 
    for (int i = 1; i < nSequence; GetNext (), i++);
    return pCurrent;      
  }

gpString &StringList::operator[] (int nSequence)
  {
    return (*(Seek (nSequence)));
  }

void StringList::Clear ( )
  {
    for (gpString *eString = Reset ();
         eString;
         eString = GetNext ()
        )
         delete eString;
    List::Clear ();
    pFirst = pLast = pCurrent = 0;
  }  

