/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/2case.c 1.5 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: 2case.c $
** Revision 1.5  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.4  1995/04/30 16:56:25  dpuryear
** Was not preseting sml_err to SML_SUCCESS - fixed.
**
** Revision 1.3  1995/04/30 16:45:31  dpuryear
** Removed the error checking in the functions - not needed.
**
** Revision 1.2  1995/04/25 00:40:04  dpuryear
** Changed the for() loop to a while() loop (minor speed enhancement)..
** improved some internal documentation. Minor revisions.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Alters the case of a character:
**
** sml_n2lower()
** sml_n2upper()
** #sml_2upper()
** #sml_2lower()
*/

/*
** sml_n2lower()        Lower the case of n characters within a string
**
** Input:
**      - str = string
**      - pos = offset within string to start
**      - n = number of characters to lowercase
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_n2lower(char *str, size_t pos, size_t n)
{
      register size_t N = pos + n;

      sml_serr(SML_SUCCESS);

      for ( ; pos < N; pos++ )
            str[pos] = (char) tolower(str[pos]);

      return (str);
}

/*
** sml_n2upper()        Upper the case of n characters within a string
**
** Input:
**      - str = string
**      - pos = offset within string to start
**      - n = number of characters to uppercase
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_n2upper(char *str, size_t pos, size_t n)
{
      register size_t N = pos + n;

      sml_serr(SML_SUCCESS);

      for ( ; pos < N; pos++ )
            str[pos] = (char) tolower(str[pos]);

      return (str);
}
