/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/create.c 1.3 1995/05/02 06:05:16 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: create.c $
** Revision 1.3  1995/05/02 06:05:16  dpuryear
** *** empty log message ***
**
** Revision 1.2  1995/04/25 00:54:09  dpuryear
** Touch-ups for v2.0 release
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** Dynamically create/destroy memory for a string:
**
** sml_create()
** sml_csize()
** sml_ccopy()
** sml_nmcat()
** sml_mcat()
** #sml_free()
*/

/*
** sml_create()         Create a string with optional initialization/size
**
** Input:
**      - size = length of new string: 0 if size will be strlen(init_str)
**      - init_str = initializer string: NULL for no initializer string
**
** Output:
**      - pointer to new string or NULL if error
*/

extern char * sml_create(size_t size, char *init_str)
{
      size_t n;   /* size for new string  */
      char *buf;  /* malloc()'d memory    */

      sml_serr(SML_SUCCESS);

      if ( size == 0 && init_str != NULL )
            n = strlen(init_str);
      else if ( size != 0 && init_str != NULL )
      {
            size_t len = strlen(init_str);
            n = SML_iMAX(size, len);
      }
      else
            n = size;

      /* allocate memory for it */
      if ( (buf = (char *) malloc(n)) == NULL )
      {
            sml_serr(SML_NOMEM);
            return (NULL);
      }

      if ( init_str != NULL )
            strcpy(buf, init_str);
      else
            *buf = NUL;

      return (buf);
}

/*
** sml_csize()          Create empty string
**
** Input:
**      - n = size of string to create
**
** Output:
**      - pointer to new string or NULL if error
*/

extern char * sml_csize(size_t n)
{
      sml_serr(SML_SUCCESS);

      return (calloc(n + 1, sizeof(char)));
}

/*
** sml_ccopy()          Create Copy
**
** Input:
**      - str = string to be copied
**
** Output:
**      - pointer to new string or NULL if error
*/

extern char * sml_ccopy(char *str)
{
      char *buf = (char *) malloc(strlen(str) + 1);

      if ( buf == NULL )
      {
            sml_serr(SML_NOMEM);
            return (NULL);
      }
      else
      {
            sml_serr(SML_SUCCESS);
            return (strcpy(buf, str));
      }
}

/*
** sml_nmcat()          Multiple string concatenation (create new string)
**
** Input:
**      - str = first string
**      - ... = following strings
**      - NULL must be last argument passed
**
** Output:
**      - pointer to new string or NULL if fail condition
*/

extern char * sml_nmcat(char *str, ...)
{
      size_t len;       /* total length for string */
      va_list argptr;   /* for use in va           */
      char *next;       /* next string in va       */
      char *buf;        /* new string              */

      sml_serr(SML_SUCCESS);

      /* get size for string to create */

      va_start(argptr, str);

      len = strlen(str);
      while ( (next = va_arg(argptr, char *)) != NULL )
            len += strlen(next);

      va_end(argptr);

      /* append passed strings onto new string */

      va_start(argptr, str);

      /* create new string, using first string as initializer */
      if ( (buf = sml_create(len, str)) == NULL )
            return (NULL);

      /* concatenate passed strings onto new string */
      while ( (next = va_arg(argptr, char *)) != NULL )
            strcat(buf, next);

      va_end(argptr);

      return (buf);
}

/*
** sml_mcat()          Multiple string concatenation (use old string)
**
** Input:
**      - str = string
**      - ... = string(s) to append
**      - NULL must be last argument passed
**
** Output:
**      - pointer to passed string or NULL if error
*/

extern char * sml_mcat(char *str, ...)
{
      va_list argptr;
      char *next;

      sml_serr(SML_SUCCESS);

      va_start(argptr, str);

      while ( (next = va_arg(argptr, char *)) != NULL )
            strcat(str, next);

      va_end(argptr);

      return (str);
}
