/*
** Copyright (C) 1994-1995 by Dustin Puryear. All rights reserved.
*/

/*
** $Header: C:/PROJ/SML/RCS/globals.c 1.3 1995/04/25 16:48:57 dpuryear Exp dpuryear $
**
** $Locker: dpuryear $
**
** $Log: globals.c $
** Revision 1.3  1995/04/25 16:48:57  dpuryear
** Added SML_NOTOK error condition for use with token functions.
**
** Revision 1.2  1995/04/21 00:44:53  DPURYEAR
** SML_NOINIT was removed from enumerated SML_ERROR type.
**
** Revision 1.1  1995/03/27 23:50:07  dpuryear
** Initial revision
**
*/

#include "sml.h"

/*
** SML globals:
**
** sml_inited
** sml_err
*/

/*
** sml_inited
**
** Determines if SML has been initialized with sml_init()
**
**      0   if not initialized
**      !0  if initialized
*/

char sml_inited = 0;

/*
** sml_err
**
** Error condition created by last SML operation
**
**      SML_SUCCESS     op was successful
**      SML_BADARG      op was passed a bad argument
**      SML_NOMEM       not enough memory
**      SML_BADPOS      op passed bad position
**      SML_NOSS        op dealing with a string failed
**      SML_NOTOK       op dealing with a token failed
*/

SML_ERROR sml_err = SML_SUCCESS;
